/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.ColorType;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthGraphicsUtils;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.javax.swing.plaf.synth.SynthStyle;
import com.bsiag.sun.swing.plaf.synth.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import sun.swing.SwingUtilities2;

class SynthInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements SynthUI,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected JPopupMenu systemPopupMenu;
    private SynthStyle style;
    private int titleSpacing;
    private int buttonSpacing;
    private int titleAlignment;

    public SynthInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    public SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        if (this.frame != null && this.frame.isSelected()) {
            return 512;
        }
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    protected void addSubComponents() {
        this.iconButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maxButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this);
        this.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(this, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.maxIcon = this.style.getIcon(context, "InternalFrameTitlePane.maximizeIcon");
            this.minIcon = this.style.getIcon(context, "InternalFrameTitlePane.minimizeIcon");
            this.iconIcon = this.style.getIcon(context, "InternalFrameTitlePane.iconifyIcon");
            this.closeIcon = this.style.getIcon(context, "InternalFrameTitlePane.closeIcon");
            this.titleSpacing = this.style.getInt(context, "InternalFrameTitlePane.titleSpacing", 2);
            this.buttonSpacing = this.style.getInt(context, "InternalFrameTitlePane.buttonSpacing", 2);
            String alignString = (String)this.style.get(context, "InternalFrameTitlePane.titleAlignment");
            this.titleAlignment = 10;
            if (alignString != null) {
                if ((alignString = alignString.toUpperCase()).equals("TRAILING")) {
                    this.titleAlignment = 11;
                } else if (alignString.equals("CENTER")) {
                    this.titleAlignment = 0;
                }
            }
        }
        context.dispose();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this);
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        JInternalFrame.JDesktopIcon di = this.frame.getDesktopIcon();
        if (di != null && di.getComponentPopupMenu() == this.systemPopupMenu) {
            di.setComponentPopupMenu(null);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JPopupMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        mi.setMnemonic('R');
        mi = menu.add(this.moveAction);
        mi.setMnemonic('M');
        mi = menu.add(this.sizeAction);
        mi.setMnemonic('S');
        mi = menu.add(this.iconifyAction);
        mi.setMnemonic('n');
        mi = menu.add(this.maximizeAction);
        mi.setMnemonic('x');
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mi.setMnemonic('C');
    }

    @Override
    protected void showSystemMenu() {
    }

    @Override
    public void paintComponent(Graphics g) {
        SynthContext context = this.getContext(this);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintInternalFrameTitlePaneBackground(context, g, 0, 0, this.getWidth(), this.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        String title = this.frame.getTitle();
        if (title != null) {
            int minX;
            int maxX;
            SynthStyle style = context.getStyle();
            g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
            g.setFont(style.getFont(context));
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.frame, g);
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            JButton lastButton = null;
            if (this.frame.isIconifiable()) {
                lastButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                lastButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                lastButton = this.closeButton;
            }
            boolean ltr = SynthLookAndFeel.isLeftToRight(this.frame);
            int titleAlignment = this.titleAlignment;
            if (ltr) {
                maxX = lastButton != null ? lastButton.getX() - this.titleSpacing : this.frame.getWidth() - this.frame.getInsets().right - this.titleSpacing;
                minX = this.titleSpacing;
            } else {
                minX = lastButton != null ? lastButton.getX() + lastButton.getWidth() + this.titleSpacing : this.frame.getInsets().left + this.titleSpacing;
                maxX = 0 - this.titleSpacing;
                if (titleAlignment == 10) {
                    titleAlignment = 11;
                } else if (titleAlignment == 11) {
                    titleAlignment = 10;
                }
            }
            String clippedTitle = this.getTitle(title, fm, maxX - minX);
            if (clippedTitle == title) {
                if (titleAlignment == 11) {
                    minX = maxX - style.getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, title);
                } else if (titleAlignment == 0) {
                    int width = style.getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, title);
                    minX = Math.max(minX, (this.getWidth() - width) / 2);
                    minX = Math.min(maxX - width, minX);
                }
            }
            style.getGraphicsUtils(context).paintText(context, g, clippedTitle, minX, baseline - fm.getAscent(), -1);
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintInternalFrameTitlePaneBorder(context, g, x, y, w, h);
    }

    @Override
    protected LayoutManager createLayout() {
        SynthContext context = this.getContext(this);
        LayoutManager lm = (LayoutManager)this.style.get(context, "InternalFrameTitlePane.titlePaneLayout");
        context.dispose();
        return lm != null ? lm : new SynthTitlePaneLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this) {
            if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
                this.updateStyle(this);
            }
        } else if (evt.getPropertyName() == "frameIcon") {
            this.updateMenuIcon();
        }
    }

    private void updateMenuIcon() {
        Icon frameIcon = this.frame.getFrameIcon();
        SynthContext context = this.getContext(this);
        if (frameIcon != null) {
            Dimension maxSize = (Dimension)context.getStyle().get(context, "InternalFrameTitlePane.maxFrameIconSize");
            int maxWidth = 16;
            int maxHeight = 16;
            if (maxSize != null) {
                maxWidth = maxSize.width;
                maxHeight = maxSize.height;
            }
            if ((frameIcon.getIconWidth() > maxWidth || frameIcon.getIconHeight() > maxHeight) && frameIcon instanceof ImageIcon) {
                frameIcon = new ImageIcon(((ImageIcon)frameIcon).getImage().getScaledInstance(maxWidth, maxHeight, 4));
            }
        }
        context.dispose();
    }

    class SynthTitlePaneLayout
    implements LayoutManager {
        SynthTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            Dimension pref;
            SynthContext context = SynthInternalFrameTitlePane.this.getContext(SynthInternalFrameTitlePane.this);
            int width = 0;
            int height = 0;
            int buttonCount = 0;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                pref = SynthInternalFrameTitlePane.this.closeButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                pref = SynthInternalFrameTitlePane.this.maxButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                pref = SynthInternalFrameTitlePane.this.iconButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            width += Math.max(0, (buttonCount - 1) * SynthInternalFrameTitlePane.this.buttonSpacing);
            FontMetrics fm = SynthInternalFrameTitlePane.this.getFontMetrics(SynthInternalFrameTitlePane.this.getFont());
            SynthGraphicsUtils graphicsUtils = context.getStyle().getGraphicsUtils(context);
            String frameTitle = SynthInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? graphicsUtils.computeStringWidth(context, fm.getFont(), fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = graphicsUtils.computeStringWidth(context, fm.getFont(), fm, String.valueOf(frameTitle.substring(0, 3)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            height = Math.max(fm.getHeight() + 2, height);
            width += SynthInternalFrameTitlePane.this.titleSpacing + SynthInternalFrameTitlePane.this.titleSpacing;
            Insets insets = SynthInternalFrameTitlePane.this.getInsets();
            context.dispose();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }

        private int center(Component c, Insets insets, int x, boolean trailing) {
            Dimension pref = c.getPreferredSize();
            if (trailing) {
                x -= pref.width;
            }
            c.setBounds(x, insets.top + (SynthInternalFrameTitlePane.this.getHeight() - insets.top - insets.bottom - pref.height) / 2, pref.width, pref.height);
            if (pref.width > 0) {
                if (trailing) {
                    return x - SynthInternalFrameTitlePane.this.buttonSpacing;
                }
                return x + pref.width + SynthInternalFrameTitlePane.this.buttonSpacing;
            }
            return x;
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insets = c.getInsets();
            if (SynthLookAndFeel.isLeftToRight(SynthInternalFrameTitlePane.this.frame)) {
                int x = SynthInternalFrameTitlePane.this.getWidth() - insets.right;
                if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.closeButton, insets, x, true);
                }
                if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.maxButton, insets, x, true);
                }
                if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.iconButton, insets, x, true);
                }
            } else {
                int x = insets.left;
                if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.closeButton, insets, x, false);
                }
                if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.maxButton, insets, x, false);
                }
                if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                    int n = this.center(SynthInternalFrameTitlePane.this.iconButton, insets, x, false);
                }
            }
        }
    }
}

