package com.bsiag.scout.rt.ui.swing.rayo.form.fields.groupbox;

import java.awt.Dimension;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JSection;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.BackgroundBorder;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.SwingScoutGroupBox;

public class RayoSwingScoutGroupBox extends SwingScoutGroupBox {
  private static final IScoutLogger LOG = ScoutLogManager.getLogger(RayoSwingScoutGroupBox.class);

  private JLabel m_swingTitle;

  private void installTitle(JPanelEx swingBox) {
    if (!m_containerBorderVisible || IGroupBox.BORDER_DECORATION_EMPTY.equals(m_containerBorderDecoration)) {
      if (m_swingTitle != null) {
        swingBox.remove(m_swingTitle);
      }
    }
    else if (!StringUtility.hasText(m_containerLabel)) {
      if (m_swingTitle != null) {
        m_swingTitle.setText(null);
      }
    }
    else {
      if (m_swingTitle == null) {
        m_swingTitle = new JLabel(m_containerLabel);
        m_swingTitle.setName("Synth.GroupBoxTitle");
        swingBox.add(m_swingTitle, BorderLayoutEx.NORTH);
      }
      else {
        m_swingTitle.setText(m_containerLabel);
      }
    }
  }

  /**
   * complete override
   */
  @Override
  protected void installSwingContainerBorder() {
    if (!isSection()) {
      JPanelEx swingBox = (JPanelEx) getSwingField();
      installTitle(swingBox);
    }
    if (m_containerBorderVisible) {
      m_containerBorderInstalled = true;
      if (IGroupBox.BORDER_DECORATION_SECTION.equals(m_containerBorderDecoration)) {
        // section
        JSection section = (JSection) getSwingContainer();
        section.setText(m_containerLabel);
      }
      else if (IGroupBox.BORDER_DECORATION_LINE.equals(m_containerBorderDecoration)) {
        if (m_containerImage != null) {
          Icon icon = getSwingEnvironment().getIcon(m_containerImage);
          if (icon != null) {
            // set minimum container size
            getSwingContainer().setMinimumSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
          }
          else {
            // reset minimum container size
            getSwingContainer().setMinimumSize(null);
          }
          Border bgBorder = new BackgroundBorder(icon, m_containerImageHAlign, m_containerImageVAlign);
          getSwingContainer().setBorder(bgBorder);
        }
      }
    }
    else {
      getSwingBodyPart().setName(null);
      //button bar has always insets
    }
  }
}
