/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.form.fields.datefield;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;

import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup.IconState;
import org.eclipse.scout.rt.ui.swing.ext.decoration.IDecoration;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.datefield.SwingScoutDateField;

import com.bsiag.scout.rt.ui.swing.rayo.ext.RayoTextFieldWithDecorationIcons;

public class RayoSwingScoutDateField extends SwingScoutDateField {

  private IconGroup m_notOverlapIconGroup;
  private IconGroup m_overlapIconGroup;

  public RayoSwingScoutDateField() {
    super();
  }

  @Override
  protected JTextFieldWithDecorationIcons createDateField(JComponent container) {
    m_notOverlapIconGroup = new IconGroup(getSwingEnvironment(), AbstractIcons.DateFieldDate);
    m_overlapIconGroup = new IconGroup(getSwingEnvironment(), AbstractIcons.DateFieldDate);
    m_overlapIconGroup.setIcon(IconState.NORMAL, getSwingEnvironment().getIcon(AbstractIcons.DateFieldDate + "_disabled"));

    RayoTextFieldWithDecorationIcons textField = new RayoTextFieldWithDecorationIcons(true);
    initializeDateField(textField);
    container.add(textField);
    return textField;
  }

  @Override
  protected void initializeDateField(JTextFieldWithDecorationIcons textField) {
    super.initializeDateField(textField);
    textField.getDocument().addDocumentListener(new DocumentListener() {
      @Override
      public void removeUpdate(DocumentEvent e) {
        updateTextOverlappingIcon();
      }

      @Override
      public void insertUpdate(DocumentEvent e) {
        updateTextOverlappingIcon();
      }

      @Override
      public void changedUpdate(DocumentEvent e) {
        updateTextOverlappingIcon();
      }
    });
    textField.addComponentListener(new ComponentAdapter() {
      @Override
      public void componentResized(ComponentEvent e) {
        updateTextOverlappingIcon();
      }
    });
  }

  private void updateTextOverlappingIcon() {
    int textWidth = calcTextWidth();
    IDecoration decorationIcon = getSwingDateField().getDecorationIcon();
    int iconWidth = decorationIcon.getWidth();
    int fieldWidth = getSwingDateField().getSize().width;
    int insetsLeft = getSwingDateField().getInsets().left;
    int customInsetsRigth = getSwingDateField().getInsets().right;
    if (textWidth > fieldWidth - iconWidth - insetsLeft - customInsetsRigth) {
      getDropdownIcon().setIconGroup(m_overlapIconGroup);
    }
    else {
      getDropdownIcon().setIconGroup(m_notOverlapIconGroup);
    }
  }

  private int calcTextWidth() {
    String text = getSwingDateField().getText();
    Font f = getSwingDateField().getFont();
    FontMetrics fm = getSwingDateField().getFontMetrics(f);
    Rectangle2D bounds = fm.getStringBounds(text, getSwingDateField().getGraphics());
    return (int) bounds.getWidth();
  }
}
