/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.ext;

import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;

/**
 *
 */
public class RayoTextFieldWithDecorationIcons extends JTextFieldWithDecorationIcons {

  private static final long serialVersionUID = 1L;

  /**
   *
   */
  public RayoTextFieldWithDecorationIcons() {
    this(false);
  }

  public RayoTextFieldWithDecorationIcons(boolean backgroundDecoration) {
    super(backgroundDecoration);
    if (isBackgroundDecoration()) {
      putClientProperty("onBackgroundPainter", new P_OnBackgroundPainter());
    }
  }

  @Override
  protected void postPaint(Graphics g) {
    if (!isBackgroundDecoration()) {
      super.postPaint(g);
    }
  }

  /**
   * This is more or less a hack used to to draw the text of a JTextField over the icon of the
   * widget.
   * This hack is required because SynthTextFieldUI of the Synth L/F paints the background of a text-field and the text
   * of the JTextField in one step, so it is not possible to draw something "between" text and background (for instance
   * our icon).
   * The modified BSI Rayo L/F checks if the client property "onBackgroundPainter" is set, and then calls the
   * paintIcon() method between the two calls to paint the background and the text.
   */
  private class P_OnBackgroundPainter implements Icon {

    @Override
    public int getIconHeight() {
      return 0;
    }

    @Override
    public int getIconWidth() {
      return 0;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
      RayoTextFieldWithDecorationIcons.super.postPaint(g);
    }
  }
}
