/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.ColorType;
import com.bsiag.javax.swing.plaf.synth.SynthBorder;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthGraphicsUtils;
import com.bsiag.javax.swing.plaf.synth.SynthLabelUI;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.javax.swing.plaf.synth.SynthStyle;
import com.bsiag.sun.swing.plaf.synth.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.View;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;

class SynthTableUI
extends BasicTableUI
implements SynthUI,
PropertyChangeListener {
    private static final String PROP_TABLE_ROW_SELECTION_BORDER_STYLE = "rayoTableRowSelectionBorderStyle";
    private static final String VALUE_TABLE_ROW_SELECTION_BORDER_SINGLE = "rowSelectionBorderSingle";
    private static final String VALUE_TABLE_ROW_SELECTION_BORDER_RANGE_BEGIN = "rowSelectionBorderRangeBegin";
    private static final String VALUE_TABLE_ROW_SELECTION_BORDER_RANGE_END = "rowSelectionBorderRangeEnd";
    private SynthStyle style;
    private boolean useTableColors;
    private boolean useUIBorder;
    private Color alternateColor;
    private TableCellRenderer dateRenderer;
    private TableCellRenderer numberRenderer;
    private TableCellRenderer doubleRender;
    private TableCellRenderer floatRenderer;
    private TableCellRenderer iconRenderer;
    private TableCellRenderer imageIconRenderer;
    private TableCellRenderer booleanRenderer;
    private TableCellRenderer objectRenderer;

    SynthTableUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthTableUI();
    }

    @Override
    protected void installDefaults() {
        this.dateRenderer = this.installRendererIfPossible(Date.class, null);
        this.numberRenderer = this.installRendererIfPossible(Number.class, null);
        this.doubleRender = this.installRendererIfPossible(Double.class, null);
        this.floatRenderer = this.installRendererIfPossible(Float.class, null);
        this.iconRenderer = this.installRendererIfPossible(Icon.class, null);
        this.imageIconRenderer = this.installRendererIfPossible(ImageIcon.class, null);
        this.booleanRenderer = this.installRendererIfPossible(Boolean.class, new SynthBooleanTableCellRenderer());
        this.objectRenderer = this.installRendererIfPossible(Object.class, new SynthTableCellRenderer());
        this.updateStyle(this.table);
    }

    private TableCellRenderer installRendererIfPossible(Class<?> objectClass, TableCellRenderer renderer) {
        TableCellRenderer currentRenderer = this.table.getDefaultRenderer(objectClass);
        if (currentRenderer instanceof UIResource) {
            this.table.setDefaultRenderer(objectClass, renderer);
        }
        return currentRenderer;
    }

    private void updateStyle(JTable c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Dimension d;
            boolean showGrid;
            Color sfg;
            context.setComponentState(513);
            Color sbg = this.table.getSelectionBackground();
            if (sbg == null || sbg instanceof UIResource) {
                this.table.setSelectionBackground(this.style.getColor(context, ColorType.TEXT_BACKGROUND));
            }
            if ((sfg = this.table.getSelectionForeground()) == null || sfg instanceof UIResource) {
                this.table.setSelectionForeground(this.style.getColor(context, ColorType.TEXT_FOREGROUND));
            }
            context.setComponentState(1);
            Color gridColor = this.table.getGridColor();
            if (gridColor == null || gridColor instanceof UIResource) {
                gridColor = (Color)this.style.get(context, "Table.gridColor");
                if (gridColor == null) {
                    gridColor = this.style.getColor(context, ColorType.FOREGROUND);
                }
                this.table.setGridColor(gridColor);
            }
            this.useTableColors = this.style.getBoolean(context, "Table.rendererUseTableColors", true);
            this.useUIBorder = this.style.getBoolean(context, "Table.rendererUseUIBorder", true);
            Object rowHeight = this.style.get(context, "Table.rowHeight");
            if (rowHeight != null) {
                LookAndFeel.installProperty(this.table, "rowHeight", rowHeight);
            }
            if (!(showGrid = this.style.getBoolean(context, "Table.showGrid", true))) {
                this.table.setShowGrid(false);
            }
            if ((d = this.table.getIntercellSpacing()) != null) {
                d = (Dimension)this.style.get(context, "Table.intercellSpacing");
            }
            this.alternateColor = (Color)this.style.get(context, "Table.alternateRowColor");
            if (d != null) {
                this.table.setIntercellSpacing(d);
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.table.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        this.table.setDefaultRenderer(Date.class, this.dateRenderer);
        this.table.setDefaultRenderer(Number.class, this.numberRenderer);
        this.table.setDefaultRenderer(Double.class, this.doubleRender);
        this.table.setDefaultRenderer(Float.class, this.floatRenderer);
        this.table.setDefaultRenderer(Icon.class, this.iconRenderer);
        this.table.setDefaultRenderer(ImageIcon.class, this.imageIconRenderer);
        this.table.setDefaultRenderer(Boolean.class, this.booleanRenderer);
        this.table.setDefaultRenderer(Object.class, this.objectRenderer);
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
        SynthContext context = this.getContext(this.table, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    protected void uninstallListeners() {
        this.table.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintTableBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintTableBorder(context, g, x, y, w, h);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            this.paintDropLines(context, g);
            return;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint(ltr ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(context, g, rMin, rMax, cMin, cMax);
        this.paintCells(context, g, rMin, rMax, cMin, cMax);
        this.paintDropLines(context, g);
    }

    private void paintDropLines(SynthContext context, Graphics g) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = (Color)this.style.get(context, "Table.dropLineColor");
        Color shortColor = (Color)this.style.get(context, "Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(x, rect.y, w, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(rect.x, y, rect.width, h);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (ltr) {
                rect.x += rect.width;
            }
        } else if (!ltr) {
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    private Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect == null) {
            return rect;
        }
        if (horizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    private void paintGrid(SynthContext context, Graphics g, int rMin, int rMax, int cMin, int cMax) {
        block6: {
            int x;
            g.setColor(this.table.getGridColor());
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            SynthGraphicsUtils synthG = context.getStyle().getGraphicsUtils(context);
            if (this.table.getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                int y = damagedArea.y;
                int row = rMin;
                while (row <= rMax) {
                    synthG.drawLine(context, "Table.grid", g, damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                    ++row;
                }
            }
            if (!this.table.getShowVerticalLines()) break block6;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                int column = cMin;
                while (column <= cMax) {
                    int w = cm.getColumn(column).getWidth();
                    synthG.drawLine(context, "Table.grid", g, (x += w) - 1, 0, x - 1, tableHeight - 1);
                    ++column;
                }
            } else {
                x = damagedArea.x;
                int column = cMax;
                while (column >= cMin) {
                    int w = cm.getColumn(column).getWidth();
                    synthG.drawLine(context, "Table.grid", g, (x += w) - 1, 0, x - 1, tableHeight - 1);
                    --column;
                }
            }
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    private void paintCells(SynthContext context, Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            int row = rMin;
            while (row <= rMax) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                int column = cMin;
                while (column <= cMax) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(context, g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                    ++column;
                }
                ++row;
            }
        } else {
            int row = rMin;
            while (row <= rMax) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(context, g, cellRect, row, cMin);
                }
                int column = cMin + 1;
                while (column <= cMax) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn != draggedColumn) {
                        this.paintCell(context, g, cellRect, row, column);
                    }
                    ++column;
                }
                ++row;
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(context, g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(SynthContext context, Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(context.getStyle().getColor(context, ColorType.BACKGROUND));
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        SynthGraphicsUtils synthG = context.getStyle().getGraphicsUtils(context);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            synthG.drawLine(context, "Table.grid", g, x1 - 1, y1, x1 - 1, y2);
            synthG.drawLine(context, "Table.grid", g, x2, y1, x2, y2);
        }
        int row = rMin;
        while (row <= rMax) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(context, g, r, row, draggedColumnIndex);
            if (this.table.getShowHorizontalLines()) {
                g.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
                rcr.x += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                synthG.drawLine(context, "Table.grid", g, x1, y2, x2, y2);
            }
            ++row;
        }
    }

    private void paintCell(SynthContext context, Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            JComponent jc;
            View v;
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.setCustomTableCellStyle(component, row, column);
            Color b = component.getBackground();
            if ((b == null || b instanceof UIResource || component instanceof SynthBooleanTableCellRenderer) && !this.table.isCellSelected(row, column) && this.alternateColor != null && row % 2 != 0) {
                component.setBackground(this.alternateColor);
            }
            if (component instanceof JComponent && (v = (View)(jc = (JComponent)component).getClientProperty("html")) != null) {
                v.setSize(cellRect.width, cellRect.height);
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private void setCustomTableCellStyle(Component c, int row, int col) {
        if (c instanceof JComponent) {
            JComponent l = (JComponent)c;
            String value = null;
            if (this.table.isCellSelected(row, col)) {
                boolean selPrev = this.table.isCellSelected(row - 1, col);
                boolean selNext = this.table.isCellSelected(row + 1, col);
                if (!selPrev && selNext) {
                    value = VALUE_TABLE_ROW_SELECTION_BORDER_RANGE_BEGIN;
                } else if (selPrev && !selNext) {
                    value = VALUE_TABLE_ROW_SELECTION_BORDER_RANGE_END;
                } else if (!selPrev && !selNext) {
                    value = VALUE_TABLE_ROW_SELECTION_BORDER_SINGLE;
                }
            }
            l.putClientProperty(PROP_TABLE_ROW_SELECTION_BORDER_STYLE, value);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (SynthLookAndFeel.shouldUpdateStyle(event)) {
            this.updateStyle((JTable)event.getSource());
        }
    }

    private class SynthBooleanTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private boolean isRowSelected;

        public SynthBooleanTableCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setName("Table.cellRenderer");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.isRowSelected = isSelected;
            if (isSelected) {
                this.setForeground(this.unwrap(table.getSelectionForeground()));
                this.setBackground(this.unwrap(table.getSelectionBackground()));
            } else {
                this.setForeground(this.unwrap(table.getForeground()));
                this.setBackground(this.unwrap(table.getBackground()));
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }

        private Color unwrap(Color c) {
            if (c instanceof UIResource) {
                return new Color(c.getRGB());
            }
            return c;
        }

        @Override
        public boolean isOpaque() {
            return this.isRowSelected ? true : super.isOpaque();
        }
    }

    private class SynthTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Object numberFormat;
        private Object dateFormat;
        private boolean opaque;

        private SynthTableCellRenderer() {
        }

        @Override
        public void setOpaque(boolean isOpaque) {
            this.opaque = isOpaque;
        }

        @Override
        public boolean isOpaque() {
            return this.opaque;
        }

        @Override
        public String getName() {
            String name = super.getName();
            if (name == null) {
                return "Table.cellRenderer";
            }
            return name;
        }

        @Override
        public void setBorder(Border b) {
            if (SynthTableUI.this.useUIBorder || b instanceof SynthBorder) {
                super.setBorder(b);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!SynthTableUI.this.useTableColors && (isSelected || hasFocus)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), isSelected, hasFocus, table.isEnabled(), false);
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.applyPaddingToFirstAndLastColumn(table.getColumnCount(), column);
            this.setIcon(null);
            Class<?> columnClass = table.getColumnClass(column);
            this.configureValue(value, columnClass);
            return this;
        }

        private void applyPaddingToFirstAndLastColumn(int columnCount, int column) {
            int padding;
            SynthContext tableContext = SynthTableUI.this.getContext(SynthTableUI.this.table);
            SynthContext rendererContext = ((SynthUI)((Object)this.getUI())).getContext(this);
            Insets insets = rendererContext.getStyle().getInsets(rendererContext, null);
            if (column == 0) {
                int padding2 = SynthTableUI.this.style.getInt(tableContext, "Table.firstColumn.padding", -1);
                if (padding2 > -1) {
                    insets.left = padding2;
                }
            } else if (column == columnCount - 1 && (padding = SynthTableUI.this.style.getInt(tableContext, "Table.lastColumn.padding", -1)) > -1) {
                insets.right = padding;
            }
            if (insets != null) {
                super.setBorder(new EmptyBorder(insets));
            }
        }

        private void configureValue(Object value, Class<?> columnClass) {
            if (columnClass == Object.class || columnClass == null) {
                this.setHorizontalAlignment(10);
            } else if (columnClass == Float.class || columnClass == Double.class) {
                if (this.numberFormat == null) {
                    this.numberFormat = NumberFormat.getInstance();
                }
                this.setHorizontalAlignment(11);
                this.setText(value == null ? "" : ((NumberFormat)this.numberFormat).format(value));
            } else if (columnClass == Number.class) {
                this.setHorizontalAlignment(11);
            } else if (columnClass == Icon.class || columnClass == ImageIcon.class) {
                this.setHorizontalAlignment(0);
                this.setIcon(value instanceof Icon ? (Icon)value : null);
                this.setText("");
            } else if (columnClass == Date.class) {
                if (this.dateFormat == null) {
                    this.dateFormat = DateFormat.getDateInstance();
                }
                this.setHorizontalAlignment(10);
                this.setText(value == null ? "" : ((Format)this.dateFormat).format(value));
            } else {
                this.configureValue(value, columnClass.getSuperclass());
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            String rowSelectionBorderStyle = (String)this.getClientProperty(SynthTableUI.PROP_TABLE_ROW_SELECTION_BORDER_STYLE);
            if (rowSelectionBorderStyle != null) {
                SynthContext tableContext = SynthTableUI.this.getContext(SynthTableUI.this.table);
                boolean drawRowSelectionBorder = SynthTableUI.this.style.getBoolean(tableContext, "Table.drawRowSelectionBorder", true);
                if (drawRowSelectionBorder) {
                    int x = 0;
                    int y = 0;
                    int width = this.getSize().width;
                    int height = this.getSize().height;
                    boolean drawLineAbove = true;
                    boolean drawLineBelow = true;
                    if (rowSelectionBorderStyle == SynthTableUI.VALUE_TABLE_ROW_SELECTION_BORDER_RANGE_BEGIN) {
                        drawLineBelow = false;
                    }
                    if (rowSelectionBorderStyle == SynthTableUI.VALUE_TABLE_ROW_SELECTION_BORDER_RANGE_END) {
                        drawLineAbove = false;
                    }
                    Color bgColor = this.getBackground();
                    Color lineColor = ColorUtility.multiplyColors((Color)bgColor, (Color)UIManager.getColor("Table.selectedRowBorderColor"));
                    if (!this.isEnabled()) {
                        lineColor = ColorUtility.mergeColors((Color)lineColor, (float)0.75f, (Color)Color.WHITE, (float)0.25f);
                    }
                    g.setColor(lineColor);
                    if (drawLineAbove) {
                        g.drawLine(x, y, x + width, y);
                    }
                    if (drawLineBelow) {
                        g.drawLine(x, y + height - 1, x + width, y + height - 1);
                    }
                }
            }
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

