/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.ColorType;
import com.bsiag.javax.swing.plaf.synth.Region;
import com.bsiag.javax.swing.plaf.synth.SynthBorder;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthLabelUI;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.javax.swing.plaf.synth.SynthStyle;
import com.bsiag.sun.swing.plaf.synth.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;

class SynthListUI
extends BasicListUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;
    private boolean useUIBorder;

    SynthListUI() {
    }

    public static ComponentUI createUI(JComponent list) {
        return new SynthListUI();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintListBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        context.dispose();
        this.paint(g, c);
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintListBorder(context, g, x, y, w, h);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.list.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JList)e.getSource());
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.list.removePropertyChangeListener(this);
    }

    @Override
    protected void installDefaults() {
        if (this.list.getCellRenderer() == null || this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(new SynthListCellRenderer());
        }
        this.updateStyle(this.list);
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(this.list, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Color sfg;
            context.setComponentState(512);
            Color sbg = this.list.getSelectionBackground();
            if (sbg == null || sbg instanceof UIResource) {
                this.list.setSelectionBackground(this.style.getColor(context, ColorType.TEXT_BACKGROUND));
            }
            if ((sfg = this.list.getSelectionForeground()) == null || sfg instanceof UIResource) {
                this.list.setSelectionForeground(this.style.getColor(context, ColorType.TEXT_FOREGROUND));
            }
            this.useListColors = this.style.getBoolean(context, "List.rendererUseListColors", true);
            this.useUIBorder = this.style.getBoolean(context, "List.rendererUseUIBorder", true);
            int height = this.style.getInt(context, "List.cellHeight", -1);
            if (height != -1) {
                this.list.setFixedCellHeight(height);
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        SynthContext context = this.getContext(this.list, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    private class SynthListCellRenderer
    extends DefaultListCellRenderer.UIResource {
        private SynthListCellRenderer() {
        }

        @Override
        public String getName() {
            return "List.cellRenderer";
        }

        @Override
        public void setBorder(Border b) {
            if (SynthListUI.this.useUIBorder || b instanceof SynthBorder) {
                super.setBorder(b);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!SynthListUI.this.useListColors && (isSelected || cellHasFocus)) {
                SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), isSelected, cellHasFocus, list.isEnabled(), false);
            } else {
                SynthLookAndFeel.resetSelectedUI();
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

