/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoNavigationWidgetButton;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;

public class RayoForwardButton
extends RayoNavigationWidgetButton {
    private Point m_historyIconPosition;
    private boolean m_historyEnabled = false;

    public RayoForwardButton(JComponent parent, Point historyIconPosition, boolean historyEnabled) {
        super(RayoNavigationWidgetButton.ButtonName.FORWARD, parent);
        this.m_historyIconPosition = historyIconPosition;
        this.m_historyEnabled = historyEnabled;
    }

    public boolean isHistoryEnabled() {
        return this.m_historyEnabled;
    }

    public void setHistoryEnabled(boolean historyEnabled) {
        this.m_historyEnabled = historyEnabled;
    }

    @Override
    protected Icon getSecondaryIconForCurrentState() {
        IconGroup iconGroup = this.getIconGroup(RayoNavigationWidgetButton.ActionType.SecondaryAction);
        Icon icon = iconGroup.getIcon(IconGroup.IconState.NORMAL);
        if (!this.isHistoryEnabled() && iconGroup.hasIcon(IconGroup.IconState.DISABLED)) {
            icon = iconGroup.getIcon(IconGroup.IconState.DISABLED);
        } else if (this.isMouseOver() && iconGroup.hasIcon(IconGroup.IconState.ROLLOVER)) {
            icon = iconGroup.getIcon(IconGroup.IconState.ROLLOVER);
        }
        return icon;
    }

    @Override
    protected void paintIcon(Component c, Graphics g) {
        super.paintIcon(c, g);
        this.paintPressedImage(this.getSecondaryIconForCurrentState(), this.m_historyIconPosition, this.isPressed(), c, g);
    }

    @Override
    public void buttonClicked(int button) {
        switch (button) {
            case 1: {
                this.performAction(this.getPrimaryAction());
                break;
            }
            case 3: {
                if (!this.isHistoryEnabled()) break;
                this.performAction(this.getSecondaryAction());
            }
        }
    }
}

