/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.form.fields.datefield;

import com.bsiag.scout.rt.ui.swing.rayo.ext.RayoTextFieldWithDecorationIcons;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.decoration.IDecoration;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.datefield.SwingScoutDateField;

public class RayoSwingScoutDateField
extends SwingScoutDateField {
    private IconGroup m_notOverlapIconGroup;
    private IconGroup m_overlapIconGroup;

    protected JTextFieldWithDecorationIcons createDateField(JComponent container) {
        this.m_notOverlapIconGroup = new IconGroup(this.getSwingEnvironment(), "datefield_date");
        this.m_overlapIconGroup = new IconGroup(this.getSwingEnvironment(), "datefield_date");
        this.m_overlapIconGroup.setIcon(IconGroup.IconState.NORMAL, this.getSwingEnvironment().getIcon("datefield_date_disabled"));
        RayoTextFieldWithDecorationIcons textField = new RayoTextFieldWithDecorationIcons(true);
        this.initializeDateField(textField);
        container.add((Component)((Object)textField));
        return textField;
    }

    protected void initializeDateField(JTextFieldWithDecorationIcons textField) {
        super.initializeDateField(textField);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                RayoSwingScoutDateField.this.updateTextOverlappingIcon();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RayoSwingScoutDateField.this.updateTextOverlappingIcon();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RayoSwingScoutDateField.this.updateTextOverlappingIcon();
            }
        });
        textField.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RayoSwingScoutDateField.this.updateTextOverlappingIcon();
            }
        });
    }

    private void updateTextOverlappingIcon() {
        int customInsetsRigth;
        int insetsLeft;
        IDecoration decorationIcon;
        int iconWidth;
        int fieldWidth;
        int textWidth = this.calcTextWidth();
        if (textWidth > (fieldWidth = this.getSwingDateField().getSize().width) - (iconWidth = (decorationIcon = this.getSwingDateField().getDecorationIcon()).getWidth()) - (insetsLeft = this.getSwingDateField().getInsets().left) - (customInsetsRigth = this.getSwingDateField().getInsets().right)) {
            this.getDropdownIcon().setIconGroup(this.m_overlapIconGroup);
        } else {
            this.getDropdownIcon().setIconGroup(this.m_notOverlapIconGroup);
        }
    }

    private int calcTextWidth() {
        String text = this.getSwingDateField().getText();
        Font f = this.getSwingDateField().getFont();
        FontMetrics fm = this.getSwingDateField().getFontMetrics(f);
        Rectangle2D bounds = fm.getStringBounds(text, this.getSwingDateField().getGraphics());
        return (int)bounds.getWidth();
    }
}

