package com.bsiag.scout.rt.ui.swing.rayo.form.fields.groupbox;

import java.awt.Dimension;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JSection;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.BackgroundBorder;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.SwingScoutGroupBox;

public class RayoSwingScoutGroupBox extends SwingScoutGroupBox {
  private static final IScoutLogger LOG = ScoutLogManager.getLogger(RayoSwingScoutGroupBox.class);

  private JLabel m_swingTitle;

  private void installTitle(JPanelEx swingBox) {
    if (!containerBorderVisible || IGroupBox.BORDER_DECORATION_EMPTY.equals(containerBorderDecoration)) {
      if (m_swingTitle != null) {
        swingBox.remove(m_swingTitle);
      }
    }
    else if (containerLabel == null || "".equals(containerLabel)) {
      if (m_swingTitle != null) {
        swingBox.remove(m_swingTitle);
      }
    }
    else {
      if (m_swingTitle == null) {
        m_swingTitle = new JLabel(containerLabel);
        m_swingTitle.setName("Synth.GroupBoxTitle");
        swingBox.add(m_swingTitle, BorderLayoutEx.NORTH);
      }
      else {
        m_swingTitle.setText(containerLabel);
      }
    }
  }

  /**
   * complete override
   */
  @Override
  protected void installSwingContainerBorder() {
    if (!isSection()) {
      JPanelEx swingBox = (JPanelEx) getSwingField();
      installTitle(swingBox);
    }
    if (containerBorderVisible) {
      containerBorderInstalled = true;
      if (IGroupBox.BORDER_DECORATION_SECTION.equals(containerBorderDecoration)) {
        // section
        JSection section = (JSection) getSwingContainer();
        section.setText(containerLabel);
      }
      else if (IGroupBox.BORDER_DECORATION_LINE.equals(containerBorderDecoration)) {
        if (containerImage != null) {
          Icon icon = getSwingEnvironment().getIcon(containerImage);
          if (icon != null) {
            // set minimum container size
            getSwingContainer().setMinimumSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
          }
          else {
            // reset minimum container size
            getSwingContainer().setMinimumSize(null);
          }
          Border bgBorder = new BackgroundBorder(icon, containerImageHAlign, containerImageVAlign);
          getSwingContainer().setBorder(bgBorder);
        }
      }
    }
    else {
      getSwingBodyPart().setName(null);
      //button bar has always insets
    }
  }
}
