/*
 * Copyright (c) 2011, BSI Business Systems Integration AG. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. BSI Business Systems Integration AG
 * designates this particular file as subject to the "Classpath" exception as provided
 * by BSI Business Systems Integration AG in the LICENSE_BSI file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact BSI Business Systems Integration AG, Taefernstrasse 16a,
 * CH-5405 Baden, Switzerland or visit www.bsiag.com if you need additional
 * information or have any questions.
 */
package com.bsiag.scout.rt.ui.swing.laf.rayo.tests;

import java.awt.Container;

import javax.swing.ImageIcon;

import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup.IconState;
import org.eclipse.scout.rt.ui.swing.ext.JFrameEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldWithTransparentIcon;

import com.bsiag.scout.rt.ui.swing.laf.rayo.Rayo;

/**
 * Test for textfield with transparent icon.
 */
public class TestSmartDateField {

  TestSmartDateField() {
    new Rayo().installLookAndFeel();
    JFrameEx f = new JFrameEx();
    Container contentPane = f.getContentPane();
    contentPane.setLayout(null);

    JTextFieldWithTransparentIcon text = new JTextFieldWithTransparentIcon();
    IconGroup ig = new IconGroup();
    ig.setIcon(IconState.NORMAL, new ImageIcon(getClass().getResource("images/datefield_date.png")));
    ig.setIcon(IconState.SELECTED, new ImageIcon(getClass().getResource("images/datefield_date_selected.png")));
    ig.setIcon(IconState.ROLLOVER, new ImageIcon(getClass().getResource("images/datefield_date_mouse_over.png")));
    ig.setIcon(IconState.DISABLED, new ImageIcon(getClass().getResource("images/datefield_date_disabled.png")));
    text.setIconGroup(ig);

    text.setLocation(5, 5);
    text.setSize(82, 23);
    text.setEnabled(true); //false);
    //text.setEnabled(false);

    contentPane.add(text);
    f.pack();
    f.setLocation(300, 200);
    f.setSize(300, 75);
    f.setVisible(true);
  }

  public static void main(String[] args) throws Exception {
    new TestSmartDateField();
  }

}
