/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.Region;
import com.bsiag.javax.swing.plaf.synth.SynthArrowButton;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.javax.swing.plaf.synth.SynthSplitPaneUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import sun.swing.DefaultLookup;

class SynthSplitPaneDivider
extends BasicSplitPaneDivider {
    public SynthSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
    }

    @Override
    protected void setMouseOver(boolean mouseOver) {
        if (this.isMouseOver() != mouseOver) {
            this.repaint();
        }
        super.setMouseOver(mouseOver);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getSource() == this.splitPane && e.getPropertyName() == "orientation") {
            if (this.leftButton instanceof SynthArrowButton) {
                ((SynthArrowButton)this.leftButton).setDirection(this.mapDirection(true));
            }
            if (this.rightButton instanceof SynthArrowButton) {
                ((SynthArrowButton)this.rightButton).setDirection(this.mapDirection(false));
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics g2 = g.create();
        SynthContext context = ((SynthSplitPaneUI)this.splitPaneUI).getContext((JComponent)this.splitPane, Region.SPLIT_PANE_DIVIDER);
        Rectangle bounds = this.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        SynthLookAndFeel.updateSubregion(context, g, bounds);
        context.getPainter().paintSplitPaneDividerBackground(context, g, 0, 0, bounds.width, bounds.height, this.splitPane.getOrientation());
        Object foreground = null;
        context.getPainter().paintSplitPaneDividerForeground(context, g, 0, 0, this.getWidth(), this.getHeight(), this.splitPane.getOrientation());
        context.dispose();
        int counter = 0;
        while (counter < this.getComponentCount()) {
            Component child = this.getComponent(counter);
            Rectangle childBounds = child.getBounds();
            Graphics childG = g.create(childBounds.x, childBounds.y, childBounds.width, childBounds.height);
            child.paint(childG);
            childG.dispose();
            ++counter;
        }
        g2.dispose();
    }

    private int mapDirection(boolean isLeft) {
        if (isLeft) {
            if (this.splitPane.getOrientation() == 1) {
                return 7;
            }
            return 1;
        }
        if (this.splitPane.getOrientation() == 1) {
            return 3;
        }
        return 5;
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        SynthArrowButton b = new SynthArrowButton(1);
        int oneTouchSize = this.lookupOneTouchSize();
        b.setName("SplitPaneDivider.leftOneTouchButton");
        b.setMinimumSize(new Dimension(oneTouchSize, oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        b.setDirection(this.mapDirection(true));
        return b;
    }

    private int lookupOneTouchSize() {
        return DefaultLookup.getInt(this.splitPaneUI.getSplitPane(), this.splitPaneUI, "SplitPaneDivider.oneTouchButtonSize", 6);
    }

    @Override
    protected JButton createRightOneTouchButton() {
        SynthArrowButton b = new SynthArrowButton(1);
        int oneTouchSize = this.lookupOneTouchSize();
        b.setName("SplitPaneDivider.rightOneTouchButton");
        b.setMinimumSize(new Dimension(oneTouchSize, oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        b.setDirection(this.mapDirection(false));
        return b;
    }
}

