/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.ColorType;
import com.bsiag.javax.swing.plaf.synth.Region;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.javax.swing.plaf.synth.SynthPopupMenuUI;
import com.bsiag.javax.swing.plaf.synth.SynthStyle;
import com.bsiag.sun.swing.plaf.synth.SynthIcon;
import com.bsiag.sun.swing.plaf.synth.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.text.View;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.basic.ISwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import sun.swing.SwingUtilities2;

class SynthMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle accStyle;
    private String acceleratorDelimiter;
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    SynthMenuItemUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthMenuItemUI();
    }

    private static String getKeyModifiersText(Component item, int modifiers) {
        Locale locale;
        if ((modifiers & 2) != 0) {
            Locale locale2 = SynthMenuItemUI.getScoutSessionLocale(item);
            if (locale2 != null) {
                if (Locale.GERMAN.equals(locale2) || Locale.GERMANY.equals(locale2)) {
                    return "Strg";
                }
                return "Ctrl";
            }
        } else if ((modifiers & 1) != 0) {
            Locale locale3 = SynthMenuItemUI.getScoutSessionLocale(item);
            if (locale3 != null) {
                if (Locale.GERMAN.getLanguage().equals(locale3.getLanguage())) {
                    return "Umschalt";
                }
                if ("es".equals(locale3.getLanguage())) {
                    return "May\u00fas";
                }
                if (Locale.FRENCH.getLanguage().equals(locale3.getLanguage())) {
                    return "Maj";
                }
                if (Locale.ITALIAN.getLanguage().equals(locale3.getLanguage())) {
                    return "Maiusc";
                }
                if ("sv".equals(locale3.getLanguage())) {
                    return "Skift";
                }
                return "Shift";
            }
        } else if ((modifiers & 0x20) != 0 && (locale = SynthMenuItemUI.getScoutSessionLocale(item)) != null) {
            if (Locale.JAPANESE.getLanguage().equals(locale.getLanguage())) {
                return "Alt???";
            }
            return "Alt Gr";
        }
        return KeyEvent.getKeyModifiersText(modifiers);
    }

    private static Locale getScoutSessionLocale(Component item) {
        IClientSession curSess;
        ISwingEnvironment env;
        ISwingScoutComposite compositeOnWidget = SwingScoutComposite.getCompositeOnWidget((Component)item);
        if (compositeOnWidget != null && (env = compositeOnWidget.getSwingEnvironment()) != null && (curSess = env.getScoutSession()) != null) {
            return curSess.getLocale();
        }
        return null;
    }

    static Dimension getPreferredMenuItemSize(SynthContext context, SynthContext accContext, boolean useCheckAndArrow, JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, String acceleratorDelimiter) {
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = SynthMenuItemUI.getKeyModifiersText(b, modifiers);
                acceleratorText = String.valueOf(acceleratorText) + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        Font font = context.getStyle().getFont(context);
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(accContext.getStyle().getFont(accContext));
        SynthMenuItemUI.resetRects();
        SynthMenuItemUI.layoutMenuItem(context, fm, accContext, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap, useCheckAndArrow);
        r.setBounds(textRect);
        Container parent = b.getParent();
        if (parent instanceof JPopupMenu) {
            SynthPopupMenuUI popupUI = (SynthPopupMenuUI)SynthLookAndFeel.getUIOfType(((JPopupMenu)parent).getUI(), SynthPopupMenuUI.class);
            if (popupUI != null) {
                SynthMenuItemUI.r.width = popupUI.adjustTextWidth(SynthMenuItemUI.r.width);
                r = SwingUtilities.computeUnion(SynthMenuItemUI.iconRect.x, SynthMenuItemUI.iconRect.y, SynthMenuItemUI.iconRect.width, SynthMenuItemUI.iconRect.height, r);
                popupUI.adjustAcceleratorWidth(SynthMenuItemUI.acceleratorRect.width);
                SynthMenuItemUI.r.width += popupUI.getMaxAcceleratorWidth();
            }
        } else if (!(parent == null || b instanceof JMenu && ((JMenu)b).isTopLevelMenu())) {
            r = SwingUtilities.computeUnion(SynthMenuItemUI.iconRect.x, SynthMenuItemUI.iconRect.y, SynthMenuItemUI.iconRect.width, SynthMenuItemUI.iconRect.height, r);
            SynthMenuItemUI.r.width += SynthMenuItemUI.acceleratorRect.width;
        }
        if (useCheckAndArrow) {
            SynthMenuItemUI.r.width += SynthMenuItemUI.checkIconRect.width;
            SynthMenuItemUI.r.width += defaultTextIconGap;
            SynthMenuItemUI.r.width += defaultTextIconGap;
            SynthMenuItemUI.r.width += SynthMenuItemUI.arrowIconRect.width;
        }
        SynthMenuItemUI.r.width += 2 * defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            SynthMenuItemUI.r.width += insets.left + insets.right;
            SynthMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (SynthMenuItemUI.r.width % 2 == 0) {
            ++SynthMenuItemUI.r.width;
        }
        if (SynthMenuItemUI.r.height % 2 == 0) {
            ++SynthMenuItemUI.r.height;
        }
        return r.getSize();
    }

    static void paint(SynthContext context, SynthContext accContext, Graphics g, Icon checkIcon, Icon arrowIcon, boolean useCheckAndArrow, String acceleratorDelimiter, int defaultTextIconGap) {
        JComponent c = context.getComponent();
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        Insets i = b.getInsets();
        SynthMenuItemUI.resetRects();
        viewRect.setBounds(0, 0, b.getWidth(), b.getHeight());
        SynthMenuItemUI.viewRect.x += i.left;
        SynthMenuItemUI.viewRect.y += i.top;
        SynthMenuItemUI.viewRect.width -= i.right + SynthMenuItemUI.viewRect.x;
        SynthMenuItemUI.viewRect.height -= i.bottom + SynthMenuItemUI.viewRect.y;
        SynthStyle style = context.getStyle();
        Font f = style.getFont(context);
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        FontMetrics accFM = SwingUtilities2.getFontMetrics(c, g, accContext.getStyle().getFont(accContext));
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = SynthMenuItemUI.getKeyModifiersText(b, modifiers);
                acceleratorText = String.valueOf(acceleratorText) + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        String text = SynthMenuItemUI.layoutMenuItem(context, fm, accContext, b.getText(), accFM, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap, useCheckAndArrow);
        if (checkIcon != null && useCheckAndArrow) {
            SynthIcon.paintIcon(checkIcon, context, g, SynthMenuItemUI.checkIconRect.x, SynthMenuItemUI.checkIconRect.y, SynthMenuItemUI.checkIconRect.width, SynthMenuItemUI.checkIconRect.height);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                SynthIcon.paintIcon(icon, context, g, SynthMenuItemUI.iconRect.x, SynthMenuItemUI.iconRect.y, SynthMenuItemUI.iconRect.width, SynthMenuItemUI.iconRect.height);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
                g.setFont(style.getFont(context));
                style.getGraphicsUtils(context).paintText(context, g, text, SynthMenuItemUI.textRect.x, SynthMenuItemUI.textRect.y, b.getDisplayedMnemonicIndex());
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int max;
            SynthPopupMenuUI popupUI;
            int accOffset = 0;
            Container parent = b.getParent();
            if (parent != null && parent instanceof JPopupMenu && (popupUI = (SynthPopupMenuUI)((JPopupMenu)parent).getUI()) != null && (max = popupUI.getMaxAcceleratorWidth()) > 0) {
                accOffset = max - SynthMenuItemUI.acceleratorRect.width;
            }
            SynthStyle accStyle = accContext.getStyle();
            g.setColor(accStyle.getColor(accContext, ColorType.TEXT_FOREGROUND));
            g.setFont(accStyle.getFont(accContext));
            accStyle.getGraphicsUtils(accContext).paintText(accContext, g, acceleratorText, SynthMenuItemUI.acceleratorRect.x - accOffset, SynthMenuItemUI.acceleratorRect.y, -1);
        }
        if (arrowIcon != null && useCheckAndArrow) {
            SynthIcon.paintIcon(arrowIcon, context, g, SynthMenuItemUI.arrowIconRect.x, SynthMenuItemUI.arrowIconRect.y, SynthMenuItemUI.arrowIconRect.width, SynthMenuItemUI.arrowIconRect.height);
        }
    }

    private static String layoutMenuItem(SynthContext context, FontMetrics fm, SynthContext accContext, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap, boolean useCheckAndArrow) {
        SynthPopupMenuUI popupUI = null;
        JComponent b = context.getComponent();
        Container parent = b.getParent();
        if (parent instanceof JPopupMenu) {
            popupUI = (SynthPopupMenuUI)SynthLookAndFeel.getUIOfType(((JPopupMenu)parent).getUI(), SynthPopupMenuUI.class);
        }
        context.getStyle().getGraphicsUtils(context).layoutText(context, fm, text, icon, horizontalAlignment, verticalAlignment, horizontalTextPosition, verticalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.width = 0;
            acceleratorRect.height = 0;
            acceleratorText = "";
        } else {
            SynthStyle style = accContext.getStyle();
            acceleratorRect.width = style.getGraphicsUtils(accContext).computeStringWidth(accContext, fmAccel.getFont(), fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
            textRect.width += menuItemGap;
        }
        if (useCheckAndArrow) {
            if (checkIcon != null) {
                checkIconRect.width = SynthIcon.getIconWidth(checkIcon, context);
                checkIconRect.height = SynthIcon.getIconHeight(checkIcon, context);
            } else {
                checkIconRect.width = 0;
                checkIconRect.height = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = SynthIcon.getIconWidth(arrowIcon, context);
                arrowIconRect.height = SynthIcon.getIconHeight(arrowIcon, context);
            } else {
                arrowIconRect.width = 0;
                arrowIconRect.height = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (SynthLookAndFeel.isLeftToRight(context.getComponent())) {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (useCheckAndArrow) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
            if (popupUI != null) {
                int thisTextOffset = popupUI.adjustTextOffset(textRect.x - viewRect.x);
                textRect.x = thisTextOffset + viewRect.x;
                if (icon != null) {
                    if (horizontalTextPosition == 11 || horizontalTextPosition == 4) {
                        int thisIconOffset = popupUI.adjustIconOffset(iconRect.x - viewRect.x);
                        iconRect.x = thisIconOffset + viewRect.x;
                    } else if (horizontalTextPosition == 10 || horizontalTextPosition == 2) {
                        iconRect.x = textRect.x + textRect.width + menuItemGap;
                    } else {
                        int maxIconValue = popupUI.adjustIconOffset(0);
                        iconRect.x = Math.max(textRect.x + textRect.width / 2 - iconRect.width / 2, maxIconValue + viewRect.x);
                    }
                }
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (useCheckAndArrow) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
            if (popupUI != null) {
                int thisTextOffset = viewRect.x + viewRect.width - textRect.x - textRect.width;
                thisTextOffset = popupUI.adjustTextOffset(thisTextOffset);
                textRect.x = viewRect.x + viewRect.width - thisTextOffset - textRect.width;
                if (icon != null) {
                    if (horizontalTextPosition == 11 || horizontalTextPosition == 2) {
                        int thisIconOffset = viewRect.x + viewRect.width - iconRect.x - iconRect.width;
                        thisIconOffset = popupUI.adjustIconOffset(thisIconOffset);
                        iconRect.x = viewRect.x + viewRect.width - thisIconOffset - iconRect.width;
                    } else if (horizontalTextPosition == 10 || horizontalTextPosition == 4) {
                        iconRect.x = textRect.x - menuItemGap - iconRect.width;
                    } else {
                        int maxIconValue = popupUI.adjustIconOffset(0);
                        iconRect.x = textRect.x + textRect.width / 2 - iconRect.width / 2;
                        if (iconRect.x + iconRect.width > viewRect.x + viewRect.width - maxIconValue) {
                            iconRect.x = viewRect.x + viewRect.width - maxIconValue - iconRect.width;
                        }
                    }
                }
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (useCheckAndArrow) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }

    private static void resetRects() {
        iconRect.setBounds(0, 0, 0, 0);
        textRect.setBounds(0, 0, 0, 0);
        acceleratorRect.setBounds(0, 0, 0, 0);
        checkIconRect.setBounds(0, 0, 0, 0);
        arrowIconRect.setBounds(0, 0, 0, 0);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(0, 0, 0, 0);
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem mi) {
        SynthContext context = this.getContext((JComponent)mi, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (oldStyle != this.style) {
            String prefix = this.getPropertyPrefix();
            Object value = this.style.get(context, String.valueOf(prefix) + ".textIconGap");
            if (value != null) {
                LookAndFeel.installProperty(mi, "iconTextGap", value);
            }
            this.defaultTextIconGap = mi.getIconTextGap();
            if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(context, String.valueOf(prefix) + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.menuItem.setMargin(insets);
            }
            this.acceleratorDelimiter = this.style.getString(context, String.valueOf(prefix) + ".acceleratorDelimiter", "+");
            this.arrowIcon = this.style.getIcon(context, String.valueOf(prefix) + ".arrowIcon");
            this.checkIcon = this.style.getIcon(context, String.valueOf(prefix) + ".checkIcon");
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        SynthContext accContext = this.getContext(mi, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle = SynthLookAndFeel.updateStyle(accContext, this);
        accContext.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext((JComponent)this.menuItem, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        SynthContext accContext = this.getContext(this.menuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle.uninstallDefaults(accContext);
        accContext.dispose();
        this.accStyle = null;
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    public SynthContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SynthContext getContext(JComponent c, Region region, int state) {
        return SynthContext.getContext(SynthContext.class, c, region, this.accStyle, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        int state = !c.isEnabled() ? 8 : (this.menuItem.isArmed() ? 2 : SynthLookAndFeel.getComponentState(c));
        if (this.menuItem.isSelected()) {
            state |= 0x200;
        }
        return state;
    }

    private int getComponentState(JComponent c, Region region) {
        return this.getComponentState(c);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        SynthContext context = this.getContext(c);
        SynthContext accContext = this.getContext(c, Region.MENU_ITEM_ACCELERATOR);
        Dimension value = SynthMenuItemUI.getPreferredMenuItemSize(context, accContext, true, c, checkIcon, arrowIcon, defaultTextIconGap, this.acceleratorDelimiter);
        context.dispose();
        accContext.dispose();
        return value;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        this.paintBackground(context, g, c);
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        SynthContext accContext = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String prefix = this.getPropertyPrefix();
        SynthMenuItemUI.paint(context, accContext, g, this.style.getIcon(this.getContext(context.getComponent()), String.valueOf(prefix) + ".checkIcon"), this.style.getIcon(this.getContext(context.getComponent()), String.valueOf(prefix) + ".arrowIcon"), true, this.acceleratorDelimiter, this.defaultTextIconGap);
        accContext.dispose();
    }

    void paintBackground(SynthContext context, Graphics g, JComponent c) {
        context.getPainter().paintMenuItemBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintMenuItemBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JMenuItem)e.getSource());
        }
    }
}

