/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class SynthBasicTabbedUI
extends TabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected Color darkShadow;
    protected Color focus;
    private Color selectedColor;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    private boolean tabsOverlapBorder;
    private boolean tabsOpaque = true;
    private boolean contentOpaque = true;
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    private TabContainer tabContainer;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int focusIndex;
    private Handler handler;
    private int rolloverTabIndex;
    private boolean isRunsDirty;
    private boolean calculatedBaseline;
    private int baseline;
    private static int[] xCropLen;
    private static int[] yCropLen;
    private static final int CROP_SEGMENT = 12;

    static {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        xCropLen = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 6;
        nArray2[4] = 6;
        nArray2[5] = 9;
        nArray2[6] = 9;
        nArray2[7] = 12;
        yCropLen = nArray2;
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthBasicTabbedUI();
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static Object getUIOfType(ComponentUI ui, Class<?> klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    static void loadActionMap(ActionMap map) {
        map.put("navigateNext", new Actions("navigateNext"));
        map.put("navigatePrevious", new Actions("navigatePrevious"));
        map.put("navigateRight", new Actions("navigateRight"));
        map.put("navigateLeft", new Actions("navigateLeft"));
        map.put("navigateUp", new Actions("navigateUp"));
        map.put("navigateDown", new Actions("navigateDown"));
        map.put("navigatePageUp", new Actions("navigatePageUp"));
        map.put("navigatePageDown", new Actions("navigatePageDown"));
        map.put("requestFocus", new Actions("requestFocus"));
        map.put("requestFocusForVisibleComponent", new Actions("requestFocusForVisibleComponent"));
        map.put("setSelectedIndex", new Actions("setSelectedIndex"));
        map.put("selectTabWithFocus", new Actions("selectTabWithFocus"));
        map.put("scrollTabsForwardAction", new Actions("scrollTabsForwardAction"));
        map.put("scrollTabsBackwardAction", new Actions("scrollTabsBackwardAction"));
    }

    @Override
    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        this.calculatedBaseline = false;
        this.rolloverTabIndex = -1;
        this.focusIndex = -1;
        c.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        c.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
        this.installTabContainer();
    }

    private void installTabContainer() {
        int i = 0;
        while (i < this.tabPane.getTabCount()) {
            Component tabComponent = this.tabPane.getTabComponentAt(i);
            if (tabComponent != null) {
                if (this.tabContainer == null) {
                    this.tabContainer = new TabContainer();
                }
                this.tabContainer.add(tabComponent);
            }
            ++i;
        }
        if (this.tabContainer == null) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.tabPanel.add(this.tabContainer);
        } else {
            this.tabPane.add(this.tabContainer);
        }
    }

    protected JButton createScrollButton(int direction) {
        if (direction != 5 && direction != 1 && direction != 3 && direction != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new ScrollableTabButton(direction);
    }

    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    private void uninstallTabContainer() {
        if (this.tabContainer == null) {
            return;
        }
        this.tabContainer.notifyTabbedPane = false;
        this.tabContainer.removeAll();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabContainer.remove(this.tabScroller.croppedEdge);
            this.tabScroller.tabPanel.remove(this.tabContainer);
        } else {
            this.tabPane.remove(this.tabContainer);
        }
        this.tabContainer = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        Object opaque = UIManager.get("TabbedPane.opaque");
        if (opaque == null) {
            opaque = Boolean.FALSE;
        }
        LookAndFeel.installProperty(this.tabPane, "opaque", opaque);
        if (this.tabInsets == null) {
            this.tabInsets = new Insets(0, 4, 1, 4);
        }
        if (this.selectedTabPadInsets == null) {
            this.selectedTabPadInsets = new Insets(2, 2, 2, 1);
        }
        if (this.tabAreaInsets == null) {
            this.tabAreaInsets = new Insets(3, 2, 0, 2);
        }
        if (this.contentBorderInsets == null) {
            this.contentBorderInsets = new Insets(2, 2, 3, 3);
        }
    }

    protected void uninstallDefaults() {
        this.highlight = null;
        this.lightHighlight = null;
        this.shadow = null;
        this.darkShadow = null;
        this.focus = null;
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabPane.addMouseListener(this.mouseListener);
        }
        this.tabPane.addMouseMotionListener(this.getHandler());
        this.focusListener = this.createFocusListener();
        if (this.focusListener != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        this.tabPane.addContainerListener(this.getHandler());
        if (this.tabPane.getTabCount() > 0) {
            this.htmlViews = this.createHTMLVector();
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        this.tabPane.removeMouseMotionListener(this.getHandler());
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.tabPane.removeContainerListener(this.getHandler());
        if (this.htmlViews != null) {
            this.htmlViews.removeAllElements();
            this.htmlViews = null;
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.handler = null;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected ChangeListener createChangeListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        ActionMap map = new ActionMap();
        SynthBasicTabbedUI.loadActionMap(map);
        SwingUtilities.replaceUIActionMap(this.tabPane, map);
        this.updateMnemonics();
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.focusInputMap");
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, null);
        this.mnemonicToIndexMap = null;
        this.mnemonicInputMap = null;
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        int counter = this.tabPane.getTabCount() - 1;
        while (counter >= 0) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic > 0) {
                this.addMnemonic(counter, mnemonic);
            }
            --counter;
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(mnemonic), new Integer(index));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new ComponentInputMapUIResource(this.tabPane);
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 2));
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, this.mnemonicInputMap);
    }

    private void setRolloverTab(int x, int y) {
        this.setRolloverTab(this.tabForCoordinate(this.tabPane, x, y, false));
    }

    protected void setRolloverTab(int index) {
        this.rolloverTabIndex = index;
    }

    protected int getRolloverTab() {
        return this.rolloverTabIndex;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        int baseline = this.calculateBaselineIfNecessary();
        if (baseline != -1) {
            int placement = this.tabPane.getTabPlacement();
            Insets insets = this.tabPane.getInsets();
            Insets tabAreaInsets = this.getTabAreaInsets(placement);
            switch (placement) {
                case 1: {
                    return baseline += insets.top + tabAreaInsets.top;
                }
                case 3: {
                    baseline = height - insets.bottom - tabAreaInsets.bottom - this.maxTabHeight + baseline;
                    return baseline;
                }
                case 2: 
                case 4: {
                    return baseline += insets.top + tabAreaInsets.top;
                }
            }
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        switch (this.tabPane.getTabPlacement()) {
            case 1: 
            case 2: 
            case 4: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    protected int getBaseline(int tab) {
        if (this.tabPane.getTabComponentAt(tab) != null) {
            int offset = this.getBaselineOffset();
            if (offset != 0) {
                return -1;
            }
            Component c = this.tabPane.getTabComponentAt(tab);
            Dimension pref = c.getPreferredSize();
            Insets tabInsets = this.getTabInsets(this.tabPane.getTabPlacement(), tab);
            int cellHeight = this.maxTabHeight - tabInsets.top - tabInsets.bottom;
            return c.getBaseline(pref.width, pref.height) + (cellHeight - pref.height) / 2 + tabInsets.top;
        }
        View view = this.getTextViewForTab(tab);
        if (view != null) {
            int viewHeight = (int)view.getPreferredSpan(1);
            int baseline = BasicHTML.getHTMLBaseline(view, (int)view.getPreferredSpan(0), viewHeight);
            if (baseline >= 0) {
                return this.maxTabHeight / 2 - viewHeight / 2 + baseline + this.getBaselineOffset();
            }
            return -1;
        }
        FontMetrics metrics = this.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int fontBaseline = metrics.getAscent();
        return this.maxTabHeight / 2 - fontHeight / 2 + fontBaseline + this.getBaselineOffset();
    }

    protected int getBaselineOffset() {
        switch (this.tabPane.getTabPlacement()) {
            case 1: {
                if (this.tabPane.getTabCount() > 1) {
                    return 1;
                }
                return -1;
            }
            case 3: {
                if (this.tabPane.getTabCount() > 1) {
                    return -1;
                }
                return 1;
            }
        }
        return this.maxTabHeight % 2;
    }

    private int calculateBaselineIfNecessary() {
        if (!this.calculatedBaseline) {
            this.calculatedBaseline = true;
            this.baseline = -1;
            if (this.tabPane.getTabCount() > 0) {
                this.calculateBaseline();
            }
        }
        return this.baseline;
    }

    private void calculateBaseline() {
        int tabCount = this.tabPane.getTabCount();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.maxTabHeight = this.calculateMaxTabHeight(tabPlacement);
        this.baseline = this.getBaseline(0);
        if (this.isHorizontalTabPlacement()) {
            int i = 1;
            while (i < tabCount) {
                if (this.getBaseline(i) != this.baseline) {
                    this.baseline = -1;
                    break;
                }
                ++i;
            }
        } else {
            FontMetrics fontMetrics = this.getFontMetrics();
            int fontHeight = fontMetrics.getHeight();
            int height = this.calculateTabHeight(tabPlacement, 0, fontHeight);
            int i = 1;
            while (i < tabCount) {
                int newHeight = this.calculateTabHeight(tabPlacement, i, fontHeight);
                if (height != newHeight) {
                    this.baseline = -1;
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabsOverlapBorder) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
        if (!this.tabsOverlapBorder) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tabCount = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        int i = this.runCount - 1;
        while (i >= 0) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            int j = start;
            while (j <= end) {
                if (j != selectedIndex && this.rects[j].intersects(clipRect)) {
                    this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
                }
                ++j;
            }
            --i;
        }
        if (selectedIndex >= 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean isSelected;
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean bl = isSelected = selectedIndex == tabIndex;
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        }
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = SwingUtilities2.getFontMetrics(this.tabPane, g, font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        if (this.tabPane.getTabComponentAt(tabIndex) == null) {
            String clippedTitle = title;
            if (this.scrollableTabLayoutEnabled() && this.tabScroller.croppedEdge.isParamsSet() && this.tabScroller.croppedEdge.getTabIndex() == tabIndex && this.isHorizontalTabPlacement()) {
                int availTextWidth = this.tabScroller.croppedEdge.getCropline() - (textRect.x - tabRect.x) - this.tabScroller.croppedEdge.getCroppedSideWidth();
                clippedTitle = SwingUtilities2.clipStringIfNecessary(null, metrics, title, availTextWidth);
            }
            this.paintText(g, tabPlacement, font, metrics, tabIndex, clippedTitle, textRect, isSelected);
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    private boolean isHorizontalTabPlacement() {
        return this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3;
    }

    private static Polygon createCroppedTabShape(int tabPlacement, Rectangle tabRect, int cropline) {
        int rlen = 0;
        int start = 0;
        int end = 0;
        int ostart = 0;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                rlen = tabRect.width;
                start = tabRect.x;
                end = tabRect.x + tabRect.width;
                ostart = tabRect.y + tabRect.height;
                break;
            }
            default: {
                rlen = tabRect.height;
                start = tabRect.y;
                end = tabRect.y + tabRect.height;
                ostart = tabRect.x + tabRect.width;
            }
        }
        int rcnt = rlen / 12;
        if (rlen % 12 > 0) {
            ++rcnt;
        }
        int npts = 2 + rcnt * 8;
        int[] xp = new int[npts];
        int[] yp = new int[npts];
        int pcnt = 0;
        xp[pcnt] = ostart;
        yp[pcnt++] = end;
        xp[pcnt] = ostart;
        yp[pcnt++] = start;
        int i = 0;
        while (i < rcnt) {
            int j = 0;
            while (j < xCropLen.length) {
                xp[pcnt] = cropline - xCropLen[j];
                yp[pcnt] = start + i * 12 + yCropLen[j];
                if (yp[pcnt] >= end) {
                    yp[pcnt] = end;
                    ++pcnt;
                    break;
                }
                ++pcnt;
                ++j;
            }
            ++i;
        }
        if (tabPlacement == 1 || tabPlacement == 3) {
            return new Polygon(xp, yp, pcnt);
        }
        return new Polygon(yp, xp, pcnt);
    }

    private void paintCroppedTabEdge(Graphics g) {
        int tabIndex = this.tabScroller.croppedEdge.getTabIndex();
        int cropline = this.tabScroller.croppedEdge.getCropline();
        switch (this.tabPane.getTabPlacement()) {
            case 2: 
            case 4: {
                int x = this.rects[tabIndex].x;
                int y = cropline;
                int xx = x;
                g.setColor(this.shadow);
                while (xx <= x + this.rects[tabIndex].width) {
                    int i = 0;
                    while (i < xCropLen.length) {
                        g.drawLine(xx + yCropLen[i], y - xCropLen[i], xx + yCropLen[i + 1] - 1, y - xCropLen[i + 1]);
                        i += 2;
                    }
                    xx += 12;
                }
                break;
            }
            default: {
                int y;
                int x = cropline;
                int yy = y = this.rects[tabIndex].y;
                g.setColor(this.shadow);
                while (yy <= y + this.rects[tabIndex].height) {
                    int i = 0;
                    while (i < xCropLen.length) {
                        g.drawLine(x - xCropLen[i], yy + yCropLen[i], x - xCropLen[i + 1], yy + yCropLen[i + 1] - 1);
                        i += 2;
                    }
                    yy += 12;
                }
                break block0;
            }
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color selectedFG;
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if (isSelected && fg instanceof UIResource && (selectedFG = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                    fg = selectedFG;
                }
                g.setColor(fg);
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 2: {
                nudge = isSelected ? -1 : 1;
                break;
            }
            case 4: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            default: {
                nudge = tabRect.width % 2;
            }
        }
        return nudge;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 3: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                nudge = isSelected ? -1 : 1;
            }
        }
        return nudge;
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this.tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            g.setColor(this.focus);
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 6;
                    break;
                }
                case 4: {
                    x = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 6;
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w = tabRect.width - 6;
                    h = tabRect.height - 5;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 6;
                    h = tabRect.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.lightHighlight);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 1, y);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.setColor(this.shadow);
                g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                break;
            }
            default: {
                g.drawLine(x, y + 2, x, y + h - 1);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 3, y);
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            }
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(!isSelected || this.selectedColor == null ? this.tabPane.getBackgroundAt(tabIndex) : this.selectedColor);
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 3, h - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (this.tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (this.tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        if (this.tabPane.getTabCount() > 0 && (this.contentOpaque || this.tabPane.isOpaque())) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            if (color != null) {
                g.setColor(color);
            } else if (this.selectedColor == null || selectedIndex == -1) {
                g.setColor(this.tabPane.getBackground());
            } else {
                g.setColor(this.selectedColor);
            }
            g.fillRect(x, y, w, h);
        }
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y, x + w - 2, y);
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y, x, y + h - 2);
        } else {
            g.drawLine(x, y, x, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + 1, y + h - 2, selRect.x - 1, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.shadow);
                g.drawLine(selRect.x + selRect.width, y + h - 2, x + w - 2, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + w - 2, y + 1, x + w - 2, selRect.y - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, selRect.y + selRect.height, x + w - 2, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout layout = (TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        return this.tabForCoordinate(pane, x, y, true);
    }

    private int tabForCoordinate(JTabbedPane pane, int x, int y, boolean validateIfNecessary) {
        if (validateIfNecessary) {
            this.ensureCurrentLayout();
        }
        if (this.isRunsDirty) {
            return -1;
        }
        Point p = new Point(x, y);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
            Rectangle viewRect = this.tabScroller.viewport.getViewRect();
            if (!viewRect.contains(p)) {
                return -1;
            }
        }
        int tabCount = this.tabPane.getTabCount();
        int i = 0;
        while (i < tabCount) {
            if (this.rects[i].contains(p.x, p.y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point vpp = this.tabScroller.viewport.getLocation();
            Point viewp = this.tabScroller.viewport.getViewPosition();
            dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
            dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        } else {
            dest.x = this.rects[tabIndex].x;
            dest.y = this.rects[tabIndex].y;
        }
        return dest;
    }

    private int getClosestTab(int x, int y) {
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    private Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = srcx - vpp.x + viewp.x;
        dest.y = srcy - vpp.y + viewp.y;
        return dest;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane && this.visibleComponent.isVisible()) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int tabCount) {
        int rectArrayLen = this.rects.length;
        if (tabCount != rectArrayLen) {
            Rectangle[] tempRectArray = new Rectangle[tabCount];
            System.arraycopy(this.rects, 0, tempRectArray, 0, Math.min(rectArrayLen, tabCount));
            this.rects = tempRectArray;
            int rectIndex = rectArrayLen;
            while (rectIndex < tabCount) {
                this.rects[rectIndex] = new Rectangle();
                ++rectIndex;
            }
        }
    }

    protected void expandTabRunsArray() {
        int rectLen = this.tabRuns.length;
        int[] newArray = new int[rectLen + 10];
        System.arraycopy(this.tabRuns, 0, newArray, 0, this.runCount);
        this.tabRuns = newArray;
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        int i = 0;
        while (i < this.runCount) {
            int first = this.tabRuns[i];
            int last = this.lastTabInRun(tabCount, i);
            if (tabIndex >= first && tabIndex <= last) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected int lastTabInRun(int tabCount, int run) {
        int nextRun;
        if (this.runCount == 1) {
            return tabCount - 1;
        }
        int n = nextRun = run == this.runCount - 1 ? 0 : run + 1;
        if (this.tabRuns[nextRun] == 0) {
            return tabCount - 1;
        }
        return this.tabRuns[nextRun] - 1;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected Icon getIconForTab(int tabIndex) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex) ? this.tabPane.getDisabledIconAt(tabIndex) : this.tabPane.getIconAt(tabIndex);
    }

    protected View getTextViewForTab(int tabIndex) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(tabIndex);
        }
        return null;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = 0;
        Component c = this.tabPane.getTabComponentAt(tabIndex);
        if (c != null) {
            height = c.getPreferredSize().height;
        } else {
            View v = this.getTextViewForTab(tabIndex);
            height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += fontHeight);
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                height = Math.max(height, icon.getIconHeight());
            }
        }
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        return height += tabInsets.top + tabInsets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        int fontHeight = metrics.getHeight();
        int i = 0;
        while (i < tabCount) {
            result = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), result);
            ++i;
        }
        return result;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right + 3;
        Component tabComponent = this.tabPane.getTabComponentAt(tabIndex);
        if (tabComponent != null) {
            width += tabComponent.getPreferredSize().width;
        } else {
            View v;
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                width += icon.getIconWidth() + this.textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this.tabPane.getTitleAt(tabIndex);
                width += SwingUtilities2.stringWidth(this.tabPane, metrics, title);
            }
        }
        return width;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        int i = 0;
        while (i < tabCount) {
            result = Math.max(this.calculateTabWidth(tabPlacement, i, metrics), result);
            ++i;
        }
        return result;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return horizRunCount > 0 ? horizRunCount * (maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return vertRunCount > 0 ? vertRunCount * (maxTabWidth - tabRunOverlay) + tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right : 0;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        SynthBasicTabbedUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, tabPlacement);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        SynthBasicTabbedUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, tabPlacement);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return this.tabPane.getFontMetrics(font);
    }

    protected void navigateSelectedTab(int direction) {
        int tabPlacement = this.tabPane.getTabPlacement();
        int current = DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true) ? this.tabPane.getSelectedIndex() : this.getFocusIndex();
        int tabCount = this.tabPane.getTabCount();
        boolean leftToRight = SynthBasicTabbedUI.isLeftToRight(this.tabPane);
        if (tabCount <= 0) {
            return;
        }
        block0 : switch (tabPlacement) {
            case 2: 
            case 4: {
                switch (direction) {
                    case 12: {
                        this.selectNextTab(current);
                        break;
                    }
                    case 13: {
                        this.selectPreviousTab(current);
                        break;
                    }
                    case 1: {
                        this.selectPreviousTabInRun(current);
                        break;
                    }
                    case 5: {
                        this.selectNextTabInRun(current);
                        break;
                    }
                    case 7: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break;
                    }
                    case 3: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                    }
                }
                break;
            }
            default: {
                switch (direction) {
                    case 12: {
                        this.selectNextTab(current);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(current);
                        break block0;
                    }
                    case 1: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 5: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        if (leftToRight) {
                            this.selectNextTabInRun(current);
                            break block0;
                        }
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        if (leftToRight) {
                            this.selectPreviousTabInRun(current);
                            break block0;
                        }
                        this.selectNextTabInRun(current);
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        int tabCount = this.tabPane.getTabCount();
        int tabIndex = this.getNextTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndexInRun(tabCount, tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    protected void selectPreviousTabInRun(int current) {
        int tabCount = this.tabPane.getTabCount();
        int tabIndex = this.getPreviousTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndexInRun(tabCount, tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    protected void selectNextTab(int current) {
        int tabIndex = this.getNextTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndex(tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    protected void selectPreviousTab(int current) {
        int tabIndex = this.getPreviousTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndex(tabIndex);
        }
        this.navigateTo(tabIndex);
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int newIndex;
        if (this.runCount < 2) {
            return;
        }
        Rectangle r = this.rects[tabIndex];
        switch (tabPlacement) {
            case 2: 
            case 4: {
                newIndex = this.tabForCoordinate(this.tabPane, r.x + r.width / 2 + offset, r.y + r.height / 2);
                break;
            }
            default: {
                newIndex = this.tabForCoordinate(this.tabPane, r.x + r.width / 2, r.y + r.height / 2 + offset);
            }
        }
        if (newIndex != -1) {
            while (!this.tabPane.isEnabledAt(newIndex) && newIndex != tabIndex) {
                newIndex = this.getNextTabIndex(newIndex);
            }
            this.navigateTo(newIndex);
        }
    }

    private void navigateTo(int index) {
        if (DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true)) {
            this.tabPane.setSelectedIndex(index);
        } else {
            this.setFocusIndex(index, true);
        }
    }

    void setFocusIndex(int index, boolean repaint) {
        if (repaint && !this.isRunsDirty) {
            this.repaintTab(this.focusIndex);
            this.focusIndex = index;
            this.repaintTab(this.focusIndex);
        } else {
            this.focusIndex = index;
        }
    }

    private void repaintTab(int index) {
        if (!this.isRunsDirty && index >= 0 && index < this.tabPane.getTabCount()) {
            this.tabPane.repaint(this.getTabBounds(this.tabPane, index));
        }
    }

    private void validateFocusIndex() {
        if (this.focusIndex >= this.tabPane.getTabCount()) {
            this.setFocusIndex(this.tabPane.getSelectedIndex(), false);
        }
    }

    protected int getFocusIndex() {
        return this.focusIndex;
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int offset;
        int run = this.getRunForTab(tabCount, tabIndex);
        switch (tabPlacement) {
            case 2: {
                if (run == 0) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (run == 0) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (run == 0) {
                    offset = forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                offset = forward ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                offset = run == 0 ? (forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (run == this.runCount - 1 ? (forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (forward ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        int tabIndex = base - 1 >= 0 ? base - 1 : this.tabPane.getTabCount() - 1;
        return tabIndex >= 0 ? tabIndex : 0;
    }

    protected int getNextTabIndex(int base) {
        return (base + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        int next = this.getNextTabIndex(base);
        if (next == this.tabRuns[this.getNextTabRun(currentRun)]) {
            return this.tabRuns[currentRun];
        }
        return next;
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        if (base == this.tabRuns[currentRun]) {
            int previous = this.tabRuns[this.getNextTabRun(currentRun)] - 1;
            return previous != -1 ? previous : tabCount - 1;
        }
        return this.getPreviousTabIndex(base);
    }

    protected int getPreviousTabRun(int baseRun) {
        int runIndex = baseRun - 1 >= 0 ? baseRun - 1 : this.runCount - 1;
        return runIndex >= 0 ? runIndex : 0;
    }

    protected int getNextTabRun(int baseRun) {
        return (baseRun + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 2: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.top;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.bottom;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.top;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.bottom;
                targetInsets.right = topInsets.right;
            }
        }
    }

    boolean requestFocusForVisibleComponent() {
        return SwingUtilities2.tabbedPaneChangeFocusTo(this.getVisibleComponent());
    }

    private Vector createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this.tabPane.getTabCount();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                String title = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this.tabPane, title));
                } else {
                    htmlViews.addElement(null);
                }
                ++i;
            }
        }
        return htmlViews;
    }

    private static class Actions
    extends UIAction {
        static final String NEXT = "navigateNext";
        static final String PREVIOUS = "navigatePrevious";
        static final String RIGHT = "navigateRight";
        static final String LEFT = "navigateLeft";
        static final String UP = "navigateUp";
        static final String DOWN = "navigateDown";
        static final String PAGE_UP = "navigatePageUp";
        static final String PAGE_DOWN = "navigatePageDown";
        static final String REQUEST_FOCUS = "requestFocus";
        static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        static final String SET_SELECTED = "setSelectedIndex";
        static final String SELECT_FOCUSED = "selectTabWithFocus";
        static final String SCROLL_FORWARD = "scrollTabsForwardAction";
        static final String SCROLL_BACKWARD = "scrollTabsBackwardAction";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = this.getName();
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SynthBasicTabbedUI ui = (SynthBasicTabbedUI)SynthBasicTabbedUI.getUIOfType(pane.getUI(), SynthBasicTabbedUI.class);
            if (ui == null) {
                return;
            }
            if (key == NEXT) {
                ui.navigateSelectedTab(12);
            } else if (key == PREVIOUS) {
                ui.navigateSelectedTab(13);
            } else if (key == RIGHT) {
                ui.navigateSelectedTab(3);
            } else if (key == LEFT) {
                ui.navigateSelectedTab(7);
            } else if (key == UP) {
                ui.navigateSelectedTab(1);
            } else if (key == DOWN) {
                ui.navigateSelectedTab(5);
            } else if (key == PAGE_UP) {
                int tabPlacement = pane.getTabPlacement();
                if (tabPlacement == 1 || tabPlacement == 3) {
                    ui.navigateSelectedTab(7);
                } else {
                    ui.navigateSelectedTab(1);
                }
            } else if (key == PAGE_DOWN) {
                int tabPlacement = pane.getTabPlacement();
                if (tabPlacement == 1 || tabPlacement == 3) {
                    ui.navigateSelectedTab(3);
                } else {
                    ui.navigateSelectedTab(5);
                }
            } else if (key == REQUEST_FOCUS) {
                pane.requestFocus();
            } else if (key == REQUEST_FOCUS_FOR_VISIBLE) {
                ui.requestFocusForVisibleComponent();
            } else if (key == SET_SELECTED) {
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(new Integer(mnemonic))) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            } else if (key == SELECT_FOCUSED) {
                int focusIndex = ui.getFocusIndex();
                if (focusIndex != -1) {
                    pane.setSelectedIndex(focusIndex);
                }
            } else if (key == SCROLL_FORWARD) {
                if (ui.scrollableTabLayoutEnabled()) {
                    ui.tabScroller.scrollForward(pane.getTabPlacement());
                }
            } else if (key == SCROLL_BACKWARD && ui.scrollableTabLayoutEnabled()) {
                ui.tabScroller.scrollBackward(pane.getTabPlacement());
            }
        }
    }

    private class CroppedEdge
    extends JPanel
    implements UIResource {
        private Shape shape;
        private int tabIndex;
        private int cropline;
        private int cropx;
        private int cropy;

        public CroppedEdge() {
            this.setOpaque(false);
        }

        public void setParams(int tabIndex, int cropline, int cropx, int cropy) {
            this.tabIndex = tabIndex;
            this.cropline = cropline;
            this.cropx = cropx;
            this.cropy = cropy;
            Rectangle tabRect = SynthBasicTabbedUI.this.rects[tabIndex];
            this.setBounds(tabRect);
            this.shape = SynthBasicTabbedUI.createCroppedTabShape(SynthBasicTabbedUI.this.tabPane.getTabPlacement(), tabRect, cropline);
            if (this.getParent() == null && SynthBasicTabbedUI.this.tabContainer != null) {
                SynthBasicTabbedUI.this.tabContainer.add((Component)this, 0);
            }
        }

        public void resetParams() {
            this.shape = null;
            if (this.getParent() == SynthBasicTabbedUI.this.tabContainer && SynthBasicTabbedUI.this.tabContainer != null) {
                SynthBasicTabbedUI.this.tabContainer.remove(this);
            }
        }

        public boolean isParamsSet() {
            return this.shape != null;
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public int getCropline() {
            return this.cropline;
        }

        public int getCroppedSideWidth() {
            return 3;
        }

        private Color getBgColor() {
            Color bg;
            Container parent = SynthBasicTabbedUI.this.tabPane.getParent();
            if (parent != null && (bg = parent.getBackground()) != null) {
                return bg;
            }
            return UIManager.getColor("control");
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isParamsSet() && g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                g2.clipRect(0, 0, this.getWidth(), this.getHeight());
                g2.setColor(this.getBgColor());
                g2.translate(this.cropx, this.cropy);
                g2.fill(this.shape);
                SynthBasicTabbedUI.this.paintCroppedTabEdge(g);
                g2.translate(-this.cropx, -this.cropy);
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent e) {
            SynthBasicTabbedUI.this.getHandler().focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            SynthBasicTabbedUI.this.getHandler().focusLost(e);
        }
    }

    private class Handler
    implements ChangeListener,
    ContainerListener,
    FocusListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            String name = e.getPropertyName();
            boolean isScrollLayout = SynthBasicTabbedUI.this.scrollableTabLayoutEnabled();
            if (name == "mnemonicAt") {
                SynthBasicTabbedUI.this.updateMnemonics();
                pane.repaint();
            } else if (name == "displayedMnemonicIndexAt") {
                pane.repaint();
            } else if (name == "indexForTitle") {
                SynthBasicTabbedUI.this.calculatedBaseline = false;
                this.updateHtmlViews((Integer)e.getNewValue());
            } else if (name == "tabLayoutPolicy") {
                SynthBasicTabbedUI.this.uninstallUI(pane);
                SynthBasicTabbedUI.this.installUI(pane);
                SynthBasicTabbedUI.this.calculatedBaseline = false;
            } else if (name == "tabPlacement") {
                if (SynthBasicTabbedUI.this.scrollableTabLayoutEnabled()) {
                    SynthBasicTabbedUI.this.tabScroller.createButtons();
                }
                SynthBasicTabbedUI.this.calculatedBaseline = false;
            } else if (name == "opaque" && isScrollLayout) {
                boolean newVal = (Boolean)e.getNewValue();
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.tabPanel.setOpaque(newVal);
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.viewport.setOpaque(newVal);
            } else if (name == "background" && isScrollLayout) {
                Color newVal = (Color)e.getNewValue();
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.tabPanel.setBackground(newVal);
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.viewport.setBackground(newVal);
                Color newColor = SynthBasicTabbedUI.this.selectedColor == null ? newVal : SynthBasicTabbedUI.this.selectedColor;
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollForwardButton.setBackground(newColor);
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollBackwardButton.setBackground(newColor);
            } else if (name == "indexForTabComponent") {
                Component c;
                if (SynthBasicTabbedUI.this.tabContainer != null) {
                    SynthBasicTabbedUI.this.tabContainer.removeUnusedTabComponents();
                }
                if ((c = SynthBasicTabbedUI.this.tabPane.getTabComponentAt((Integer)e.getNewValue())) != null) {
                    if (SynthBasicTabbedUI.this.tabContainer == null) {
                        SynthBasicTabbedUI.this.installTabContainer();
                    } else {
                        SynthBasicTabbedUI.this.tabContainer.add(c);
                    }
                }
                SynthBasicTabbedUI.this.tabPane.revalidate();
                SynthBasicTabbedUI.this.tabPane.repaint();
                SynthBasicTabbedUI.this.calculatedBaseline = false;
            } else if (name == "indexForNullComponent") {
                SynthBasicTabbedUI.this.isRunsDirty = true;
                this.updateHtmlViews((Integer)e.getNewValue());
            } else if (name == "font") {
                SynthBasicTabbedUI.this.calculatedBaseline = false;
            }
        }

        private void updateHtmlViews(int index) {
            String title = SynthBasicTabbedUI.this.tabPane.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (SynthBasicTabbedUI.this.htmlViews == null) {
                    SynthBasicTabbedUI.this.htmlViews = SynthBasicTabbedUI.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(SynthBasicTabbedUI.this.tabPane, title);
                    SynthBasicTabbedUI.this.htmlViews.insertElementAt(v, index);
                }
            } else if (SynthBasicTabbedUI.this.htmlViews != null) {
                SynthBasicTabbedUI.this.htmlViews.insertElementAt(null, index);
            }
            SynthBasicTabbedUI.this.updateMnemonics();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int index;
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
            SynthBasicTabbedUI.this.setFocusIndex(tabPane.getSelectedIndex(), false);
            if (SynthBasicTabbedUI.this.scrollableTabLayoutEnabled() && (index = tabPane.getSelectedIndex()) < SynthBasicTabbedUI.this.rects.length && index != -1) {
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.tabPanel.scrollRectToVisible((Rectangle)SynthBasicTabbedUI.this.rects[index].clone());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SynthBasicTabbedUI.this.setRolloverTab(e.getX(), e.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SynthBasicTabbedUI.this.setRolloverTab(-1);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SynthBasicTabbedUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = SynthBasicTabbedUI.this.tabForCoordinate(SynthBasicTabbedUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && SynthBasicTabbedUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex != SynthBasicTabbedUI.this.tabPane.getSelectedIndex()) {
                    SynthBasicTabbedUI.this.tabPane.setSelectedIndex(tabIndex);
                } else if (SynthBasicTabbedUI.this.tabPane.isRequestFocusEnabled()) {
                    SynthBasicTabbedUI.this.tabPane.requestFocus();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SynthBasicTabbedUI.this.setRolloverTab(e.getX(), e.getY());
        }

        @Override
        public void focusGained(FocusEvent e) {
            SynthBasicTabbedUI.this.setFocusIndex(SynthBasicTabbedUI.this.tabPane.getSelectedIndex(), true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            SynthBasicTabbedUI.this.repaintTab(SynthBasicTabbedUI.this.focusIndex);
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            SynthBasicTabbedUI.this.isRunsDirty = true;
            this.updateHtmlViews(tp.indexOfComponent(child));
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            Integer indexObj = (Integer)tp.getClientProperty("__index_to_remove__");
            if (indexObj != null) {
                int index = indexObj;
                if (SynthBasicTabbedUI.this.htmlViews != null && SynthBasicTabbedUI.this.htmlViews.size() > index) {
                    SynthBasicTabbedUI.this.htmlViews.removeElementAt(index);
                }
                tp.putClientProperty("__index_to_remove__", null);
            }
            SynthBasicTabbedUI.this.isRunsDirty = true;
            SynthBasicTabbedUI.this.updateMnemonics();
            SynthBasicTabbedUI.this.validateFocusIndex();
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            SynthBasicTabbedUI.this.getHandler().mousePressed(e);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SynthBasicTabbedUI.this.getHandler().propertyChange(e);
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int direction) {
            super(direction, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            super(null);
            this.setOpaque(SynthBasicTabbedUI.this.tabPane.isOpaque());
            Color bgColor = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (bgColor == null) {
                bgColor = SynthBasicTabbedUI.this.tabPane.getBackground();
            }
            this.setBackground(bgColor);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            SynthBasicTabbedUI.this.paintTabArea(g, SynthBasicTabbedUI.this.tabPane.getTabPlacement(), SynthBasicTabbedUI.this.tabPane.getSelectedIndex());
            if (((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.croppedEdge.isParamsSet() && SynthBasicTabbedUI.this.tabContainer == null) {
                Rectangle croppedRect = SynthBasicTabbedUI.this.rects[((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.croppedEdge.getTabIndex()];
                g.translate(croppedRect.x, croppedRect.y);
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.croppedEdge.paintComponent(g);
                g.translate(-croppedRect.x, -croppedRect.y);
            }
        }

        @Override
        public void doLayout() {
            if (this.getComponentCount() > 0) {
                Component child = this.getComponent(0);
                child.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ScrollableTabSupport
    implements ActionListener,
    ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public CroppedEdge croppedEdge;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.croppedEdge = new CroppedEdge();
            this.createButtons();
        }

        void createButtons() {
            int tabPlacement;
            if (this.scrollForwardButton != null) {
                SynthBasicTabbedUI.this.tabPane.remove(this.scrollForwardButton);
                this.scrollForwardButton.removeActionListener(this);
                SynthBasicTabbedUI.this.tabPane.remove(this.scrollBackwardButton);
                this.scrollBackwardButton.removeActionListener(this);
            }
            if ((tabPlacement = SynthBasicTabbedUI.this.tabPane.getTabPlacement()) == 1 || tabPlacement == 3) {
                this.scrollForwardButton = SynthBasicTabbedUI.this.createScrollButton(3);
                this.scrollBackwardButton = SynthBasicTabbedUI.this.createScrollButton(7);
            } else {
                this.scrollForwardButton = SynthBasicTabbedUI.this.createScrollButton(5);
                this.scrollBackwardButton = SynthBasicTabbedUI.this.createScrollButton(1);
            }
            this.scrollForwardButton.addActionListener(this);
            this.scrollBackwardButton.addActionListener(this);
            SynthBasicTabbedUI.this.tabPane.add(this.scrollForwardButton);
            SynthBasicTabbedUI.this.tabPane.add(this.scrollBackwardButton);
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : SynthBasicTabbedUI.this.rects[this.leadingTabIndex].x;
                    if (viewSize.width - this.tabViewPosition.x >= viewRect.width) break;
                    Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                    this.viewport.setExtentSize(extentSize);
                    break;
                }
                case 2: 
                case 4: {
                    int n = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : SynthBasicTabbedUI.this.rects[this.leadingTabIndex].y;
                    if (viewSize.height - this.tabViewPosition.y >= viewRect.height) break;
                    Dimension extentSize = new Dimension(viewRect.width, viewSize.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(extentSize);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateView();
        }

        private void updateView() {
            int tabPlacement = SynthBasicTabbedUI.this.tabPane.getTabPlacement();
            int tabCount = SynthBasicTabbedUI.this.tabPane.getTabCount();
            Rectangle vpRect = this.viewport.getBounds();
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            this.leadingTabIndex = SynthBasicTabbedUI.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex + 1 < tabCount) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        if (SynthBasicTabbedUI.this.rects[this.leadingTabIndex].x >= viewRect.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (SynthBasicTabbedUI.this.rects[this.leadingTabIndex].y >= viewRect.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets contentInsets = SynthBasicTabbedUI.this.getContentBorderInsets(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    SynthBasicTabbedUI.this.tabPane.repaint(vpRect.x + vpRect.width, vpRect.y, contentInsets.left, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 4: {
                    SynthBasicTabbedUI.this.tabPane.repaint(vpRect.x - contentInsets.right, vpRect.y, contentInsets.right, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 3: {
                    SynthBasicTabbedUI.this.tabPane.repaint(vpRect.x, vpRect.y - contentInsets.bottom, vpRect.width, contentInsets.bottom);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                    break;
                }
                default: {
                    SynthBasicTabbedUI.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionKey;
            Action action;
            ActionMap map = SynthBasicTabbedUI.this.tabPane.getActionMap();
            if (map != null && (action = map.get(actionKey = e.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : "scrollTabsBackwardAction")) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(SynthBasicTabbedUI.this.tabPane, 1001, null, e.getWhen(), e.getModifiers()));
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setName("TabbedPane.scrollableViewport");
            this.setScrollMode(0);
            this.setOpaque(SynthBasicTabbedUI.this.tabPane.isOpaque());
            Color bgColor = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (bgColor == null) {
                bgColor = SynthBasicTabbedUI.this.tabPane.getBackground();
            }
            this.setBackground(bgColor);
        }
    }

    private class TabContainer
    extends JPanel
    implements UIResource {
        private boolean notifyTabbedPane;

        public TabContainer() {
            super(null);
            this.notifyTabbedPane = true;
            this.setOpaque(false);
        }

        @Override
        public void remove(Component comp) {
            int index = SynthBasicTabbedUI.this.tabPane.indexOfTabComponent(comp);
            super.remove(comp);
            if (this.notifyTabbedPane && index != -1) {
                SynthBasicTabbedUI.this.tabPane.setTabComponentAt(index, null);
            }
        }

        private void removeUnusedTabComponents() {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                int index;
                Component c = componentArray[n2];
                if (!(c instanceof UIResource) && (index = SynthBasicTabbedUI.this.tabPane.indexOfTabComponent(c)) == -1) {
                    super.remove(c);
                }
                ++n2;
            }
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return SynthBasicTabbedUI.this.tabScroller != null && !((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.croppedEdge.isParamsSet();
        }

        @Override
        public void doLayout() {
            if (SynthBasicTabbedUI.this.scrollableTabLayoutEnabled()) {
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.tabPanel.repaint();
                SynthBasicTabbedUI.this.tabScroller.updateView();
            } else {
                SynthBasicTabbedUI.this.tabPane.repaint(this.getBounds());
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            SynthBasicTabbedUI.this.getHandler().stateChanged(e);
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = SynthBasicTabbedUI.this.tabPane.getTabPlacement();
            Insets insets = SynthBasicTabbedUI.this.tabPane.getInsets();
            Insets contentInsets = SynthBasicTabbedUI.this.getContentBorderInsets(tabPlacement);
            Insets tabAreaInsets = SynthBasicTabbedUI.this.getTabAreaInsets(tabPlacement);
            Dimension zeroSize = new Dimension(0, 0);
            int height = 0;
            int width = 0;
            int cWidth = 0;
            int cHeight = 0;
            int i = 0;
            while (i < SynthBasicTabbedUI.this.tabPane.getTabCount()) {
                Component component = SynthBasicTabbedUI.this.tabPane.getComponentAt(i);
                if (component != null) {
                    Dimension size = zeroSize;
                    Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                    if (size != null) {
                        cHeight = Math.max(size.height, cHeight);
                        cWidth = Math.max(size.width, cWidth);
                    }
                }
                ++i;
            }
            width += cWidth;
            height += cHeight;
            int tabExtent = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    height = Math.max(height, SynthBasicTabbedUI.this.calculateMaxTabHeight(tabPlacement));
                    tabExtent = this.preferredTabAreaWidth(tabPlacement, height - tabAreaInsets.top - tabAreaInsets.bottom);
                    width += tabExtent;
                    break;
                }
                default: {
                    width = Math.max(width, SynthBasicTabbedUI.this.calculateMaxTabWidth(tabPlacement));
                    tabExtent = this.preferredTabAreaHeight(tabPlacement, width - tabAreaInsets.left - tabAreaInsets.right);
                    height += tabExtent;
                }
            }
            return new Dimension(width + insets.left + insets.right + contentInsets.left + contentInsets.right, height + insets.bottom + insets.top + contentInsets.top + contentInsets.bottom);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            FontMetrics metrics = SynthBasicTabbedUI.this.getFontMetrics();
            int tabCount = SynthBasicTabbedUI.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int rows = 1;
                int x = 0;
                int maxTabHeight = SynthBasicTabbedUI.this.calculateMaxTabHeight(tabPlacement);
                int i = 0;
                while (i < tabCount) {
                    int tabWidth = SynthBasicTabbedUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    if (x != 0 && x + tabWidth > width) {
                        ++rows;
                        x = 0;
                    }
                    x += tabWidth;
                    ++i;
                }
                total = SynthBasicTabbedUI.this.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
            }
            return total;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            FontMetrics metrics = SynthBasicTabbedUI.this.getFontMetrics();
            int tabCount = SynthBasicTabbedUI.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int columns = 1;
                int y = 0;
                int fontHeight = metrics.getHeight();
                SynthBasicTabbedUI.this.maxTabWidth = SynthBasicTabbedUI.this.calculateMaxTabWidth(tabPlacement);
                int i = 0;
                while (i < tabCount) {
                    int tabHeight = SynthBasicTabbedUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    if (y != 0 && y + tabHeight > height) {
                        ++columns;
                        y = 0;
                    }
                    y += tabHeight;
                    ++i;
                }
                total = SynthBasicTabbedUI.this.calculateTabAreaWidth(tabPlacement, columns, SynthBasicTabbedUI.this.maxTabWidth);
            }
            return total;
        }

        @Override
        public void layoutContainer(Container parent) {
            SynthBasicTabbedUI.this.setRolloverTab(-1);
            int tabPlacement = SynthBasicTabbedUI.this.tabPane.getTabPlacement();
            Insets insets = SynthBasicTabbedUI.this.tabPane.getInsets();
            int selectedIndex = SynthBasicTabbedUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = SynthBasicTabbedUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    SynthBasicTabbedUI.this.setVisibleComponent(null);
                }
            } else {
                selectedComponent = SynthBasicTabbedUI.this.tabPane.getComponentAt(selectedIndex);
            }
            int totalTabWidth = 0;
            int totalTabHeight = 0;
            Insets contentInsets = SynthBasicTabbedUI.this.getContentBorderInsets(tabPlacement);
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                SynthBasicTabbedUI.this.setVisibleComponent(selectedComponent);
            }
            Rectangle bounds = SynthBasicTabbedUI.this.tabPane.getBounds();
            int numChildren = SynthBasicTabbedUI.this.tabPane.getComponentCount();
            if (numChildren > 0) {
                int cy;
                int cx;
                switch (tabPlacement) {
                    case 2: {
                        totalTabWidth = SynthBasicTabbedUI.this.calculateTabAreaWidth(tabPlacement, SynthBasicTabbedUI.this.runCount, SynthBasicTabbedUI.this.maxTabWidth);
                        cx = insets.left + totalTabWidth + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    case 4: {
                        totalTabWidth = SynthBasicTabbedUI.this.calculateTabAreaWidth(tabPlacement, SynthBasicTabbedUI.this.runCount, SynthBasicTabbedUI.this.maxTabWidth);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    case 3: {
                        totalTabHeight = SynthBasicTabbedUI.this.calculateTabAreaHeight(tabPlacement, SynthBasicTabbedUI.this.runCount, SynthBasicTabbedUI.this.maxTabHeight);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    default: {
                        totalTabHeight = SynthBasicTabbedUI.this.calculateTabAreaHeight(tabPlacement, SynthBasicTabbedUI.this.runCount, SynthBasicTabbedUI.this.maxTabHeight);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + totalTabHeight + contentInsets.top;
                    }
                }
                int cw = bounds.width - totalTabWidth - insets.left - insets.right - contentInsets.left - contentInsets.right;
                int ch = bounds.height - totalTabHeight - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                int i = 0;
                while (i < numChildren) {
                    Component child = SynthBasicTabbedUI.this.tabPane.getComponent(i);
                    if (child == SynthBasicTabbedUI.this.tabContainer) {
                        int tabContainerWidth = totalTabWidth == 0 ? bounds.width : totalTabWidth + insets.left + insets.right + contentInsets.left + contentInsets.right;
                        int tabContainerHeight = totalTabHeight == 0 ? bounds.height : totalTabHeight + insets.top + insets.bottom + contentInsets.top + contentInsets.bottom;
                        int tabContainerX = 0;
                        int tabContainerY = 0;
                        if (tabPlacement == 3) {
                            tabContainerY = bounds.height - tabContainerHeight;
                        } else if (tabPlacement == 4) {
                            tabContainerX = bounds.width - tabContainerWidth;
                        }
                        child.setBounds(tabContainerX, tabContainerY, tabContainerWidth, tabContainerHeight);
                    } else {
                        child.setBounds(cx, cy, cw, ch);
                    }
                    ++i;
                }
            }
            this.layoutTabComponents();
            if (shouldChangeFocus && !SynthBasicTabbedUI.this.requestFocusForVisibleComponent()) {
                SynthBasicTabbedUI.this.tabPane.requestFocus();
            }
        }

        public void calculateLayoutInfo() {
            int tabCount = SynthBasicTabbedUI.this.tabPane.getTabCount();
            SynthBasicTabbedUI.this.assureRectsCreated(tabCount);
            this.calculateTabRects(SynthBasicTabbedUI.this.tabPane.getTabPlacement(), tabCount);
            SynthBasicTabbedUI.this.isRunsDirty = false;
        }

        private void layoutTabComponents() {
            if (SynthBasicTabbedUI.this.tabContainer == null) {
                return;
            }
            Rectangle rect = new Rectangle();
            Point delta = new Point(-SynthBasicTabbedUI.this.tabContainer.getX(), -SynthBasicTabbedUI.this.tabContainer.getY());
            if (SynthBasicTabbedUI.this.scrollableTabLayoutEnabled()) {
                SynthBasicTabbedUI.this.translatePointToTabPanel(0, 0, delta);
            }
            int i = 0;
            while (i < SynthBasicTabbedUI.this.tabPane.getTabCount()) {
                Component c = SynthBasicTabbedUI.this.tabPane.getTabComponentAt(i);
                if (c != null) {
                    SynthBasicTabbedUI.this.getTabBounds(i, rect);
                    Dimension preferredSize = c.getPreferredSize();
                    Insets insets = SynthBasicTabbedUI.this.getTabInsets(SynthBasicTabbedUI.this.tabPane.getTabPlacement(), i);
                    int outerX = rect.x + insets.left + delta.x;
                    int outerY = rect.y + insets.top + delta.y;
                    int outerWidth = rect.width - insets.left - insets.right;
                    int outerHeight = rect.height - insets.top - insets.bottom;
                    int x = outerX + (outerWidth - preferredSize.width) / 2;
                    int y = outerY + (outerHeight - preferredSize.height) / 2;
                    int tabPlacement = SynthBasicTabbedUI.this.tabPane.getTabPlacement();
                    boolean isSeleceted = i == SynthBasicTabbedUI.this.tabPane.getSelectedIndex();
                    c.setBounds(x + SynthBasicTabbedUI.this.getTabLabelShiftX(tabPlacement, i, isSeleceted), y + SynthBasicTabbedUI.this.getTabLabelShiftY(tabPlacement, i, isSeleceted), preferredSize.width, preferredSize.height);
                }
                ++i;
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int returnAt;
            int y;
            int x;
            FontMetrics metrics = SynthBasicTabbedUI.this.getFontMetrics();
            Dimension size = SynthBasicTabbedUI.this.tabPane.getSize();
            Insets insets = SynthBasicTabbedUI.this.tabPane.getInsets();
            Insets tabAreaInsets = SynthBasicTabbedUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = SynthBasicTabbedUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = SynthBasicTabbedUI.isLeftToRight(SynthBasicTabbedUI.this.tabPane);
            switch (tabPlacement) {
                case 2: {
                    SynthBasicTabbedUI.this.maxTabWidth = SynthBasicTabbedUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    SynthBasicTabbedUI.this.maxTabWidth = SynthBasicTabbedUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - SynthBasicTabbedUI.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    SynthBasicTabbedUI.this.maxTabHeight = SynthBasicTabbedUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - SynthBasicTabbedUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    SynthBasicTabbedUI.this.maxTabHeight = SynthBasicTabbedUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = SynthBasicTabbedUI.this.getTabRunOverlay(tabPlacement);
            SynthBasicTabbedUI.this.runCount = 0;
            SynthBasicTabbedUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            int i = 0;
            while (i < tabCount) {
                rect = SynthBasicTabbedUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = SynthBasicTabbedUI.this.rects[i - 1].x + SynthBasicTabbedUI.this.rects[i - 1].width;
                    } else {
                        SynthBasicTabbedUI.this.tabRuns[0] = 0;
                        SynthBasicTabbedUI.this.runCount = 1;
                        SynthBasicTabbedUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = SynthBasicTabbedUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    SynthBasicTabbedUI.this.maxTabWidth = Math.max(SynthBasicTabbedUI.this.maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (SynthBasicTabbedUI.this.runCount > SynthBasicTabbedUI.this.tabRuns.length - 1) {
                            SynthBasicTabbedUI.this.expandTabRunsArray();
                        }
                        SynthBasicTabbedUI.this.tabRuns[SynthBasicTabbedUI.this.runCount] = i;
                        ++SynthBasicTabbedUI.this.runCount;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = SynthBasicTabbedUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = SynthBasicTabbedUI.this.rects[i - 1].y + SynthBasicTabbedUI.this.rects[i - 1].height;
                    } else {
                        SynthBasicTabbedUI.this.tabRuns[0] = 0;
                        SynthBasicTabbedUI.this.runCount = 1;
                        SynthBasicTabbedUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = SynthBasicTabbedUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    SynthBasicTabbedUI.this.maxTabHeight = Math.max(SynthBasicTabbedUI.this.maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (SynthBasicTabbedUI.this.runCount > SynthBasicTabbedUI.this.tabRuns.length - 1) {
                            SynthBasicTabbedUI.this.expandTabRunsArray();
                        }
                        SynthBasicTabbedUI.this.tabRuns[SynthBasicTabbedUI.this.runCount] = i;
                        ++SynthBasicTabbedUI.this.runCount;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = SynthBasicTabbedUI.this.maxTabWidth;
                }
                if (i == selectedIndex) {
                    SynthBasicTabbedUI.this.selectedRun = SynthBasicTabbedUI.this.runCount - 1;
                }
                ++i;
            }
            if (SynthBasicTabbedUI.this.runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                SynthBasicTabbedUI.this.selectedRun = SynthBasicTabbedUI.this.getRunForTab(tabCount, selectedIndex);
                if (SynthBasicTabbedUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, SynthBasicTabbedUI.this.selectedRun);
                }
            }
            i = SynthBasicTabbedUI.this.runCount - 1;
            while (i >= 0) {
                int j;
                int end;
                int start = SynthBasicTabbedUI.this.tabRuns[i];
                int next = SynthBasicTabbedUI.this.tabRuns[i == SynthBasicTabbedUI.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    j = start;
                    while (j <= end) {
                        rect = SynthBasicTabbedUI.this.rects[j];
                        rect.y = y;
                        rect.x += SynthBasicTabbedUI.this.getTabRunIndent(tabPlacement, i);
                        ++j;
                    }
                    if (SynthBasicTabbedUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    y = tabPlacement == 3 ? (y -= SynthBasicTabbedUI.this.maxTabHeight - tabRunOverlay) : (y += SynthBasicTabbedUI.this.maxTabHeight - tabRunOverlay);
                } else {
                    j = start;
                    while (j <= end) {
                        rect = SynthBasicTabbedUI.this.rects[j];
                        rect.x = x;
                        rect.y += SynthBasicTabbedUI.this.getTabRunIndent(tabPlacement, i);
                        ++j;
                    }
                    if (SynthBasicTabbedUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    x = tabPlacement == 4 ? (x -= SynthBasicTabbedUI.this.maxTabWidth - tabRunOverlay) : (x += SynthBasicTabbedUI.this.maxTabWidth - tabRunOverlay);
                }
                --i;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                i = 0;
                while (i < tabCount) {
                    SynthBasicTabbedUI.this.rects[i].x = rightMargin - SynthBasicTabbedUI.this.rects[i].x - SynthBasicTabbedUI.this.rects[i].width;
                    ++i;
                }
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            int i = 0;
            while (i < selectedRun) {
                int save = SynthBasicTabbedUI.this.tabRuns[0];
                int j = 1;
                while (j < SynthBasicTabbedUI.this.runCount) {
                    SynthBasicTabbedUI.this.tabRuns[j - 1] = SynthBasicTabbedUI.this.tabRuns[j];
                    ++j;
                }
                SynthBasicTabbedUI.this.tabRuns[SynthBasicTabbedUI.this.runCount - 1] = save;
                ++i;
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            int run = SynthBasicTabbedUI.this.runCount - 1;
            boolean keepAdjusting = true;
            double weight = 1.25;
            while (keepAdjusting) {
                int prevLastLen;
                int end;
                int last = SynthBasicTabbedUI.this.lastTabInRun(tabCount, run);
                int prevLast = SynthBasicTabbedUI.this.lastTabInRun(tabCount, run - 1);
                if (!verticalTabRuns) {
                    end = SynthBasicTabbedUI.this.rects[last].x + SynthBasicTabbedUI.this.rects[last].width;
                    prevLastLen = (int)((double)SynthBasicTabbedUI.this.maxTabWidth * weight);
                } else {
                    end = SynthBasicTabbedUI.this.rects[last].y + SynthBasicTabbedUI.this.rects[last].height;
                    prevLastLen = (int)((double)SynthBasicTabbedUI.this.maxTabHeight * weight * 2.0);
                }
                if (max - end > prevLastLen) {
                    SynthBasicTabbedUI.this.tabRuns[run] = prevLast;
                    if (!verticalTabRuns) {
                        SynthBasicTabbedUI.this.rects[prevLast].x = start;
                    } else {
                        SynthBasicTabbedUI.this.rects[prevLast].y = start;
                    }
                    int i = prevLast + 1;
                    while (i <= last) {
                        if (!verticalTabRuns) {
                            SynthBasicTabbedUI.this.rects[i].x = SynthBasicTabbedUI.this.rects[i - 1].x + SynthBasicTabbedUI.this.rects[i - 1].width;
                        } else {
                            SynthBasicTabbedUI.this.rects[i].y = SynthBasicTabbedUI.this.rects[i - 1].y + SynthBasicTabbedUI.this.rects[i - 1].height;
                        }
                        ++i;
                    }
                } else if (run == SynthBasicTabbedUI.this.runCount - 1) {
                    keepAdjusting = false;
                }
                if (run - 1 > 0) {
                    --run;
                    continue;
                }
                run = SynthBasicTabbedUI.this.runCount - 1;
                weight += 0.25;
            }
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            Rectangle lastRect = SynthBasicTabbedUI.this.rects[end];
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = lastRect.x + lastRect.width - SynthBasicTabbedUI.this.rects[start].x;
                int deltaWidth = max - (lastRect.x + lastRect.width);
                float factor = (float)deltaWidth / (float)runWidth;
                int j = start;
                while (j <= end) {
                    Rectangle pastRect = SynthBasicTabbedUI.this.rects[j];
                    if (j > start) {
                        pastRect.x = SynthBasicTabbedUI.this.rects[j - 1].x + SynthBasicTabbedUI.this.rects[j - 1].width;
                    }
                    pastRect.width += Math.round((float)pastRect.width * factor);
                    ++j;
                }
                lastRect.width = max - lastRect.x;
            } else {
                int runHeight = lastRect.y + lastRect.height - SynthBasicTabbedUI.this.rects[start].y;
                int deltaHeight = max - (lastRect.y + lastRect.height);
                float factor = (float)deltaHeight / (float)runHeight;
                int j = start;
                while (j <= end) {
                    Rectangle pastRect = SynthBasicTabbedUI.this.rects[j];
                    if (j > start) {
                        pastRect.y = SynthBasicTabbedUI.this.rects[j - 1].y + SynthBasicTabbedUI.this.rects[j - 1].height;
                    }
                    pastRect.height += Math.round((float)pastRect.height * factor);
                    ++j;
                }
                lastRect.height = max - lastRect.y;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            if (selectedIndex >= 0) {
                Rectangle selRect = SynthBasicTabbedUI.this.rects[selectedIndex];
                Insets padInsets = SynthBasicTabbedUI.this.getSelectedTabPadInsets(tabPlacement);
                selRect.x -= padInsets.left;
                selRect.width += padInsets.left + padInsets.right;
                selRect.y -= padInsets.top;
                selRect.height += padInsets.top + padInsets.bottom;
                if (!SynthBasicTabbedUI.this.scrollableTabLayoutEnabled()) {
                    Dimension size = SynthBasicTabbedUI.this.tabPane.getSize();
                    Insets insets = SynthBasicTabbedUI.this.tabPane.getInsets();
                    if (tabPlacement == 2 || tabPlacement == 4) {
                        int bottom;
                        int top = insets.top - selRect.y;
                        if (top > 0) {
                            selRect.y += top;
                            selRect.height -= top;
                        }
                        if ((bottom = selRect.y + selRect.height + insets.bottom - size.height) > 0) {
                            selRect.height -= bottom;
                        }
                    } else {
                        int right;
                        int left = insets.left - selRect.x;
                        if (left > 0) {
                            selRect.x += left;
                            selRect.width -= left;
                        }
                        if ((right = selRect.x + selRect.width + insets.right - size.width) > 0) {
                            selRect.width -= right;
                        }
                    }
                }
            }
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return SynthBasicTabbedUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return SynthBasicTabbedUI.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void layoutContainer(Container parent) {
            SynthBasicTabbedUI.this.setRolloverTab(-1);
            int tabPlacement = SynthBasicTabbedUI.this.tabPane.getTabPlacement();
            int tabCount = SynthBasicTabbedUI.this.tabPane.getTabCount();
            Insets insets = SynthBasicTabbedUI.this.tabPane.getInsets();
            int selectedIndex = SynthBasicTabbedUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = SynthBasicTabbedUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    SynthBasicTabbedUI.this.setVisibleComponent(null);
                }
            } else {
                selectedComponent = SynthBasicTabbedUI.this.tabPane.getComponentAt(selectedIndex);
            }
            if (SynthBasicTabbedUI.this.tabPane.getTabCount() == 0) {
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.croppedEdge.resetParams();
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollForwardButton.setVisible(false);
                ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollBackwardButton.setVisible(false);
                return;
            }
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                SynthBasicTabbedUI.this.setVisibleComponent(selectedComponent);
            }
            Insets contentInsets = SynthBasicTabbedUI.this.getContentBorderInsets(tabPlacement);
            Rectangle bounds = SynthBasicTabbedUI.this.tabPane.getBounds();
            int numChildren = SynthBasicTabbedUI.this.tabPane.getComponentCount();
            if (numChildren > 0) {
                int ch;
                int cw;
                int cy;
                int cx;
                int ty;
                int tx;
                int th;
                int tw;
                switch (tabPlacement) {
                    case 2: {
                        tw = SynthBasicTabbedUI.this.calculateTabAreaWidth(tabPlacement, SynthBasicTabbedUI.this.runCount, SynthBasicTabbedUI.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + tw + contentInsets.left;
                        cy = ty + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    case 4: {
                        tw = SynthBasicTabbedUI.this.calculateTabAreaWidth(tabPlacement, SynthBasicTabbedUI.this.runCount, SynthBasicTabbedUI.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = bounds.width - insets.right - tw;
                        ty = insets.top;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    case 3: {
                        tw = bounds.width - insets.left - insets.right;
                        th = SynthBasicTabbedUI.this.calculateTabAreaHeight(tabPlacement, SynthBasicTabbedUI.this.runCount, SynthBasicTabbedUI.this.maxTabHeight);
                        tx = insets.left;
                        ty = bounds.height - insets.bottom - th;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    default: {
                        tw = bounds.width - insets.left - insets.right;
                        th = SynthBasicTabbedUI.this.calculateTabAreaHeight(tabPlacement, SynthBasicTabbedUI.this.runCount, SynthBasicTabbedUI.this.maxTabHeight);
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + contentInsets.left;
                        cy = ty + th + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    }
                }
                int i = 0;
                while (i < numChildren) {
                    Component child = SynthBasicTabbedUI.this.tabPane.getComponent(i);
                    if (SynthBasicTabbedUI.this.tabScroller != null && child == ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.viewport) {
                        JViewport viewport = (JViewport)child;
                        Rectangle viewRect = viewport.getViewRect();
                        int vw = tw;
                        int vh = th;
                        Dimension butSize = ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollForwardButton.getPreferredSize();
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight = SynthBasicTabbedUI.this.rects[tabCount - 1].y + SynthBasicTabbedUI.this.rects[tabCount - 1].height;
                                if (totalTabHeight <= th) break;
                                int n = vh = th > 2 * butSize.height ? th - 2 * butSize.height : 0;
                                if (totalTabHeight - viewRect.y > vh) break;
                                vh = totalTabHeight - viewRect.y;
                                break;
                            }
                            default: {
                                int totalTabWidth = SynthBasicTabbedUI.this.rects[tabCount - 1].x + SynthBasicTabbedUI.this.rects[tabCount - 1].width;
                                if (totalTabWidth <= tw) break;
                                int n = vw = tw > 2 * butSize.width ? tw - 2 * butSize.width : 0;
                                if (totalTabWidth - viewRect.x > vw) break;
                                vw = totalTabWidth - viewRect.x;
                            }
                        }
                        child.setBounds(tx, ty, vw, vh);
                    } else if (SynthBasicTabbedUI.this.tabScroller != null && (child == ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollForwardButton || child == ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollBackwardButton)) {
                        Component scrollbutton = child;
                        Dimension bsize = scrollbutton.getPreferredSize();
                        int bx = 0;
                        int by = 0;
                        int bw = bsize.width;
                        int bh = bsize.height;
                        boolean visible = false;
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight = SynthBasicTabbedUI.this.rects[tabCount - 1].y + SynthBasicTabbedUI.this.rects[tabCount - 1].height;
                                if (totalTabHeight <= th) break;
                                visible = true;
                                bx = tabPlacement == 2 ? tx + tw - bsize.width : tx;
                                by = child == ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollForwardButton ? bounds.height - insets.bottom - bsize.height : bounds.height - insets.bottom - 2 * bsize.height;
                                break;
                            }
                            default: {
                                int totalTabWidth = SynthBasicTabbedUI.this.rects[tabCount - 1].x + SynthBasicTabbedUI.this.rects[tabCount - 1].width;
                                if (totalTabWidth <= tw) break;
                                visible = true;
                                bx = child == ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.scrollForwardButton ? bounds.width - insets.left - bsize.width : bounds.width - insets.left - 2 * bsize.width;
                                by = tabPlacement == 1 ? ty + th - bsize.height : ty;
                            }
                        }
                        child.setVisible(visible);
                        if (visible) {
                            child.setBounds(bx, by, bw, bh);
                        }
                    } else {
                        child.setBounds(cx, cy, cw, ch);
                    }
                    ++i;
                }
                ((TabbedPaneLayout)this).layoutTabComponents();
                this.layoutCroppedEdge();
                if (shouldChangeFocus && !SynthBasicTabbedUI.this.requestFocusForVisibleComponent()) {
                    SynthBasicTabbedUI.this.tabPane.requestFocus();
                }
            }
        }

        private void layoutCroppedEdge() {
            ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.croppedEdge.resetParams();
            Rectangle viewRect = ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.viewport.getViewRect();
            int i = 0;
            while (i < SynthBasicTabbedUI.this.rects.length) {
                Rectangle tabRect = SynthBasicTabbedUI.this.rects[i];
                switch (SynthBasicTabbedUI.this.tabPane.getTabPlacement()) {
                    case 2: 
                    case 4: {
                        int cropline = viewRect.y + viewRect.height;
                        if (tabRect.y >= cropline || tabRect.y + tabRect.height <= cropline) break;
                        ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.croppedEdge.setParams(i, cropline - tabRect.y - 1, -((SynthBasicTabbedUI)SynthBasicTabbedUI.this).currentTabAreaInsets.left, 0);
                        break;
                    }
                    default: {
                        int cropline = viewRect.x + viewRect.width;
                        if (tabRect.x >= cropline - 1 || tabRect.x + tabRect.width <= cropline) break;
                        ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.croppedEdge.setParams(i, cropline - tabRect.x - 1, 0, -((SynthBasicTabbedUI)SynthBasicTabbedUI.this).currentTabAreaInsets.top);
                    }
                }
                ++i;
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics metrics = SynthBasicTabbedUI.this.getFontMetrics();
            Dimension size = SynthBasicTabbedUI.this.tabPane.getSize();
            Insets insets = SynthBasicTabbedUI.this.tabPane.getInsets();
            Insets tabAreaInsets = SynthBasicTabbedUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = SynthBasicTabbedUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = SynthBasicTabbedUI.isLeftToRight(SynthBasicTabbedUI.this.tabPane);
            int x = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            int totalWidth = 0;
            int totalHeight = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    SynthBasicTabbedUI.this.maxTabWidth = SynthBasicTabbedUI.this.calculateMaxTabWidth(tabPlacement);
                    break;
                }
                default: {
                    SynthBasicTabbedUI.this.maxTabHeight = SynthBasicTabbedUI.this.calculateMaxTabHeight(tabPlacement);
                }
            }
            SynthBasicTabbedUI.this.runCount = 0;
            SynthBasicTabbedUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            SynthBasicTabbedUI.this.selectedRun = 0;
            SynthBasicTabbedUI.this.runCount = 1;
            int i = 0;
            while (i < tabCount) {
                Rectangle rect = SynthBasicTabbedUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = SynthBasicTabbedUI.this.rects[i - 1].x + SynthBasicTabbedUI.this.rects[i - 1].width;
                    } else {
                        SynthBasicTabbedUI.this.tabRuns[0] = 0;
                        SynthBasicTabbedUI.this.maxTabWidth = 0;
                        totalHeight += SynthBasicTabbedUI.this.maxTabHeight;
                        rect.x = x;
                    }
                    rect.width = SynthBasicTabbedUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    totalWidth = rect.x + rect.width;
                    SynthBasicTabbedUI.this.maxTabWidth = Math.max(SynthBasicTabbedUI.this.maxTabWidth, rect.width);
                    rect.y = y;
                    rect.height = SynthBasicTabbedUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = SynthBasicTabbedUI.this.rects[i - 1].y + SynthBasicTabbedUI.this.rects[i - 1].height;
                    } else {
                        SynthBasicTabbedUI.this.tabRuns[0] = 0;
                        SynthBasicTabbedUI.this.maxTabHeight = 0;
                        totalWidth = SynthBasicTabbedUI.this.maxTabWidth;
                        rect.y = y;
                    }
                    rect.height = SynthBasicTabbedUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    totalHeight = rect.y + rect.height;
                    SynthBasicTabbedUI.this.maxTabHeight = Math.max(SynthBasicTabbedUI.this.maxTabHeight, rect.height);
                    rect.x = x;
                    rect.width = SynthBasicTabbedUI.this.maxTabWidth;
                }
                ++i;
            }
            if (SynthBasicTabbedUI.this.tabsOverlapBorder) {
                this.padSelectedTab(tabPlacement, selectedIndex);
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                i = 0;
                while (i < tabCount) {
                    SynthBasicTabbedUI.this.rects[i].x = rightMargin - SynthBasicTabbedUI.this.rects[i].x - SynthBasicTabbedUI.this.rects[i].width;
                    ++i;
                }
            }
            ((SynthBasicTabbedUI)SynthBasicTabbedUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
        }
    }
}

