/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.RayoSwingScoutHeaderPanel;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoToolTabsBar;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.ToolsViewController;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.OptimisticLock;

public class ToolsViewAndTabsBarSynchronizer {
    private final ToolsViewController m_toolsViewController;
    private final RayoSwingScoutHeaderPanel m_swingScoutHeaderPanel;
    private final OptimisticLock m_syncLock = new OptimisticLock();

    public ToolsViewAndTabsBarSynchronizer(ToolsViewController toolsViewController, RayoSwingScoutHeaderPanel swingScoutHeaderPanel) {
        this.m_toolsViewController = toolsViewController;
        this.m_swingScoutHeaderPanel = swingScoutHeaderPanel;
        this.m_swingScoutHeaderPanel.adjustToolButtonPanelWidth((int)swingScoutHeaderPanel.getSwingToolTabsPanel().getPreferredSize().getWidth(), true);
        this.installListeners();
    }

    protected void reset() {
    }

    private void installListeners() {
        RayoToolTabsBar toolTabs = this.m_swingScoutHeaderPanel.getSwingToolTabsPanel();
        toolTabs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    ToolsViewAndTabsBarSynchronizer.this.m_syncLock.acquire();
                    if ("collapsed".equals(evt.getPropertyName())) {
                        boolean collapsed = (Boolean)evt.getNewValue();
                        if (collapsed) {
                            ToolsViewAndTabsBarSynchronizer.this.m_toolsViewController.collapseView();
                        } else {
                            ToolsViewAndTabsBarSynchronizer.this.m_toolsViewController.expandView();
                        }
                    } else if ("minimumSize".equals(evt.getPropertyName())) {
                        Dimension d = (Dimension)evt.getNewValue();
                        ToolsViewAndTabsBarSynchronizer.this.m_toolsViewController.setMinimumWidth(d.width);
                    }
                }
                finally {
                    ToolsViewAndTabsBarSynchronizer.this.m_syncLock.release();
                }
            }
        });
        this.m_toolsViewController.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                try {
                    if (ToolsViewAndTabsBarSynchronizer.this.m_syncLock.acquire()) {
                        ToolsViewAndTabsBarSynchronizer.this.m_swingScoutHeaderPanel.adjustToolButtonPanelWidth(ToolsViewAndTabsBarSynchronizer.this.m_toolsViewController.getWidth(), false);
                    }
                }
                finally {
                    ToolsViewAndTabsBarSynchronizer.this.m_syncLock.release();
                }
            }
        });
    }
}

