/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.form.fields.datefield;

import com.bsiag.scout.rt.ui.swing.rayo.ext.RayoTextFieldWithDecorationIcons;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.decoration.IDecoration;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.datefield.SwingScoutTimeField;

public class RayoSwingScoutTimeField
extends SwingScoutTimeField {
    private IconGroup m_notOverlapIconGroup;
    private IconGroup m_overlapIconGroup;

    protected JTextFieldWithDecorationIcons createTimeField(JComponent container) {
        this.m_notOverlapIconGroup = new IconGroup(this.getSwingEnvironment(), "datefield_time");
        this.m_overlapIconGroup = new IconGroup(this.getSwingEnvironment(), "datefield_time");
        this.m_overlapIconGroup.setIcon(IconGroup.IconState.NORMAL, this.getSwingEnvironment().getIcon("datefield_time_disabled"));
        RayoTextFieldWithDecorationIcons textField = new RayoTextFieldWithDecorationIcons(true);
        this.initializeTimeField(textField);
        container.add((Component)((Object)textField));
        return textField;
    }

    protected void initializeTimeField(JTextFieldWithDecorationIcons textField) {
        super.initializeTimeField(textField);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                RayoSwingScoutTimeField.this.updateTextOverlappingIcon();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RayoSwingScoutTimeField.this.updateTextOverlappingIcon();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RayoSwingScoutTimeField.this.updateTextOverlappingIcon();
            }
        });
        textField.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RayoSwingScoutTimeField.this.updateTextOverlappingIcon();
            }
        });
    }

    private void updateTextOverlappingIcon() {
        int customInsetsRigth;
        int insetsLeft;
        IDecoration decorationIcon;
        int iconWidth;
        int fieldWidth;
        int textWidth = this.calcTextWidth();
        if (textWidth > (fieldWidth = this.getSwingTimeField().getSize().width) - (iconWidth = (decorationIcon = this.getSwingTimeField().getDecorationIcon()).getWidth()) - (insetsLeft = this.getSwingTimeField().getInsets().left) - (customInsetsRigth = this.getSwingTimeField().getInsets().right)) {
            this.getDropdownIcon().setIconGroup(this.m_overlapIconGroup);
        } else {
            this.getDropdownIcon().setIconGroup(this.m_notOverlapIconGroup);
        }
    }

    private int calcTextWidth() {
        String text = this.getSwingTimeField().getText();
        Font f = this.getSwingTimeField().getFont();
        FontMetrics fm = this.getSwingTimeField().getFontMetrics(f);
        Rectangle2D bounds = fm.getStringBounds(text, this.getSwingTimeField().getGraphics());
        return (int)bounds.getWidth();
    }
}

