/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

import javax.swing.Icon;
import javax.swing.JComponent;

import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup.IconState;

public class RayoForwardButton extends RayoNavigationWidgetButton {

  private Point m_historyIconPosition;

  private boolean m_historyEnabled = false;

  public RayoForwardButton(JComponent parent, Point historyIconPosition, boolean historyEnabled) {
    super(ButtonName.FORWARD, parent);
    m_historyIconPosition = historyIconPosition;
    m_historyEnabled = historyEnabled;
  }

  public boolean isHistoryEnabled() {
    return m_historyEnabled;
  }

  public void setHistoryEnabled(boolean historyEnabled) {
    m_historyEnabled = historyEnabled;
  }

  @Override
  protected Icon getSecondaryIconForCurrentState() {
    IconGroup iconGroup = getIconGroup(ActionType.SecondaryAction);
    Icon icon = iconGroup.getIcon(IconState.NORMAL);
    if (!isHistoryEnabled() && iconGroup.hasIcon(IconState.DISABLED)) {
      icon = iconGroup.getIcon(IconState.DISABLED);
    }
    else if (isMouseOver() && iconGroup.hasIcon(IconState.ROLLOVER)) {
      icon = iconGroup.getIcon(IconState.ROLLOVER);
    }
    return icon;
  }

  @Override
  protected void paintIcon(Component c, Graphics g) {
    super.paintIcon(c, g);
    paintPressedImage(getSecondaryIconForCurrentState(), m_historyIconPosition, isPressed(), c, g);
  }

  @Override
  public void buttonClicked(int button) {
    switch (button) {
      case MouseEvent.BUTTON1:
        performAction(getPrimaryAction());
        break;
      case MouseEvent.BUTTON3:
        if (isHistoryEnabled()) {
          performAction(getSecondaryAction());
        }
        break;
      default:
    }
  }
}
