/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.RayoColumnSplitStrategy;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.eclipse.scout.commons.NumberUtility;

public class ToolsViewController {
    private JDesktopPane m_swingDesktop;
    private RayoColumnSplitStrategy m_columnSplitStrategy;
    private final Collection<ComponentListener> m_listeners = new ArrayList<ComponentListener>();
    private final ArrayList<JInternalFrame> m_frames = new ArrayList();
    private final P_FrameListener m_frameListener = new P_FrameListener();
    private int m_minWidth;
    private int m_oldWidth;

    public ToolsViewController(JDesktopPane swingDesktop, RayoColumnSplitStrategy columnSplitStrategy) {
        this.m_swingDesktop = swingDesktop;
        this.m_columnSplitStrategy = columnSplitStrategy;
        this.m_minWidth = this.ensureMinWidth(0);
    }

    private void fireComponentResized(ComponentEvent e) {
        int newWidth = this.getWidth();
        if (this.m_oldWidth != newWidth) {
            this.m_oldWidth = newWidth;
            for (ComponentListener l : this.m_listeners) {
                l.componentResized(e);
            }
        }
    }

    public void addComponentListener(ComponentListener l) {
        this.m_listeners.add(l);
    }

    public void removeComponentListener(ComponentListener l) {
        this.m_listeners.remove(l);
    }

    public int getWidth() {
        if (this.m_frames.size() > 0) {
            return this.ensureMinWidth(this.m_frames.get(this.m_frames.size() - 1).getWidth());
        }
        return 0;
    }

    public void addFrame(JInternalFrame frame) {
        this.m_frames.add(frame);
        frame.addComponentListener(this.m_frameListener);
        frame.addInternalFrameListener(this.m_frameListener);
    }

    public void removeFrame(JInternalFrame frame) {
        if (this.m_frames.contains(frame)) {
            this.m_frames.remove(frame);
            frame.removeComponentListener(this.m_frameListener);
            frame.removeInternalFrameListener(this.m_frameListener);
        }
    }

    public void setMinimumWidth(int minWidth) {
        this.m_minWidth = this.ensureMinWidth(minWidth);
        this.m_columnSplitStrategy.setToolsViewMinWidth(this.m_minWidth);
        this.m_swingDesktop.revalidate();
        this.m_swingDesktop.repaint();
    }

    public void expandView() {
        if (this.m_minWidth > 0) {
            this.m_columnSplitStrategy.setToolsViewWidth(this.m_minWidth);
        }
        this.m_swingDesktop.revalidate();
        this.m_swingDesktop.repaint();
    }

    public void collapseView() {
        this.m_swingDesktop.revalidate();
        this.m_swingDesktop.repaint();
    }

    private int ensureMinWidth(int width) {
        return (int)NumberUtility.max((double[])new double[]{UIManager.getInt("Synth.ToolButtonView.minWidth"), this.m_minWidth, width});
    }

    private class P_FrameListener
    extends InternalFrameAdapter
    implements ComponentListener {
        private P_FrameListener() {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
            if (e.getInternalFrame().isVisible()) {
                ToolsViewController.this.fireComponentResized(new ComponentEvent(e.getInternalFrame(), 101));
            }
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            ToolsViewController.this.removeFrame(e.getInternalFrame());
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getComponent().isVisible()) {
                ToolsViewController.this.fireComponentResized(e);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (e.getComponent().isVisible()) {
                ToolsViewController.this.fireComponentResized(e);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (e.getComponent().isVisible()) {
                ToolsViewController.this.fireComponentResized(e);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

