/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.ext;

import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

import org.eclipse.scout.rt.ui.swing.ext.JTextFieldWithTransparentIcon;

/**
 * This widget may be used instead of the JTextFieldWithDropDownButton when you have not enough space to display
 * text and icon, which is the case for date from/to fields where you have very limited space for displaying the date
 * text (i.e. "21.12.2010") and the date icon on the right. {@link RayoTextFieldWithTransparentIcon} solves this problem
 * as it allows the text to overlay the icon. Whenever this
 * happens,
 * the icon becomes transparent for better readability.
 */
public class RayoTextFieldWithTransparentIcon extends JTextFieldWithTransparentIcon {

  private static final long serialVersionUID = 1L;

  public RayoTextFieldWithTransparentIcon() {
    putClientProperty("onBackgroundPainter", new P_OnBackgroundPainter());
    setInsetsRight(3);
  }

  @Override
  protected void postPaintComponent(Graphics g) {
    // nop
  }

  /**
   * This is more or less a hack used to to draw the text of a JTextField over the icon of the
   * widget.
   * This hack is required because SynthTextFieldUI of the Synth L/F paints the background of a text-field and the text
   * of the JTextField in one step, so it is not possible to draw something "between" text and background (for instance
   * our icon).
   * The modified BSI Rayo L/F checks if the client property "onBackgroundPainter" is set, and then calls the
   * paintIcon() method between the two calls to paint the background and the text.
   */
  private class P_OnBackgroundPainter implements Icon {

    @Override
    public int getIconHeight() {
      return 0;
    }

    @Override
    public int getIconWidth() {
      return 0;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
      Icon icon = getIconForCurrentState();
      if (icon != null) {
        x = getWidth() - icon.getIconWidth() - getInsetsRight();
        y = (getHeight() - icon.getIconHeight()) / 2;
        icon.paintIcon(c, g, x, y);
      }
    }
  }
}
