/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.sun.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.ColorType;
import com.bsiag.javax.swing.plaf.synth.Region;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthGraphicsUtils;
import com.bsiag.javax.swing.plaf.synth.SynthPainter;
import com.bsiag.javax.swing.plaf.synth.SynthStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;

public class DefaultSynthStyle
extends SynthStyle
implements Cloneable {
    private static final Object PENDING = new String("Pending");
    private boolean opaque;
    private Insets insets;
    private StateInfo[] states;
    private Map data;
    private Font font;
    private SynthGraphicsUtils synthGraphics;
    private SynthPainter painter;

    public DefaultSynthStyle() {
    }

    public DefaultSynthStyle(DefaultSynthStyle style) {
        this.opaque = style.opaque;
        if (style.insets != null) {
            this.insets = new Insets(style.insets.top, style.insets.left, style.insets.bottom, style.insets.right);
        }
        if (style.states != null) {
            this.states = new StateInfo[style.states.length];
            int counter = style.states.length - 1;
            while (counter >= 0) {
                this.states[counter] = (StateInfo)style.states[counter].clone();
                --counter;
            }
        }
        if (style.data != null) {
            this.data = new HashMap();
            this.data.putAll(style.data);
        }
        this.font = style.font;
        this.synthGraphics = style.synthGraphics;
        this.painter = style.painter;
    }

    public DefaultSynthStyle(Insets insets, boolean opaque, StateInfo[] states, Map data) {
        this.insets = insets;
        this.opaque = opaque;
        this.states = states;
        this.data = data;
    }

    @Override
    public Color getColor(SynthContext context, ColorType type) {
        return this.getColor(context.getComponent(), context.getRegion(), context.getComponentState(), type);
    }

    public Color getColor(JComponent c, Region id, int state, ColorType type) {
        Color color;
        if (!id.isSubregion() && (state & 1) != 0) {
            if (type == ColorType.BACKGROUND) {
                return c.getBackground();
            }
            if (type == ColorType.FOREGROUND) {
                return c.getForeground();
            }
            if (type == ColorType.TEXT_FOREGROUND && !((color = c.getForeground()) instanceof UIResource)) {
                return color;
            }
        }
        if ((color = this.getColorForState(c, id, state, type)) == null) {
            if (type == ColorType.BACKGROUND || type == ColorType.TEXT_BACKGROUND) {
                return c.getBackground();
            }
            if (type == ColorType.FOREGROUND || type == ColorType.TEXT_FOREGROUND) {
                return c.getForeground();
            }
        }
        return color;
    }

    @Override
    protected Color getColorForState(SynthContext context, ColorType type) {
        return this.getColorForState(context.getComponent(), context.getRegion(), context.getComponentState(), type);
    }

    protected Color getColorForState(JComponent c, Region id, int state, ColorType type) {
        Color color;
        StateInfo si = this.getStateInfo(state);
        if (si != null && (color = si.getColor(type)) != null) {
            return color;
        }
        if ((si == null || si.getComponentState() != 0) && (si = this.getStateInfo(0)) != null) {
            return si.getColor(type);
        }
        return null;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public Font getFont(SynthContext state) {
        return this.getFont(state.getComponent(), state.getRegion(), state.getComponentState());
    }

    public Font getFont(JComponent c, Region id, int state) {
        if (!id.isSubregion() && state == 1) {
            return c.getFont();
        }
        Font cFont = c.getFont();
        if (cFont != null && !(cFont instanceof UIResource)) {
            return cFont;
        }
        return this.getFontForState(c, id, state);
    }

    protected Font getFontForState(JComponent c, Region id, int state) {
        Font font;
        if (c == null) {
            return this.font;
        }
        StateInfo si = this.getStateInfo(state);
        if (si != null && (font = si.getFont()) != null) {
            return font;
        }
        if ((si == null || si.getComponentState() != 0) && (si = this.getStateInfo(0)) != null && (font = si.getFont()) != null) {
            return font;
        }
        return this.font;
    }

    @Override
    protected Font getFontForState(SynthContext context) {
        return this.getFontForState(context.getComponent(), context.getRegion(), context.getComponentState());
    }

    public void setGraphicsUtils(SynthGraphicsUtils graphics) {
        this.synthGraphics = graphics;
    }

    @Override
    public SynthGraphicsUtils getGraphicsUtils(SynthContext context) {
        if (this.synthGraphics == null) {
            return super.getGraphicsUtils(context);
        }
        return this.synthGraphics;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public Insets getInsets(SynthContext state, Insets to) {
        if (to == null) {
            to = new Insets(0, 0, 0, 0);
        }
        if (this.insets != null) {
            to.left = this.insets.left;
            to.right = this.insets.right;
            to.top = this.insets.top;
            to.bottom = this.insets.bottom;
        } else {
            to.bottom = 0;
            to.top = 0;
            to.right = 0;
            to.left = 0;
        }
        return to;
    }

    public void setPainter(SynthPainter painter) {
        this.painter = painter;
    }

    @Override
    public SynthPainter getPainter(SynthContext ss) {
        return this.painter;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    @Override
    public boolean isOpaque(SynthContext ss) {
        return this.opaque;
    }

    public void setData(Map data) {
        this.data = data;
    }

    public Map getData() {
        return this.data;
    }

    @Override
    public Object get(SynthContext state, Object key) {
        StateInfo si = this.getStateInfo(state.getComponentState());
        if (si != null && si.getData() != null && this.getKeyFromData(si.getData(), key) != null) {
            return this.getKeyFromData(si.getData(), key);
        }
        si = this.getStateInfo(0);
        if (si != null && si.getData() != null && this.getKeyFromData(si.getData(), key) != null) {
            return this.getKeyFromData(si.getData(), key);
        }
        if (this.getKeyFromData(this.data, key) != null) {
            return this.getKeyFromData(this.data, key);
        }
        return this.getDefaultValue(state, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object getKeyFromData(Map stateData, Object key) {
        block16: {
            value = null;
            if (stateData == null) break block16;
            var4_4 = stateData;
            synchronized (var4_4) {
                value = stateData.get(key);
                // MONITOREXIT @DISABLED, blocks:[0, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var4_4
                if (true) ** GOTO lbl24
            }
            do {
                var4_4 = stateData;
                synchronized (var4_4) {
                    try {
                        stateData.wait();
                    }
                    catch (InterruptedException var5_5) {
                        // empty catch block
                    }
                    value = stateData.get(key);
                }
lbl24:
                // 2 sources

            } while (value == DefaultSynthStyle.PENDING);
            if (value instanceof UIDefaults.LazyValue) {
                var4_4 = stateData;
                synchronized (var4_4) {
                    stateData.put(key, DefaultSynthStyle.PENDING);
                }
                value = ((UIDefaults.LazyValue)value).createValue(null);
                var4_4 = stateData;
                synchronized (var4_4) {
                    stateData.put(key, value);
                    stateData.notifyAll();
                }
            }
        }
        return value;
    }

    public Object getDefaultValue(SynthContext context, Object key) {
        return super.get(context, key);
    }

    public Object clone() {
        DefaultSynthStyle style;
        try {
            style = (DefaultSynthStyle)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
        if (this.states != null) {
            style.states = new StateInfo[this.states.length];
            int counter = this.states.length - 1;
            while (counter >= 0) {
                style.states[counter] = (StateInfo)this.states[counter].clone();
                --counter;
            }
        }
        if (this.data != null) {
            style.data = new HashMap();
            style.data.putAll(this.data);
        }
        return style;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle style) {
        if (this.insets != null) {
            style.insets = this.insets;
        }
        if (this.font != null) {
            style.font = this.font;
        }
        if (this.painter != null) {
            style.painter = this.painter;
        }
        if (this.synthGraphics != null) {
            style.synthGraphics = this.synthGraphics;
        }
        style.opaque = this.opaque;
        if (this.states != null) {
            if (style.states == null) {
                style.states = new StateInfo[this.states.length];
                int counter = this.states.length - 1;
                while (counter >= 0) {
                    if (this.states[counter] != null) {
                        style.states[counter] = (StateInfo)this.states[counter].clone();
                    }
                    --counter;
                }
            } else {
                int unique = 0;
                int matchCount = 0;
                int maxOStyles = style.states.length;
                int thisCounter = this.states.length - 1;
                while (thisCounter >= 0) {
                    int state = this.states[thisCounter].getComponentState();
                    boolean found = false;
                    int oCounter = maxOStyles - 1 - matchCount;
                    while (oCounter >= 0) {
                        if (state == style.states[oCounter].getComponentState()) {
                            style.states[oCounter] = this.states[thisCounter].addTo(style.states[oCounter]);
                            StateInfo tmp = style.states[maxOStyles - 1 - matchCount];
                            style.states[maxOStyles - 1 - matchCount] = style.states[oCounter];
                            style.states[oCounter] = tmp;
                            ++matchCount;
                            found = true;
                            break;
                        }
                        --oCounter;
                    }
                    if (!found) {
                        ++unique;
                    }
                    --thisCounter;
                }
                if (unique != 0) {
                    StateInfo[] newStates = new StateInfo[unique + maxOStyles];
                    int newIndex = maxOStyles;
                    System.arraycopy(style.states, 0, newStates, 0, maxOStyles);
                    int thisCounter2 = this.states.length - 1;
                    while (thisCounter2 >= 0) {
                        int state = this.states[thisCounter2].getComponentState();
                        boolean found = false;
                        int oCounter = maxOStyles - 1;
                        while (oCounter >= 0) {
                            if (state == style.states[oCounter].getComponentState()) {
                                found = true;
                                break;
                            }
                            --oCounter;
                        }
                        if (!found) {
                            newStates[newIndex++] = (StateInfo)this.states[thisCounter2].clone();
                        }
                        --thisCounter2;
                    }
                    style.states = newStates;
                }
            }
        }
        if (this.data != null) {
            if (style.data == null) {
                style.data = new HashMap();
            }
            style.data.putAll(this.data);
        }
        return style;
    }

    public void setStateInfo(StateInfo[] states) {
        this.states = states;
    }

    public StateInfo[] getStateInfo() {
        return this.states;
    }

    public StateInfo getStateInfo(int state) {
        if (this.states != null) {
            int bestCount = 0;
            int bestIndex = -1;
            int wildIndex = -1;
            if (state == 0) {
                int counter = this.states.length - 1;
                while (counter >= 0) {
                    if (this.states[counter].getComponentState() == 0) {
                        return this.states[counter];
                    }
                    --counter;
                }
                return null;
            }
            int counter = this.states.length - 1;
            while (counter >= 0) {
                int oState = this.states[counter].getComponentState();
                if (oState == 0) {
                    if (wildIndex == -1) {
                        wildIndex = counter;
                    }
                } else if ((state & oState) == oState) {
                    int bitCount = oState;
                    bitCount -= (0xAAAAAAAA & bitCount) >>> 1;
                    bitCount = (bitCount & 0x33333333) + (bitCount >>> 2 & 0x33333333);
                    bitCount = bitCount + (bitCount >>> 4) & 0xF0F0F0F;
                    bitCount += bitCount >>> 8;
                    bitCount += bitCount >>> 16;
                    if ((bitCount &= 0xFF) > bestCount) {
                        bestIndex = counter;
                        bestCount = bitCount;
                    }
                }
                --counter;
            }
            if (bestIndex != -1) {
                return this.states[bestIndex];
            }
            if (wildIndex != -1) {
                return this.states[wildIndex];
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString()).append(',');
        buf.append("data=").append(this.data).append(',');
        buf.append("font=").append(this.font).append(',');
        buf.append("insets=").append(this.insets).append(',');
        buf.append("synthGraphics=").append(this.synthGraphics).append(',');
        buf.append("painter=").append(this.painter).append(',');
        StateInfo[] states = this.getStateInfo();
        if (states != null) {
            buf.append("states[");
            int i = 0;
            while (i < states.length) {
                buf.append(states[i].toString()).append(',');
                ++i;
            }
            buf.append(']').append(',');
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    public static class StateInfo {
        private Map data;
        private Font font;
        private Color[] colors;
        private int state;

        public StateInfo() {
        }

        public StateInfo(int state, Font font, Color[] colors) {
            this.state = state;
            this.font = font;
            this.colors = colors;
        }

        public StateInfo(StateInfo info) {
            this.state = info.state;
            this.font = info.font;
            if (info.data != null) {
                if (this.data == null) {
                    this.data = new HashMap();
                }
                this.data.putAll(info.data);
            }
            if (info.colors != null) {
                this.colors = new Color[info.colors.length];
                System.arraycopy(info.colors, 0, this.colors, 0, info.colors.length);
            }
        }

        public Map getData() {
            return this.data;
        }

        public void setData(Map data) {
            this.data = data;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public void setColors(Color[] colors) {
            this.colors = colors;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public Color getColor(ColorType type) {
            int id;
            if (this.colors != null && (id = type.getID()) < this.colors.length) {
                return this.colors[id];
            }
            return null;
        }

        public StateInfo addTo(StateInfo info) {
            if (this.font != null) {
                info.font = this.font;
            }
            if (this.data != null) {
                if (info.data == null) {
                    info.data = new HashMap();
                }
                info.data.putAll(this.data);
            }
            if (this.colors != null) {
                if (info.colors == null) {
                    info.colors = new Color[this.colors.length];
                    System.arraycopy(this.colors, 0, info.colors, 0, this.colors.length);
                } else {
                    if (info.colors.length < this.colors.length) {
                        Color[] old = info.colors;
                        info.colors = new Color[this.colors.length];
                        System.arraycopy(old, 0, info.colors, 0, old.length);
                    }
                    int counter = this.colors.length - 1;
                    while (counter >= 0) {
                        if (this.colors[counter] != null) {
                            info.colors[counter] = this.colors[counter];
                        }
                        --counter;
                    }
                }
            }
            return info;
        }

        public void setComponentState(int state) {
            this.state = state;
        }

        public int getComponentState() {
            return this.state;
        }

        private final int getMatchCount(int val) {
            val &= this.state;
            val -= (0xAAAAAAAA & val) >>> 1;
            val = (val & 0x33333333) + (val >>> 2 & 0x33333333);
            val = val + (val >>> 4) & 0xF0F0F0F;
            val += val >>> 8;
            val += val >>> 16;
            return val & 0xFF;
        }

        public Object clone() {
            return new StateInfo(this);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString()).append(',');
            buf.append("state=").append(Integer.toString(this.state)).append(',');
            buf.append("font=").append(this.font).append(',');
            if (this.colors != null) {
                buf.append("colors=").append(Arrays.asList(this.colors)).append(',');
            }
            return buf.toString();
        }
    }
}

