/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.Region;
import com.bsiag.javax.swing.plaf.synth.SynthArrowButton;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.javax.swing.plaf.synth.SynthStyle;
import com.bsiag.sun.swing.plaf.synth.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

class SynthSpinnerUI
extends BasicSpinnerUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private EditorFocusHandler editorFocusHandler = new EditorFocusHandler();

    SynthSpinnerUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthSpinnerUI();
    }

    @Override
    protected void installListeners() {
        JFormattedTextField tf;
        super.installListeners();
        this.spinner.addPropertyChangeListener(this);
        JComponent editor = this.spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            tf.addFocusListener(this.editorFocusHandler);
        }
    }

    @Override
    protected void uninstallListeners() {
        JFormattedTextField tf;
        super.uninstallListeners();
        this.spinner.removePropertyChangeListener(this);
        JComponent editor = this.spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            tf.removeFocusListener(this.editorFocusHandler);
        }
    }

    @Override
    protected void installDefaults() {
        LayoutManager layout = this.spinner.getLayout();
        if (layout == null || layout instanceof UIResource) {
            this.spinner.setLayout(this.createLayout());
        }
        this.updateStyle(this.spinner);
    }

    private void updateStyle(JSpinner c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && oldStyle != null) {
            this.installKeyboardActions();
        }
        context.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        if (this.spinner.getLayout() instanceof UIResource) {
            this.spinner.setLayout(null);
        }
        SynthContext context = this.getContext(this.spinner, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    @Override
    protected Component createPreviousButton() {
        SynthArrowButton b = new SynthArrowButton(5);
        b.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(b);
        return b;
    }

    @Override
    protected Component createNextButton() {
        SynthArrowButton b = new SynthArrowButton(1);
        b.setName("Spinner.nextButton");
        this.installNextButtonListeners(b);
        return b;
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        editor.setName("Spinner.editor");
        this.updateEditorAlignment(editor);
        return editor;
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        JFormattedTextField tf;
        this.spinner.remove(oldEditor);
        this.updateEditorAlignment(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
        if (oldEditor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)oldEditor).getTextField()) != null) {
            tf.removeFocusListener(this.editorFocusHandler);
        }
        if (newEditor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)newEditor).getTextField()) != null) {
            tf.addFocusListener(this.editorFocusHandler);
        }
    }

    private void updateEditorAlignment(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            SynthContext context = this.getContext(this.spinner);
            Integer alignment = (Integer)context.getStyle().get(context, "Spinner.editorAlignment");
            JFormattedTextField text = ((JSpinner.DefaultEditor)editor).getTextField();
            if (alignment != null) {
                text.setHorizontalAlignment(alignment);
            }
            text.putClientProperty("JComponent.sizeVariant", this.spinner.getClientProperty("JComponent.sizeVariant"));
        }
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintSpinnerBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintSpinnerBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        JSpinner spinner = (JSpinner)e.getSource();
        SpinnerUI spinnerUI = spinner.getUI();
        if (spinnerUI instanceof SynthSpinnerUI) {
            SynthSpinnerUI ui = (SynthSpinnerUI)spinnerUI;
            if (SynthLookAndFeel.shouldUpdateStyle(e)) {
                ui.updateStyle(spinner);
            }
        }
    }

    private class EditorFocusHandler
    implements FocusListener {
        private EditorFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            SynthSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            SynthSpinnerUI.this.spinner.repaint();
        }
    }

    private class SpinnerArrowButton
    extends SynthArrowButton {
        public SpinnerArrowButton(int direction) {
            super(direction);
        }

        @Override
        public boolean isFocusOwner() {
            if (SynthSpinnerUI.this.spinner == null) {
                return super.isFocusOwner();
            }
            if (SynthSpinnerUI.this.spinner.getEditor() instanceof JSpinner.DefaultEditor) {
                return ((JSpinner.DefaultEditor)SynthSpinnerUI.this.spinner.getEditor()).getTextField().isFocusOwner();
            }
            if (SynthSpinnerUI.this.spinner.getEditor() != null) {
                return SynthSpinnerUI.this.spinner.getEditor().isFocusOwner();
            }
            return super.isFocusOwner();
        }
    }

    private static class SpinnerLayout
    implements LayoutManager,
    UIResource {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            if ("Next".equals(name)) {
                this.nextButton = c;
            } else if ("Previous".equals(name)) {
                this.previousButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            }
        }

        @Override
        public void removeLayoutComponent(Component c) {
            if (c == this.nextButton) {
                this.nextButton = null;
            } else if (c == this.previousButton) {
                this.previousButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? new Dimension(0, 0) : c.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            Dimension editorD = this.preferredSize(this.editor);
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorX;
            Insets insets = parent.getInsets();
            int availWidth = parent.getWidth() - (insets.left + insets.right);
            int availHeight = parent.getHeight() - (insets.top + insets.bottom);
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            int nextHeight = availHeight / 2;
            int previousHeight = availHeight - nextHeight;
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorWidth = availWidth - buttonsWidth;
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                buttonsX = editorX + editorWidth;
            } else {
                buttonsX = insets.left;
                editorX = buttonsX + buttonsWidth;
            }
            int previousY = insets.top + nextHeight;
            this.setBounds(this.editor, editorX, insets.top, editorWidth, availHeight);
            this.setBounds(this.nextButton, buttonsX, insets.top, buttonsWidth, nextHeight);
            this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }
}

