/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.JTabEx;

public class RayoViewTab
extends JTabEx {
    private static final long serialVersionUID = 1L;
    private static final Font FONT_DEFAULT = UIManager.getFont("Synth.ViewTab.font");
    private static final Font FONT_SELECTED = UIManager.getFont("Synth.ViewTab.fontSelected");
    private static final Color COLOR_DEFAULT = UIManager.getColor("Synth.ViewTab.foreground");
    private static final Color COLOR_SELECTED = UIManager.getColor("Synth.ViewTab.foregroundSelected");
    int[] normalFontSize;
    int[] activeFontSize;

    public RayoViewTab() {
        this.setName("Synth.ViewTab");
        this.setLayout((LayoutManager)((Object)new Layout()));
        this.normalFontSize = this.measureFont(FONT_DEFAULT);
        this.activeFontSize = this.measureFont(FONT_SELECTED);
    }

    public Dimension getMinimumSize() {
        return this.getLayout().minimumLayoutSize((Container)((Object)this));
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize((Container)((Object)this));
    }

    public Dimension getMaximumSize() {
        return ((LayoutManager2)this.getLayout()).maximumLayoutSize((Container)((Object)this));
    }

    int[] measureFont(Font font) {
        if (font == null) {
            font = this.getFont();
        }
        FontMetrics fm = this.getFontMetrics(font);
        int width = fm.stringWidth(this.getText());
        int height = fm.getHeight();
        int baseline = fm.getAscent();
        return new int[]{width, height, baseline};
    }

    protected void paintComponent(Graphics g) {
        int y;
        int x;
        Insets insets = this.getInsets();
        Icon icon = this.getIconForTabState();
        Insets iconInsets = new Insets(0, 0, 0, 0);
        if (icon != null) {
            iconInsets.left = icon.getIconWidth() + 2;
            icon.paintIcon((Component)((Object)this), g, insets.left, insets.top);
        }
        int centerTextOffset = 0;
        int normalWidth = this.normalFontSize[0];
        int activeWidth = this.activeFontSize[0];
        int yBaseline = insets.top + iconInsets.top + this.normalFontSize[2] + Math.max(0, (this.getHeight() - this.normalFontSize[1] - insets.top - insets.bottom - iconInsets.top - iconInsets.bottom) / 2);
        if (this.isSelected()) {
            g.setFont(FONT_SELECTED);
            g.setColor(COLOR_SELECTED);
        } else {
            g.setFont(FONT_DEFAULT);
            g.setColor(COLOR_DEFAULT);
            centerTextOffset = (activeWidth - normalWidth) / 2;
            if (this.isMouseOver()) {
                x = insets.left + iconInsets.left + centerTextOffset;
                y = yBaseline + 1;
                g.drawLine(x, y, x + normalWidth - 1, y);
            }
        }
        x = insets.left + iconInsets.left + centerTextOffset;
        y = yBaseline;
        g.drawString(this.getText(), x, y);
    }

    private Icon getIconForTabState() {
        Icon icon = null;
        if (!this.isEnabled()) {
            icon = this.getDisabledIcon();
        } else if (this.isSelected()) {
            icon = this.getSelectedIcon();
        } else if (this.isMouseOver()) {
            icon = this.getRolloverIcon();
        }
        if (icon == null) {
            icon = this.getIcon();
        }
        return icon;
    }

    private class Layout
    extends AbstractLayoutManager2 {
        private Dimension m_size;

        private Layout() {
        }

        protected void validateLayout(Container parent) {
            Insets insets;
            RayoViewTab.this.normalFontSize = RayoViewTab.this.measureFont(FONT_DEFAULT);
            RayoViewTab.this.activeFontSize = RayoViewTab.this.measureFont(FONT_SELECTED);
            int w = RayoViewTab.this.activeFontSize[0];
            int h = RayoViewTab.this.activeFontSize[1];
            Icon icon = RayoViewTab.this.getIconForTabState();
            if (icon != null) {
                w += icon.getIconWidth();
                w += 2;
                h = Math.max(h, icon.getIconHeight());
            }
            if ((insets = RayoViewTab.this.getInsets()) != null) {
                w += insets.left + insets.right;
                h += insets.top + insets.bottom;
            }
            this.m_size = new Dimension(w, h);
        }

        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            return this.m_size;
        }

        public void layoutContainer(Container parent) {
        }
    }
}

