/*
 * Copyright (c) 2011, BSI Business Systems Integration AG. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. BSI Business Systems Integration AG
 * designates this particular file as subject to the "Classpath" exception as provided
 * by BSI Business Systems Integration AG in the LICENSE_BSI file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact BSI Business Systems Integration AG, Taefernstrasse 16a,
 * CH-5405 Baden, Switzerland or visit www.bsiag.com if you need additional
 * information or have any questions.
 */
package com.bsiag.scout.rt.ui.swing.laf.rayo.tests;

import java.awt.Container;
import java.awt.FlowLayout;

import javax.swing.AbstractButton;
import javax.swing.JButton;

import org.eclipse.scout.rt.ui.swing.ext.JFrameEx;

import com.bsiag.scout.rt.ui.swing.laf.rayo.Rayo;

/**
 *
 */
public class TestButtonHeight {
  public static void main(String[] args) throws Exception {
    new Rayo().installLookAndFeel();
    JFrameEx f = new JFrameEx();
    Container contentPane = f.getContentPane();
    contentPane.setLayout(new FlowLayout());
    contentPane.add(newButton("Good", 'G'));
    contentPane.add(newButton("Morning", 'M'));
    contentPane.add(newButton("bsi", 'b'));
    f.pack();
    f.setLocation(300, 200);
    f.setVisible(true);
  }

  private static AbstractButton newButton(String text, char c) {
    JButton button = new JButton(text);
    button.setMnemonic(c);
    return button;
  }
}
