/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop;

import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.ui.swing.ext.JInternalFrameEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.SwingScoutDesktop;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.IMultiSplitStrategy;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.MultiSplitLayoutConstraints;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.ToolsViewController;

public class RayoSwingScoutDesktop extends SwingScoutDesktop {

  private ToolsViewController m_toolsViewController;
  private RayoColumnSplitStrategy m_columnSplitStrategy;

  @Override
  protected void initializeSwing() {
    m_columnSplitStrategy = new RayoColumnSplitStrategy(ClientUIPreferences.getInstance(getSwingEnvironment().getScoutSession()));
    super.initializeSwing();
    m_toolsViewController = new ToolsViewController(getSwingField(), m_columnSplitStrategy);
  }

  @Override
  protected IMultiSplitStrategy createMultiSplitStrategy() {
    // overwrite default split strategy to ensure width of tools view to be synchronized with tool button bar
    return m_columnSplitStrategy;
  }

  @Override
  public void addView(JInternalFrameEx f, Object constraints) {
    MultiSplitLayoutConstraints mc = (MultiSplitLayoutConstraints) constraints;
    if (mc.col == 2) {
      f.setName("Synth.ToolsView");
      m_toolsViewController.addFrame(f);
    }
    super.addView(f, constraints);
  }

  @Override
  public void removeView(JInternalFrameEx f) {
    m_toolsViewController.removeFrame(f);
    super.removeView(f);
  }

  public ToolsViewController getToolsViewController() {
    return m_toolsViewController;
  }
}
