/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.laf.rayo.painters;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.ext.LookAndFeelUtility;

public class TextFieldColors {
    Color foreground = UIManager.getColor("TextField.foreground");
    Color background = UIManager.getColor("TextField.background");
    Color border = UIManager.getColor("TextField.border");
    Color border3D = UIManager.getColor("TextField.border3D");
    Color borderTranslucent;
    private boolean compEnabled = false;
    private Color compForeground;
    private Color compBackground;

    public TextFieldColors(Color compForeground, Color compBackground, boolean compEnabled) {
        this.compForeground = compForeground;
        this.compBackground = compBackground;
        this.compEnabled = compEnabled;
        this.setColors();
    }

    private void setColors() {
        if (this.useDefaultForegroundColors()) {
            this.setDefaultForegroundColors();
        } else {
            this.setCustomForegroundColors();
        }
        if (this.useDefaultBackgroundColors()) {
            this.setDefaultBackgroundColors();
        } else {
            this.setCustomBackgroundColors();
        }
        this.borderTranslucent = LookAndFeelUtility.translucent((Color)this.border, (int)30);
    }

    boolean useDefaultForegroundColors() {
        return this.compForeground == null || this.compForeground instanceof UIResource;
    }

    boolean useDefaultBackgroundColors() {
        return this.compBackground == null || this.compBackground instanceof UIResource;
    }

    private void setCustomForegroundColors() {
        if (this.compForeground != null) {
            this.foreground = this.compForeground;
        }
    }

    private void setCustomBackgroundColors() {
        if (this.compBackground != null) {
            this.background = this.compBackground;
        }
        if (!this.compEnabled) {
            this.background = ColorUtility.lighter((Color)this.background, (float)0.7f);
        }
        if (this.compBackground != null) {
            this.border = ColorUtility.darker((Color)this.background, (float)0.2f);
            this.border3D = ColorUtility.darker((Color)this.background, (float)0.5f);
        }
    }

    private void setDefaultForegroundColors() {
    }

    private void setDefaultBackgroundColors() {
        if (!this.compEnabled) {
            this.background = UIManager.getColor("TextField.backgroundDisabled");
        }
    }

    public static TextFieldColors createFromComponent(Component comp) {
        boolean seemsEnabled = comp.isEnabled();
        if (comp instanceof JTextComponent) {
            JTextComponent jtc = (JTextComponent)comp;
            seemsEnabled &= jtc.isEditable();
        }
        return new TextFieldColors(comp.getForeground(), comp.getBackground(), seemsEnabled);
    }

    public static TextFieldColors createFromContainer(Container container) {
        if (container == null) {
            return null;
        }
        return new TextFieldColors(container.getForeground(), container.getBackground(), container.isEnabled());
    }

    public boolean requiresBorder3D() {
        return this.compEnabled;
    }
}

