/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.BasicRootPaneTitlePane;
import com.bsiag.javax.swing.plaf.synth.ColorType;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthGraphicsUtils;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.javax.swing.plaf.synth.SynthStyle;
import com.bsiag.sun.swing.plaf.synth.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class SynthRootPaneTitlePane
extends BasicRootPaneTitlePane
implements SynthUI,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private SynthStyle style;
    private int titleSpacing;
    private int buttonSpacing;
    private int titleAlignment;

    public SynthRootPaneTitlePane(JRootPane rootPane) {
        super(rootPane);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    public SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(this, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.maximizeIcon = this.style.getIcon(context, "InternalFrameTitlePane.maximizeIcon");
            this.minimizeIcon = this.style.getIcon(context, "InternalFrameTitlePane.minimizeIcon");
            this.iconifyIcon = this.style.getIcon(context, "InternalFrameTitlePane.iconifyIcon");
            this.closeIcon = this.style.getIcon(context, "InternalFrameTitlePane.closeIcon");
            this.maximizeIconRollOver = this.style.getIcon(context, "InternalFrameTitlePane.maximizeIconRollOver");
            this.minimizeIconRollOver = this.style.getIcon(context, "InternalFrameTitlePane.minimizeIconRollOver");
            this.iconifyIconRollOver = this.style.getIcon(context, "InternalFrameTitlePane.iconifyIconRollOver");
            this.closeIconRollOver = this.style.getIcon(context, "InternalFrameTitlePane.closeIconRollOver");
            this.titleSpacing = this.style.getInt(context, "InternalFrameTitlePane.titleSpacing", 2);
            this.buttonSpacing = this.style.getInt(context, "InternalFrameTitlePane.buttonSpacing", 2);
            String alignString = (String)this.style.get(context, "InternalFrameTitlePane.titleAlignment");
            this.titleAlignment = 10;
            if (alignString != null) {
                if ((alignString = alignString.toUpperCase()).equals("TRAILING")) {
                    this.titleAlignment = 11;
                } else if (alignString.equals("CENTER")) {
                    this.titleAlignment = 0;
                }
            }
            this.updateActionStyles();
        }
        context.dispose();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this);
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        SynthContext context = this.getContext(this);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintInternalFrameTitlePaneBackground(context, g, 0, 0, this.getWidth(), this.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        String title = this.getTitle();
        if (title != null) {
            int minX;
            int maxX;
            SynthStyle style = context.getStyle();
            g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
            g.setFont(style.getFont(context));
            FontMetrics fm = this.rootPane.getFontMetrics(g.getFont());
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            JButton lastButton = null;
            if (this.isFrameIconifiable()) {
                lastButton = this.iconifyButton;
            } else if (this.isFrameMaximizable()) {
                lastButton = this.toggleButton;
            } else if (this.isFrameClosable()) {
                lastButton = this.closeButton;
            }
            boolean ltr = true;
            int titleAlignment = this.titleAlignment;
            if (ltr) {
                maxX = lastButton != null ? lastButton.getX() - this.titleSpacing : this.rootPane.getWidth() - this.rootPane.getInsets().right - this.titleSpacing;
                minX = this.titleSpacing;
            } else {
                minX = lastButton != null ? lastButton.getX() + lastButton.getWidth() + this.titleSpacing : this.rootPane.getInsets().left + this.titleSpacing;
                maxX = 0 - this.titleSpacing;
                if (titleAlignment == 10) {
                    titleAlignment = 11;
                } else if (titleAlignment == 11) {
                    titleAlignment = 10;
                }
            }
            String clippedTitle = this.getTitle(title, fm, maxX - minX);
            if (clippedTitle == title) {
                if (titleAlignment == 11) {
                    minX = maxX - style.getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, title);
                } else if (titleAlignment == 0) {
                    int width = style.getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, title);
                    minX = Math.max(minX, (this.getWidth() - width) / 2);
                    minX = Math.min(maxX - width, minX);
                }
            }
            style.getGraphicsUtils(context).paintText(context, g, clippedTitle, minX, baseline - fm.getAscent(), -1);
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintInternalFrameTitlePaneBorder(context, g, x, y, w, h);
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
        this.iconifyButton.setBorder(handyEmptyBorder);
        this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
        this.toggleButton.setBorder(handyEmptyBorder);
    }

    @Override
    protected LayoutManager createLayout() {
        SynthContext context = this.getContext(this);
        LayoutManager lm = (LayoutManager)this.style.get(context, "InternalFrameTitlePane.titlePaneLayout");
        context.dispose();
        return lm != null ? lm : new SynthTitlePaneLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this && SynthLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle(this);
        }
    }

    class SynthTitlePaneLayout
    implements LayoutManager {
        SynthTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            Dimension pref;
            SynthContext context = SynthRootPaneTitlePane.this.getContext(SynthRootPaneTitlePane.this);
            int width = 0;
            int height = 0;
            int buttonCount = 0;
            if (SynthRootPaneTitlePane.this.isFrameClosable()) {
                pref = SynthRootPaneTitlePane.this.closeButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SynthRootPaneTitlePane.this.isFrameMaximizable()) {
                pref = SynthRootPaneTitlePane.this.toggleButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SynthRootPaneTitlePane.this.isFrameIconifiable()) {
                pref = SynthRootPaneTitlePane.this.iconifyButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            width += Math.max(0, (buttonCount - 1) * SynthRootPaneTitlePane.this.buttonSpacing);
            FontMetrics fm = SynthRootPaneTitlePane.this.getFontMetrics(SynthRootPaneTitlePane.this.getFont());
            SynthGraphicsUtils graphicsUtils = context.getStyle().getGraphicsUtils(context);
            String frameTitle = SynthRootPaneTitlePane.this.getTitle();
            int title_w = frameTitle != null ? graphicsUtils.computeStringWidth(context, fm.getFont(), fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = graphicsUtils.computeStringWidth(context, fm.getFont(), fm, String.valueOf(frameTitle.substring(0, 3)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            height = Math.max(fm.getHeight() + 2, height);
            width += SynthRootPaneTitlePane.this.titleSpacing + SynthRootPaneTitlePane.this.titleSpacing;
            Insets insets = SynthRootPaneTitlePane.this.getInsets();
            context.dispose();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }

        private int center(Component c, Insets insets, int x, boolean trailing) {
            Dimension pref = c.getPreferredSize();
            if (trailing) {
                x -= pref.width;
            }
            c.setBounds(x, insets.top + (SynthRootPaneTitlePane.this.getHeight() - insets.top - insets.bottom - pref.height) / 2, pref.width, pref.height);
            if (pref.width > 0) {
                if (trailing) {
                    return x - SynthRootPaneTitlePane.this.buttonSpacing;
                }
                return x + pref.width + SynthRootPaneTitlePane.this.buttonSpacing;
            }
            return x;
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insets = c.getInsets();
            boolean ltr = true;
            if (ltr) {
                int x = SynthRootPaneTitlePane.this.getWidth() - insets.right;
                if (SynthRootPaneTitlePane.this.isFrameClosable()) {
                    x = this.center(SynthRootPaneTitlePane.this.closeButton, insets, x, true);
                }
                if (SynthRootPaneTitlePane.this.isFrameMaximizable()) {
                    x = this.center(SynthRootPaneTitlePane.this.toggleButton, insets, x, true);
                }
                if (SynthRootPaneTitlePane.this.isFrameIconifiable()) {
                    x = this.center(SynthRootPaneTitlePane.this.iconifyButton, insets, x, true);
                }
            } else {
                int x = insets.left;
                if (SynthRootPaneTitlePane.this.isFrameClosable()) {
                    x = this.center(SynthRootPaneTitlePane.this.closeButton, insets, x, false);
                }
                if (SynthRootPaneTitlePane.this.isFrameMaximizable()) {
                    x = this.center(SynthRootPaneTitlePane.this.toggleButton, insets, x, false);
                }
                if (SynthRootPaneTitlePane.this.isFrameIconifiable()) {
                    x = this.center(SynthRootPaneTitlePane.this.iconifyButton, insets, x, false);
                }
            }
        }
    }
}

