/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoForwardButton;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoNavigationWidgetButton;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoStopRefreshButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressHandler;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJNavigationPanel;

public class RayoJNavigationPanel
extends AbstractJNavigationPanel {
    private static final long serialVersionUID = 1L;
    static final int INSET_TOP = 11;
    static final int INSET_LEFT = 9;
    private static final int SHADOW_DISTANCE = 2;
    private static final Dimension SIZE = new Dimension(120, 53);
    private static final Point HISTORY_MENU_LOCATION = new Point(47, 49);
    private RayoNavigationWidgetButton m_mouseOverButton;
    private RayoNavigationWidgetButton.ButtonName m_dropshadowBelowButton = RayoNavigationWidgetButton.ButtonName.NONE;
    private Map<RayoNavigationWidgetButton.ButtonName, RayoNavigationWidgetButton> m_buttonMap = new HashMap<RayoNavigationWidgetButton.ButtonName, RayoNavigationWidgetButton>();

    public RayoJNavigationPanel(ISwingEnvironment env) {
        super(env);
        this.setPreferredSize(SIZE);
        this.setOpaque(false);
        this.initButtons();
        SwingProgressHandler progressHandler = SwingProgressHandler.getInstance();
        if (progressHandler != null) {
            progressHandler.addStateChangeListener(new SwingProgressHandler.IStateChangeListener(){

                public void stateChanged(SwingProgressHandler h) {
                    RayoStopRefreshButton button = RayoJNavigationPanel.this.getStopRefreshButton();
                    if (button == null) {
                        return;
                    }
                    button.setLoading(h.isJobRunning());
                }
            });
        }
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                RayoJNavigationPanel.this.detectMouseOverButton(e.getX(), e.getY());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                RayoJNavigationPanel.this.setMouseOverButton(RayoNavigationWidgetButton.ButtonName.NONE);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RayoJNavigationPanel.this.setPressedButton(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RayoJNavigationPanel.this.setPressedButton(false);
                RayoJNavigationPanel.this.buttonClicked(e.getButton());
            }
        });
    }

    private boolean isNavigationHistoryEnabled() {
        return UIManager.getBoolean("Synth.NavigationPanel.showHistory");
    }

    private void initButtons() {
        RayoNavigationWidgetButton forward;
        RayoNavigationWidgetButton back = new RayoNavigationWidgetButton(RayoNavigationWidgetButton.ButtonName.BACK, (JComponent)((Object)this));
        back.setButtonPos(new Point(14, 15));
        back.setIconPos(new Point(22, 20));
        this.m_buttonMap.put(RayoNavigationWidgetButton.ButtonName.BACK, back);
        this.addDisabledListener(back);
        if (this.isNavigationHistoryEnabled()) {
            Point historyIconPosition = new Point(66, 20);
            forward = new RayoForwardButton((JComponent)((Object)this), historyIconPosition, back.isEnabled());
        } else {
            forward = new RayoNavigationWidgetButton(RayoNavigationWidgetButton.ButtonName.FORWARD, (JComponent)((Object)this));
        }
        forward.setButtonPos(new Point(48, 15));
        forward.setIconPos(new Point(53, 20));
        forward.setEnabled(false);
        this.m_buttonMap.put(RayoNavigationWidgetButton.ButtonName.FORWARD, forward);
        this.addDisabledListener(forward);
        RayoStopRefreshButton stopRefresh = new RayoStopRefreshButton((JComponent)((Object)this));
        stopRefresh.setButtonPos(new Point(82, 15));
        stopRefresh.setIconPos(new Point(88, 22));
        stopRefresh.loadGlowAnimation("navigation_glow");
        stopRefresh.showStopIcon();
        this.m_buttonMap.put(RayoNavigationWidgetButton.ButtonName.STOP_REFRESH, stopRefresh);
        this.addDisabledListener(stopRefresh);
        if (this.isNavigationHistoryEnabled()) {
            PropertyChangeListener historyEnabledListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        boolean enabled = (Boolean)evt.getNewValue();
                        if (forward instanceof RayoForwardButton) {
                            ((RayoForwardButton)forward).setHistoryEnabled(enabled);
                        }
                    }
                }
            };
            back.addPropertyChangeListener(historyEnabledListener);
        }
    }

    public void rebuild(IDesktop desktop) {
        this.getBackButton().setPrimaryAction(this.getBackAction());
        this.getBackButton().setWidgetIconId("navigation_widget_back");
        this.getBackButton().setIconId(RayoNavigationWidgetButton.ActionType.PrimaryAction, "navigation_back");
        this.getBackButton().setActiveActionType(RayoNavigationWidgetButton.ActionType.PrimaryAction);
        this.getForwardButton().setPrimaryAction(this.getForwardAction());
        this.getForwardButton().setWidgetIconId("navigation_widget_forward");
        this.getForwardButton().setIconId(RayoNavigationWidgetButton.ActionType.PrimaryAction, "navigation_forward");
        this.getForwardButton().setActiveActionType(RayoNavigationWidgetButton.ActionType.PrimaryAction);
        if (this.isNavigationHistoryEnabled()) {
            this.getForwardButton().setSecondaryAction(this.getHistoryAction());
            this.getForwardButton().setIconId(RayoNavigationWidgetButton.ActionType.SecondaryAction, "navigation_history");
        }
        this.getStopRefreshButton().setPrimaryAction(this.getRefreshAction());
        this.getStopRefreshButton().setSecondaryAction(this.getStopAction());
        this.getStopRefreshButton().setWidgetIconId("navigation_widget_stop_refresh");
        this.getStopRefreshButton().setIconId(RayoNavigationWidgetButton.ActionType.PrimaryAction, "navigation_refresh");
        this.getStopRefreshButton().setIconId(RayoNavigationWidgetButton.ActionType.SecondaryAction, "navigation_stop");
        this.getStopRefreshButton().setActiveActionType(RayoNavigationWidgetButton.ActionType.PrimaryAction);
        this.repaint();
    }

    private void addDisabledListener(RayoNavigationWidgetButton button) {
        button.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled;
                if ("enabled".equals(evt.getPropertyName()) && !(enabled = ((Boolean)evt.getNewValue()).booleanValue())) {
                    RayoNavigationWidgetButton disabledButton = (RayoNavigationWidgetButton)evt.getSource();
                    if (RayoJNavigationPanel.this.m_mouseOverButton != null && RayoJNavigationPanel.this.m_mouseOverButton.getName() == disabledButton.getName()) {
                        RayoJNavigationPanel.this.setMouseOverButton(RayoNavigationWidgetButton.ButtonName.NONE);
                    }
                }
            }
        });
    }

    private void detectMouseOverButton(int x, int y) {
        RayoNavigationWidgetButton.ButtonName moButtonName = RayoNavigationWidgetButton.ButtonName.getMouseOverButton(x, y);
        this.setMouseOverButton(moButtonName);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintDropshadow(g);
        this.paintButtons(g);
    }

    private void paintDropshadow(Graphics g) {
        Icon icon = Activator.getIcon((String)this.m_dropshadowBelowButton.getDropshadowIcon());
        if (icon != null) {
            icon.paintIcon((Component)((Object)this), g, 11, 13);
        }
    }

    private RayoNavigationWidgetButton getButton(RayoNavigationWidgetButton.ButtonName button) {
        return this.m_buttonMap.get((Object)button);
    }

    private void paintButtons(Graphics g) {
        this.getButton(RayoNavigationWidgetButton.ButtonName.BACK).paintComponent((Component)((Object)this), g);
        this.getButton(RayoNavigationWidgetButton.ButtonName.FORWARD).paintComponent((Component)((Object)this), g);
        this.getButton(RayoNavigationWidgetButton.ButtonName.STOP_REFRESH).paintComponent((Component)((Object)this), g);
    }

    private void setPressedButton(boolean pressed) {
        if (this.m_mouseOverButton != null) {
            this.m_mouseOverButton.setPressed(pressed);
        }
    }

    private void buttonClicked(int button) {
        if (this.m_mouseOverButton != null) {
            this.m_mouseOverButton.buttonClicked(button);
        }
    }

    private void setMouseOverButton(RayoNavigationWidgetButton.ButtonName moButtonName) {
        if (this.m_mouseOverButton != null) {
            this.m_mouseOverButton.setMouseOver(false);
            this.m_mouseOverButton.setPressed(false);
        }
        this.m_mouseOverButton = this.getButton(moButtonName);
        this.m_dropshadowBelowButton = this.m_mouseOverButton != null && this.m_mouseOverButton.isEnabled() ? moButtonName : RayoNavigationWidgetButton.ButtonName.NONE;
        if (this.m_mouseOverButton != null) {
            this.m_mouseOverButton.setMouseOver(true);
        }
    }

    public RayoNavigationWidgetButton getBackButton() {
        return this.getButton(RayoNavigationWidgetButton.ButtonName.BACK);
    }

    public RayoNavigationWidgetButton getForwardButton() {
        return this.getButton(RayoNavigationWidgetButton.ButtonName.FORWARD);
    }

    public RayoStopRefreshButton getStopRefreshButton() {
        return (RayoStopRefreshButton)this.getButton(RayoNavigationWidgetButton.ButtonName.STOP_REFRESH);
    }

    public Point getHistoryMenuLocation() {
        return HISTORY_MENU_LOCATION;
    }
}

