/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.sun.beans;

import com.bsiag.sun.beans.ClassFinder;
import com.bsiag.sun.beans.MutableExpression;
import java.beans.Expression;
import java.beans.XMLDecoder;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import sun.reflect.misc.FieldUtil;

public class ObjectHandler
extends HandlerBase {
    private Hashtable environment = new Hashtable();
    private Vector expStack = new Vector();
    private StringBuffer chars = new StringBuffer();
    private XMLDecoder is;
    private ClassLoader ldr;
    private int itemsRead = 0;
    private boolean isString;

    public static Class typeNameToClass(String typeName) {
        if ((typeName = typeName.intern()) == "boolean") {
            return Boolean.class;
        }
        if (typeName == "byte") {
            return Byte.class;
        }
        if (typeName == "char") {
            return Character.class;
        }
        if (typeName == "short") {
            return Short.class;
        }
        if (typeName == "int") {
            return Integer.class;
        }
        if (typeName == "long") {
            return Long.class;
        }
        if (typeName == "float") {
            return Float.class;
        }
        if (typeName == "double") {
            return Double.class;
        }
        if (typeName == "void") {
            return Void.class;
        }
        return null;
    }

    public static Class typeNameToPrimitiveClass(String typeName) {
        if ((typeName = typeName.intern()) == "boolean") {
            return Boolean.TYPE;
        }
        if (typeName == "byte") {
            return Byte.TYPE;
        }
        if (typeName == "char") {
            return Character.TYPE;
        }
        if (typeName == "short") {
            return Short.TYPE;
        }
        if (typeName == "int") {
            return Integer.TYPE;
        }
        if (typeName == "long") {
            return Long.TYPE;
        }
        if (typeName == "float") {
            return Float.TYPE;
        }
        if (typeName == "double") {
            return Double.TYPE;
        }
        if (typeName == "void") {
            return Void.TYPE;
        }
        return null;
    }

    @Deprecated
    public static Class classForName(String name) throws ClassNotFoundException {
        return ClassFinder.resolveClass(name);
    }

    @Deprecated
    public static Class classForName(String name, ClassLoader cl) throws ClassNotFoundException {
        return ClassFinder.resolveClass(name, cl);
    }

    public ObjectHandler() {
    }

    public ObjectHandler(XMLDecoder is) {
        this();
        this.is = is;
    }

    public ObjectHandler(XMLDecoder is, ClassLoader loader) {
        this(is);
        this.ldr = loader;
    }

    public void reset() {
        this.expStack.clear();
        this.chars.setLength(0);
        MutableExpression e = new MutableExpression();
        e.setTarget(this.classForName2("java.lang.Object"));
        e.setMethodName("null");
        this.expStack.add(e);
    }

    private Object getValue(Expression exp) {
        try {
            return exp.getValue();
        }
        catch (Exception e) {
            if (this.is != null) {
                this.is.getExceptionListener().exceptionThrown(e);
            }
            return null;
        }
    }

    private void addArg(Object arg) {
        this.lastExp().addArg(arg);
    }

    private Object pop(Vector v) {
        int last = v.size() - 1;
        Object result = v.get(last);
        v.remove(last);
        return result;
    }

    private Object eval() {
        return this.getValue(this.lastExp());
    }

    private MutableExpression lastExp() {
        return (MutableExpression)this.expStack.lastElement();
    }

    public Object dequeueResult() {
        Object[] results = this.lastExp().getArguments();
        return results[this.itemsRead++];
    }

    private boolean isPrimitive(String name) {
        return name != "void" && ObjectHandler.typeNameToClass(name) != null;
    }

    private void simulateException(String message) {
        Exception e = new Exception(message);
        e.fillInStackTrace();
        if (this.is != null) {
            this.is.getExceptionListener().exceptionThrown(e);
        }
    }

    private Class classForName2(String name) {
        try {
            return ClassFinder.resolveClass(name, this.ldr);
        }
        catch (ClassNotFoundException e) {
            if (this.is != null) {
                this.is.getExceptionListener().exceptionThrown(e);
            }
            return null;
        }
    }

    private HashMap getAttributes(AttributeList attrs) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (attrs != null && attrs.getLength() > 0) {
            int i = 0;
            while (i < attrs.getLength()) {
                attributes.put(attrs.getName(i), attrs.getValue(i));
                ++i;
            }
        }
        return attributes;
    }

    @Override
    public void startElement(String name, AttributeList attrs) throws SAXException {
        String fieldName;
        String idrefName;
        name = name.intern();
        if (this.isString) {
            this.parseCharCode(name, this.getAttributes(attrs));
            return;
        }
        this.chars.setLength(0);
        HashMap attributes = this.getAttributes(attrs);
        MutableExpression e = new MutableExpression();
        String className = (String)attributes.get("class");
        if (className != null) {
            e.setTarget(this.classForName2(className));
        }
        Object property = attributes.get("property");
        String index = (String)attributes.get("index");
        if (index != null) {
            property = new Integer(index);
            e.addArg(property);
        }
        e.setProperty(property);
        String methodName = (String)attributes.get("method");
        if (methodName == null && property == null) {
            methodName = "new";
        }
        e.setMethodName(methodName);
        if (name == "string") {
            e.setTarget(String.class);
            e.setMethodName("new");
            this.isString = true;
        } else if (this.isPrimitive(name)) {
            Class wrapper = ObjectHandler.typeNameToClass(name);
            e.setTarget(wrapper);
            e.setMethodName("new");
            this.parseCharCode(name, attributes);
        } else if (name == "class") {
            e.setTarget(Class.class);
            e.setMethodName("forName");
        } else if (name == "null") {
            e.setTarget(Object.class);
            e.setMethodName("getSuperclass");
            e.setValue(null);
        } else if (name == "void") {
            if (e.getTarget() == null) {
                e.setTarget(this.eval());
            }
        } else if (name == "array") {
            String subtypeName = (String)attributes.get("class");
            Class subtype = subtypeName == null ? Object.class : this.classForName2(subtypeName);
            String length = (String)attributes.get("length");
            if (length != null) {
                e.setTarget(Array.class);
                e.addArg(subtype);
                e.addArg(new Integer(length));
            } else {
                Class<?> arrayClass = Array.newInstance(subtype, 0).getClass();
                e.setTarget(arrayClass);
            }
        } else if (name == "java") {
            e.setValue(this.is);
        } else if (name != "object") {
            this.simulateException("Unrecognized opening tag: " + name + " " + this.attrsToString(attrs));
            return;
        }
        String idName = (String)attributes.get("id");
        if (idName != null) {
            this.environment.put(idName, e);
        }
        if ((idrefName = (String)attributes.get("idref")) != null) {
            e.setValue(this.lookup(idrefName));
        }
        if ((fieldName = (String)attributes.get("field")) != null) {
            e.setValue(this.getFieldValue(e.getTarget(), fieldName));
        }
        this.expStack.add(e);
    }

    private Object getFieldValue(Object target, String fieldName) {
        try {
            Class type = target.getClass();
            if (type == Class.class) {
                type = (Class)target;
            }
            Field f = FieldUtil.getField(type, fieldName);
            return f.get(target);
        }
        catch (Exception e) {
            if (this.is != null) {
                this.is.getExceptionListener().exceptionThrown(e);
            }
            return null;
        }
    }

    private String attrsToString(AttributeList attrs) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < attrs.getLength()) {
            b.append(String.valueOf(attrs.getName(i)) + "=\"" + attrs.getValue(i) + "\" ");
            ++i;
        }
        return b.toString();
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.chars.append(new String(buf, offset, len));
    }

    private void parseCharCode(String name, Map map) {
        String value;
        if (name == "char" && (value = (String)map.get("code")) != null) {
            this.chars.append(ObjectHandler.parseIntAsChar(value));
        }
    }

    private static char parseIntAsChar(String data) {
        try {
            int i = data.startsWith("#") ? Integer.parseInt(data.substring(1), 16) : Integer.parseInt(data);
            char ch = (char)i;
            if (ch == i) {
                return ch;
            }
            throw new IllegalArgumentException("Wrong character code: '" + data + "'");
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Wrong character code: '" + data + "'", exception);
        }
    }

    public Object lookup(String s) {
        Expression e = (Expression)this.environment.get(s);
        if (e == null) {
            this.simulateException("Unbound variable: " + s);
        }
        return this.getValue(e);
    }

    public void register(String id, Object value) {
        MutableExpression e = new MutableExpression();
        ((Expression)e).setValue(value);
        this.environment.put(id, e);
    }

    @Override
    public void endElement(String name) throws SAXException {
        if ((name = name.intern()) == "string") {
            this.isString = false;
        } else if (this.isString) {
            return;
        }
        if (name == "java") {
            return;
        }
        if (this.isPrimitive(name) || name == "string" || name == "class") {
            this.addArg(this.chars.toString());
        }
        if (name == "object" || name == "array" || name == "void" || this.isPrimitive(name) || name == "string" || name == "class" || name == "null") {
            Expression e = (Expression)this.pop(this.expStack);
            Object value = this.getValue(e);
            if (name != "void") {
                this.addArg(value);
            }
        } else {
            this.simulateException("Unrecognized closing tag: " + name);
        }
    }
}

