/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.sun.swing.plaf.synth.SynthIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import org.eclipse.scout.rt.ui.swing.ext.JLabelEx;
import sun.swing.SwingUtilities2;

public class SynthGraphicsUtils {
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintInsets = new Insets(0, 0, 0, 0);
    private Rectangle iconR = new Rectangle();
    private Rectangle textR = new Rectangle();
    private Rectangle viewR = new Rectangle();
    private Insets viewSizingInsets = new Insets(0, 0, 0, 0);

    public void drawLine(SynthContext context, Object paintKey, Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public void drawLine(SynthContext context, Object paintKey, Graphics g, int x1, int y1, int x2, int y2, Object styleKey) {
        if ("dashed".equals(styleKey)) {
            if (x1 == x2) {
                y1 += y1 % 2;
                int y = y1;
                while (y <= y2) {
                    g.drawLine(x1, y, x2, y);
                    y += 2;
                }
            } else if (y1 == y2) {
                x1 += x1 % 2;
                int x = x1;
                while (x <= x2) {
                    g.drawLine(x, y1, x, y2);
                    x += 2;
                }
            }
        } else {
            this.drawLine(context, paintKey, g, x1, y1, x2, y2);
        }
    }

    public String layoutText(SynthContext ss, FontMetrics fm, String text, Icon icon, int hAlign, int vAlign, int hTextPosition, int vTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int iconTextGap) {
        if (icon instanceof SynthIcon) {
            SynthIconWrapper wrapper = SynthIconWrapper.get((SynthIcon)icon, ss);
            String formattedText = SwingUtilities.layoutCompoundLabel(ss.getComponent(), fm, text, wrapper, vAlign, hAlign, vTextPosition, hTextPosition, viewR, iconR, textR, iconTextGap);
            SynthIconWrapper.release(wrapper);
            return formattedText;
        }
        return SwingUtilities.layoutCompoundLabel(ss.getComponent(), fm, text, icon, vAlign, hAlign, vTextPosition, hTextPosition, viewR, iconR, textR, iconTextGap);
    }

    public int computeStringWidth(SynthContext ss, Font font, FontMetrics metrics, String text) {
        return SwingUtilities2.stringWidth(ss.getComponent(), metrics, text);
    }

    public Dimension getMinimumSize(SynthContext ss, Font font, String text, Icon icon, int hAlign, int vAlign, int hTextPosition, int vTextPosition, int iconTextGap, int mnemonicIndex) {
        JComponent c = ss.getComponent();
        Dimension size = this.getPreferredSize(ss, font, text, icon, hAlign, vAlign, hTextPosition, vTextPosition, iconTextGap, mnemonicIndex);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            size.width = (int)((float)size.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return size;
    }

    public Dimension getMaximumSize(SynthContext ss, Font font, String text, Icon icon, int hAlign, int vAlign, int hTextPosition, int vTextPosition, int iconTextGap, int mnemonicIndex) {
        JComponent c = ss.getComponent();
        Dimension size = this.getPreferredSize(ss, font, text, icon, hAlign, vAlign, hTextPosition, vTextPosition, iconTextGap, mnemonicIndex);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            size.width = (int)((float)size.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return size;
    }

    public int getMaximumCharHeight(SynthContext context) {
        FontMetrics fm = context.getComponent().getFontMetrics(context.getStyle().getFont(context));
        return fm.getAscent() + fm.getDescent();
    }

    public Dimension getPreferredSize(SynthContext ss, Font font, String text, Icon icon, int hAlign, int vAlign, int hTextPosition, int vTextPosition, int iconTextGap, int mnemonicIndex) {
        JComponent c = ss.getComponent();
        Insets insets = c.getInsets(this.viewSizingInsets);
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (icon == null && (text == null || font == null)) {
            return new Dimension(dx, dy);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension(SynthIcon.getIconWidth(icon, ss) + dx, SynthIcon.getIconHeight(icon, ss) + dy);
        }
        FontMetrics fm = c.getFontMetrics(font);
        this.iconR.height = 0;
        this.iconR.width = 0;
        this.iconR.y = 0;
        this.iconR.x = 0;
        this.textR.height = 0;
        this.textR.width = 0;
        this.textR.y = 0;
        this.textR.x = 0;
        this.viewR.x = dx;
        this.viewR.y = dy;
        this.viewR.height = Short.MAX_VALUE;
        this.viewR.width = Short.MAX_VALUE;
        this.layoutText(ss, fm, text, icon, hAlign, vAlign, hTextPosition, vTextPosition, this.viewR, this.iconR, this.textR, iconTextGap);
        int x1 = Math.min(this.iconR.x, this.textR.x);
        int x2 = Math.max(this.iconR.x + this.iconR.width, this.textR.x + this.textR.width);
        int y1 = Math.min(this.iconR.y, this.textR.y);
        int y2 = Math.max(this.iconR.y + this.iconR.height, this.textR.y + this.textR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        rv.width += dx;
        rv.height += dy;
        return rv;
    }

    public void paintText(SynthContext ss, Graphics g, String text, Rectangle bounds, int mnemonicIndex) {
        this.paintText(ss, g, text, bounds.x, bounds.y, mnemonicIndex);
    }

    public void paintText(SynthContext ss, Graphics g, String text, int x, int y, int mnemonicIndex) {
        if (text != null) {
            JComponent c = ss.getComponent();
            FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, x, y += fm.getAscent());
        }
    }

    public void paintText(SynthContext ss, Graphics g, String text, Icon icon, int hAlign, int vAlign, int hTextPosition, int vTextPosition, int iconTextGap, int mnemonicIndex, int textOffset) {
        int lsb;
        if (icon == null && text == null) {
            return;
        }
        JComponent c = ss.getComponent();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
        Insets insets = SynthLookAndFeel.getPaintingInsets(ss, this.paintInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = c.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        if (c instanceof JLabelEx && text.length() > 0 && (lsb = SwingUtilities2.getLeftSideBearing(c, fm, text)) < 0) {
            this.paintViewR.width -= lsb;
        }
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String clippedText = this.layoutText(ss, fm, text, icon, hAlign, vAlign, hTextPosition, vTextPosition, this.paintViewR, this.paintIconR, this.paintTextR, iconTextGap);
        if (icon != null) {
            Color color = g.getColor();
            this.paintIconR.x = ss.getStyle().getBoolean(ss, "TableHeader.alignSorterArrow", false) && "TableHeader.renderer".equals(c.getName()) ? this.paintViewR.width - this.paintIconR.width : (this.paintIconR.x += textOffset);
            this.paintIconR.y += textOffset;
            SynthIcon.paintIcon(icon, ss, g, this.paintIconR.x, this.paintIconR.y, this.paintIconR.width, this.paintIconR.height);
            g.setColor(color);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, this.paintTextR);
            } else {
                this.paintTextR.x += textOffset;
                this.paintTextR.y += textOffset;
                this.paintText(ss, g, clippedText, this.paintTextR, mnemonicIndex);
            }
        }
    }

    private static class SynthIconWrapper
    implements Icon {
        private static final List CACHE = new ArrayList(1);
        private SynthIcon synthIcon;
        private SynthContext context;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SynthIconWrapper get(SynthIcon icon, SynthContext context) {
            List list = CACHE;
            synchronized (list) {
                int size = CACHE.size();
                if (size > 0) {
                    SynthIconWrapper wrapper = (SynthIconWrapper)CACHE.remove(size - 1);
                    wrapper.reset(icon, context);
                    return wrapper;
                }
            }
            return new SynthIconWrapper(icon, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void release(SynthIconWrapper wrapper) {
            wrapper.reset(null, null);
            List list = CACHE;
            synchronized (list) {
                CACHE.add(wrapper);
            }
        }

        SynthIconWrapper(SynthIcon icon, SynthContext context) {
            this.reset(icon, context);
        }

        void reset(SynthIcon icon, SynthContext context) {
            this.synthIcon = icon;
            this.context = context;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return this.synthIcon.getIconWidth(this.context);
        }

        @Override
        public int getIconHeight() {
            return this.synthIcon.getIconHeight(this.context);
        }
    }
}

