/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;

public class RayoNavigationWidgetButton {
    private ActionType m_activeActionType;
    private AbstractAction m_primaryAction;
    private AbstractAction m_secondaryAction;
    private IconGroup m_widgetIconGroup;
    private IconGroup m_primaryIconGroup;
    private IconGroup m_secondaryIconGroup;
    private P_ActionEnableStateChangedListener m_actionEnableStateChangedListener;
    protected static final String PROP_ENABLED = "enabled";
    private PropertyChangeSupport m_support = new PropertyChangeSupport(this);
    private JComponent m_parent;
    private Point m_buttonPos;
    private Point m_iconPos;
    private boolean m_enabled = true;
    private boolean m_mouseOver = false;
    private boolean m_pressed = false;
    private ButtonName m_name;

    RayoNavigationWidgetButton(ButtonName name, JComponent parent) {
        this.m_name = name;
        this.m_parent = parent;
        this.m_activeActionType = ActionType.None;
        this.m_actionEnableStateChangedListener = new P_ActionEnableStateChangedListener();
    }

    protected Icon getPrimaryIconForCurrentState() {
        Icon icon = this.m_primaryIconGroup.getIcon(IconGroup.IconState.NORMAL);
        if (!this.isEnabled() && this.m_primaryIconGroup.hasIcon(IconGroup.IconState.DISABLED)) {
            icon = this.m_primaryIconGroup.getIcon(IconGroup.IconState.DISABLED);
        } else if (this.isMouseOver() && this.m_primaryIconGroup.hasIcon(IconGroup.IconState.ROLLOVER)) {
            icon = this.m_primaryIconGroup.getIcon(IconGroup.IconState.ROLLOVER);
        }
        return icon;
    }

    protected Icon getSecondaryIconForCurrentState() {
        Icon icon = this.m_secondaryIconGroup.getIcon(IconGroup.IconState.NORMAL);
        if (!this.isEnabled() && this.m_secondaryIconGroup.hasIcon(IconGroup.IconState.DISABLED)) {
            icon = this.m_secondaryIconGroup.getIcon(IconGroup.IconState.DISABLED);
        } else if (this.isMouseOver() && this.m_secondaryIconGroup.hasIcon(IconGroup.IconState.ROLLOVER)) {
            icon = this.m_secondaryIconGroup.getIcon(IconGroup.IconState.ROLLOVER);
        }
        return icon;
    }

    private Icon getWidgetIconForCurrentState() {
        Icon icon = this.m_widgetIconGroup.getIcon(IconGroup.IconState.NORMAL);
        if (this.isMouseOver() && this.m_widgetIconGroup.hasIcon(IconGroup.IconState.ROLLOVER)) {
            icon = this.m_widgetIconGroup.getIcon(IconGroup.IconState.ROLLOVER);
        }
        return icon;
    }

    public boolean isPressed() {
        return this.m_pressed;
    }

    public void setPressed(boolean pressed) {
        if (this.isEnabled()) {
            boolean oldPressed = this.m_pressed;
            this.m_pressed = pressed;
            if (oldPressed != this.m_pressed) {
                this.repaintParent();
            }
        }
    }

    protected void performAction(AbstractAction action) {
        action.actionPerformed(new ActionEvent(this.m_parent, 1001, null));
    }

    public void buttonClicked(int button) {
        this.performAction(this.m_primaryAction);
    }

    public boolean isMouseOver() {
        return this.m_mouseOver;
    }

    public void setMouseOver(boolean mouseOver) {
        if (this.isEnabled()) {
            boolean oldMouseOver = this.m_mouseOver;
            this.m_mouseOver = mouseOver;
            if (oldMouseOver != this.m_mouseOver) {
                this.repaintParent();
            }
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.m_enabled;
        this.m_enabled = enabled;
        this.m_support.firePropertyChange(PROP_ENABLED, oldEnabled, this.m_enabled);
        if (oldEnabled != this.m_enabled) {
            if (!enabled) {
                this.m_mouseOver = false;
                this.m_pressed = false;
            }
            this.repaintParent();
        }
    }

    public final void paintComponent(Component c, Graphics g) {
        this.paintButton(c, g);
        this.paintIcon(c, g);
    }

    protected void paintButton(Component c, Graphics g) {
        this.paintPressedImage(this.getWidgetIconForCurrentState(), this.m_buttonPos, this.m_pressed, c, g);
    }

    protected void paintIcon(Component c, Graphics g) {
        if (this.getActiveActionType() == ActionType.PrimaryAction) {
            this.paintPressedImage(this.getPrimaryIconForCurrentState(), this.m_iconPos, this.m_pressed, c, g);
        } else if (this.getActiveActionType() == ActionType.SecondaryAction) {
            this.paintPressedImage(this.getSecondaryIconForCurrentState(), this.m_iconPos, this.m_pressed, c, g);
        }
    }

    protected void paintPressedImage(Icon img, Point p, boolean pressed, Component c, Graphics g) {
        int x = p.x;
        int y = p.y;
        if (pressed) {
            ++x;
            ++y;
        }
        img.paintIcon(c, g, x, y);
    }

    protected void repaintParent() {
        this.m_parent.repaint();
    }

    void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_support.addPropertyChangeListener(l);
    }

    void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_support.removePropertyChangeListener(l);
    }

    public ButtonName getName() {
        return this.m_name;
    }

    public final void setPrimaryAction(AbstractAction primaryAction) {
        if (this.m_primaryAction != null) {
            this.m_primaryAction.removePropertyChangeListener(this.m_actionEnableStateChangedListener);
        }
        this.m_primaryAction = primaryAction;
        if (this.m_primaryAction != null) {
            this.m_primaryAction.addPropertyChangeListener(new P_ActionEnableStateChangedListener());
        }
    }

    public final AbstractAction getPrimaryAction() {
        return this.m_primaryAction;
    }

    public final void setSecondaryAction(AbstractAction secondaryAction) {
        if (this.m_secondaryAction != null) {
            this.m_secondaryAction.removePropertyChangeListener(this.m_actionEnableStateChangedListener);
        }
        this.m_secondaryAction = secondaryAction;
        if (this.m_secondaryAction != null) {
            this.m_secondaryAction.addPropertyChangeListener(new P_ActionEnableStateChangedListener());
        }
    }

    public final AbstractAction getSecondaryAction() {
        return this.m_secondaryAction;
    }

    public void setIconId(ActionType actionType, String iconId) {
        if (actionType == ActionType.PrimaryAction) {
            this.m_primaryIconGroup = new IconGroup(iconId);
        } else {
            this.m_secondaryIconGroup = new IconGroup(iconId);
        }
    }

    public IconGroup getIconGroup(ActionType actionType) {
        if (actionType == ActionType.PrimaryAction) {
            return this.m_primaryIconGroup;
        }
        return this.m_secondaryIconGroup;
    }

    public void setWidgetIconId(String iconId) {
        this.m_widgetIconGroup = new IconGroup(iconId);
    }

    public ActionType getActiveActionType() {
        return this.m_activeActionType;
    }

    public void setActiveActionType(ActionType activeActionType) {
        this.m_activeActionType = activeActionType;
    }

    protected AbstractAction getActiveAction() {
        switch (this.m_activeActionType) {
            case PrimaryAction: {
                return this.m_primaryAction;
            }
            case SecondaryAction: {
                return this.m_secondaryAction;
            }
        }
        return null;
    }

    public Point getButtonPos() {
        return this.m_buttonPos;
    }

    public void setButtonPos(Point buttonPos) {
        this.m_buttonPos = buttonPos;
    }

    public Point getIconPos() {
        return this.m_iconPos;
    }

    public void setIconPos(Point iconPos) {
        this.m_iconPos = iconPos;
    }

    static enum ActionType {
        PrimaryAction,
        SecondaryAction,
        None;

    }

    static enum ButtonName {
        NONE(new Rectangle(), "navigation_shadow"),
        BACK(new Rectangle(17, 17, 28, 30), "navigation_shadow_back"),
        FORWARD(new Rectangle(49, 17, 33, 30), "navigation_shadow_forward"),
        STOP_REFRESH(new Rectangle(82, 17, 30, 30), "navigation_shadow_stop_refresh");

        private Rectangle m_bounds;
        private String m_dropshadowIcon;

        private ButtonName(Rectangle bounds, String dropshadowIcon) {
            this.m_bounds = bounds;
            this.m_dropshadowIcon = dropshadowIcon;
        }

        static ButtonName getMouseOverButton(int x, int y) {
            ButtonName[] buttonNameArray = ButtonName.values();
            int n = buttonNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                ButtonName buttonName = buttonNameArray[n2];
                if (buttonName.m_bounds.contains(x, y)) {
                    return buttonName;
                }
                ++n2;
            }
            return NONE;
        }

        public String getDropshadowIcon() {
            return this.m_dropshadowIcon;
        }
    }

    private class P_ActionEnableStateChangedListener
    implements PropertyChangeListener {
        private P_ActionEnableStateChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (RayoNavigationWidgetButton.PROP_ENABLED.equals(evt.getPropertyName())) {
                RayoNavigationWidgetButton.this.setEnabled((Boolean)evt.getNewValue());
            }
        }
    }
}

