/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.form.fields.checkbox;

import javax.swing.JCheckBox;
import javax.swing.JComponent;

import org.eclipse.scout.rt.ui.swing.form.fields.checkbox.SwingScoutCheckBox;

import com.bsiag.scout.rt.ui.swing.rayo.ext.RayoCheckBoxEx;

/**
 * Rayo-Replacement for SwingScoutCheckBox. Returns a Rayo specific implementation
 * of JCheckBox.
 * 
 * @author bsh
 */
public class RayoSwingScoutCheckBox extends SwingScoutCheckBox {

  @Override
  protected JCheckBox createCheckBox(JComponent container) {
    RayoCheckBoxEx rayoCheckBox = new RayoCheckBoxEx();
    rayoCheckBox.setOpaque(false);
    return rayoCheckBox;
  }
}
