/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop;

import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJNavigationPanel;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJToolTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJViewTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.SwingScoutHeaderPanel;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoJNavigationPanel;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoToolTabsBar;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoViewTabsBar;

public class RayoSwingScoutHeaderPanel extends SwingScoutHeaderPanel {

  @Override
  public AbstractJViewTabsBar createViewTabsBar() {
    return new RayoViewTabsBar(getSwingEnvironment());
  }

  @Override
  public AbstractJToolTabsBar createToolTabsBar() {
    return new RayoToolTabsBar(getSwingEnvironment());
  }

  @Override
  public AbstractJNavigationPanel createNavigationPanel() {
    return new RayoJNavigationPanel(getSwingEnvironment());
  }

  @Override
  public RayoToolTabsBar getSwingToolTabsPanel() {
    return (RayoToolTabsBar) super.getSwingToolTabsPanel();
  }
}
