/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop;

import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.ui.swing.window.desktop.ColumnSplitStrategy;

public class RayoColumnSplitStrategy extends ColumnSplitStrategy {
  private int m_toolsViewMinWidth;

  public RayoColumnSplitStrategy(ClientUIPreferences prefs) {
    super(prefs);
    // initial ToolsView with is width of 3th column
    m_toolsViewMinWidth = m_definedLocation[0][3] - m_definedLocation[0][2];
  }

  public void setToolsViewWidth(int toolsViewWidth) {
    for (int r = 0; r < 3; r++) {
      setSplitLocation(r, 2, m_span - toolsViewWidth);
    }
  }

  public void setToolsViewMinWidth(int toolsViewMinWidth) {
    m_toolsViewMinWidth = toolsViewMinWidth;
  }

  @Override
  public void updateSpan(int newSpan) {
    m_span = newSpan;
    for (int r = 0; r < 3; r++) {
      int toolViewWidth = m_definedLocation[r][3] - m_definedLocation[r][2];
      m_location[r][3] = m_span;
      m_location[r][2] = m_span - Math.max(m_toolsViewMinWidth, toolViewWidth);
      m_location[r][1] = m_definedLocation[r][1];
      if (m_location[r][1] + 20 > m_location[r][2]) {
        int mid = (m_location[r][1] + m_location[r][2]) / 2;
        m_location[r][1] = mid - 10;
        m_location[r][2] = mid + 10;
      }
    }
  }
}
