/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.inject;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.inject.ActionInjector;

import com.bsiag.scout.rt.ui.swing.rayo.action.RayoSwingScoutToolTab;
import com.bsiag.scout.rt.ui.swing.rayo.action.RayoSwingScoutViewTab;

public class RayoActionInjector extends ActionInjector {
  private static final IScoutLogger LOG = ScoutLogManager.getLogger(RayoActionInjector.class);

  public RayoActionInjector() {
  }

  @Override
  protected ISwingScoutAction<IToolButton> createSwingScoutToolButton(IToolButton toolButton, ISwingEnvironment env) {
    ISwingScoutAction<IToolButton> ui = new RayoSwingScoutToolTab();
    ui.createField(toolButton, env);
    return ui;
  }

  @Override
  protected ISwingScoutAction<IViewButton> createSwingScoutViewButton(IViewButton viewButton, ISwingEnvironment env) {
    ISwingScoutAction<IViewButton> ui = new RayoSwingScoutViewTab();
    ui.createField((IViewButton) viewButton, env);
    return ui;
  }
}
