/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop;

import java.awt.Frame;

import org.eclipse.scout.rt.ui.swing.window.desktop.SwingScoutRootFrame;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.SwingScoutHeaderPanel;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.ToolsViewAndTabsBarSynchronizer;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.ToolsViewController;

public class RayoSwingScoutRootFrame extends SwingScoutRootFrame {

  public RayoSwingScoutRootFrame(Frame frame) {
    super(frame);
  }

  @Override
  protected void initializeSwing() {
    super.initializeSwing();
    // Install controller to synchronize widths of ToolsView and tool button bar
    ToolsViewController toolsViewController = getDesktopComposite().getToolsViewController();
    new ToolsViewAndTabsBarSynchronizer(toolsViewController, getSwingScoutHeaderPanel());
  }

  @Override
  protected SwingScoutHeaderPanel createSwingScoutHeaderPanel() {
    return new RayoSwingScoutHeaderPanel();
  }

  @Override
  public RayoSwingScoutDesktop getDesktopComposite() {
    return (RayoSwingScoutDesktop) super.getDesktopComposite();
  }

  @Override
  public RayoSwingScoutHeaderPanel getSwingScoutHeaderPanel() {
    return (RayoSwingScoutHeaderPanel) super.getSwingScoutHeaderPanel();
  }
}
