/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI CRM Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo;

import java.awt.Frame;
import java.awt.Window;
import java.util.Properties;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.plaf.basic.BasicInternalFrameUI;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swing.AbstractSwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableHeaderEx;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.OnFieldLabelDecorator;
import org.eclipse.scout.rt.ui.swing.form.fields.composer.ISwingScoutComposerField;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.ISwingScoutGroupBox;
import org.eclipse.scout.rt.ui.swing.form.fields.listbox.ISwingScoutListBox;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.ISwingScoutTabBox;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.ISwingScoutTabItem;
import org.eclipse.scout.rt.ui.swing.form.fields.tablefield.ISwingScoutTableField;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.ISwingScoutTextArea;
import org.eclipse.scout.rt.ui.swing.form.fields.treebox.ISwingScoutTreeBox;
import org.eclipse.scout.rt.ui.swing.form.fields.treefield.ISwingScoutTreeField;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutBoundsProvider;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutView;
import org.eclipse.scout.rt.ui.swing.window.desktop.ISwingScoutDesktop;
import org.eclipse.scout.rt.ui.swing.window.desktop.ISwingScoutRootFrame;
import org.eclipse.scout.rt.ui.swing.window.internalframe.SwingScoutInternalFrame;

import com.bsiag.scout.rt.ui.swing.rayo.ext.RayoStatusLabelEx;
import com.bsiag.scout.rt.ui.swing.rayo.ext.RayoStatusLabelTop;
import com.bsiag.scout.rt.ui.swing.rayo.form.fields.RayoOnFieldLabelDecorator;
import com.bsiag.scout.rt.ui.swing.rayo.form.fields.checkbox.RayoCheckBoxFactory;
import com.bsiag.scout.rt.ui.swing.rayo.form.fields.groupbox.RayoSwingScoutGroupBox;
import com.bsiag.scout.rt.ui.swing.rayo.form.fields.tabbox.RayoSwingScoutTabItem;
import com.bsiag.scout.rt.ui.swing.rayo.form.fields.textfield.RayoSwingScoutTextField;
import com.bsiag.scout.rt.ui.swing.rayo.inject.RayoActionInjector;
import com.bsiag.scout.rt.ui.swing.rayo.inject.RayoUIDefaultsInjector;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.RayoSwingScoutDesktop;
import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.RayoSwingScoutRootFrame;

public class RayoSwingEnvironment extends AbstractSwingEnvironment {

  @Override
  public ISwingScoutRootFrame createRootComposite(Frame rootFrame, IDesktop desktop) {
    ISwingScoutRootFrame ui = new RayoSwingScoutRootFrame(rootFrame);
    ui.createField(desktop, this);
    decorate(desktop, ui);
    return ui;
  }

  @Override
  protected void initLookAndFeel(Properties initProperties) {
    String useLafFrameAndDialog = initProperties.getProperty("scout.laf.useLafFrameAndDialog");
    if (StringUtility.hasText(useLafFrameAndDialog)) {
      System.setProperty("scout.laf.useLafFrameAndDialog", useLafFrameAndDialog);
    }

    String topMargin = initProperties.getProperty("scout.laf.topMarginForField");
    if (StringUtility.hasText(topMargin)) {
      System.setProperty("scout.laf.topMarginForField", topMargin);
    }
    else {
      String defaultValue = "4";
      System.setProperty("scout.laf.topMarginForField", defaultValue);
    }

    super.initLookAndFeel(initProperties);
  }

  @Override
  public ISwingScoutDesktop createDesktop(Window owner, IDesktop desktop) {
    ISwingScoutDesktop ui = new RayoSwingScoutDesktop();
    ui.createField(desktop, this);
    decorate(desktop, ui);
    return ui;
  }

  @Override
  protected ISwingScoutView createInternalFrame(Object viewConstraints, IForm form, ISwingScoutBoundsProvider boundsProvider) {
    // suppress title, views with rayo do not have a title
    return new SwingScoutInternalFrame(this, viewConstraints, boundsProvider) {
      @Override
      public void setTitle(String s) {
        super.setTitle(s);
        if (getSwingInternalFrame().getUI() instanceof BasicInternalFrameUI) {
          ((BasicInternalFrameUI) getSwingInternalFrame().getUI()).setNorthPane(null);
        }
      }
    };
  }

  @Override
  public ISwingScoutTabItem createTabItem(JComponent parent, IGroupBox field) {
    ISwingScoutTabItem ui = new RayoSwingScoutTabItem();
    ui.createField(field, this);
    decorate(field, ui);
    return ui;
  }

  @Override
  public JStatusLabelEx createStatusLabel(IFormField formField) {
    JStatusLabelEx ui = null;
    if (formField != null && formField.getLabelPosition() == IFormField.LABEL_POSITION_TOP) {
      ui = new RayoStatusLabelTop();
    }
    else {
      ui = new RayoStatusLabelEx();
    }
    ui.setName("Synth.StatusLabel");
    return ui;
  }

  @Override
  public OnFieldLabelDecorator createOnFieldLabelDecorator(JComponent c, boolean mandatory) {
    return new RayoOnFieldLabelDecorator(c, mandatory);
  }

  @Override
  public ISwingScoutFormField createFormField(JComponent parent, IFormField field) {
    ISwingScoutFormField formField;
    if (field instanceof IGroupBox) {
      RayoSwingScoutGroupBox ui = new RayoSwingScoutGroupBox();
      ui.createField((IGroupBox) field, this);
      decorate(field, ui);
      formField = ui;
    }
    else if (field instanceof IStringField
        && !((IStringField) field).isInputMasked()
        && !((IStringField) field).isMultilineText()) {
      // Don't use the Rayo specific text field for multiline and password fields
      RayoSwingScoutTextField ui = new RayoSwingScoutTextField();
      ui.createField((IStringField) field, this);
      decorate(field, ui);
      formField = ui;
    }
    else if (field instanceof IBooleanField) {
      // bsh 2010--10-01: Rayo specific checkbox
      return new RayoCheckBoxFactory().createFormField(parent, field, this);
    }
    else {
      formField = super.createFormField(parent, field);
    }
    //
    IForm form = field.getForm();
    if (formField instanceof ISwingScoutTabBox && form != null && IForm.VIEW_ID_E.equals(form.getDisplayViewId())) {
      formField.getSwingField().setName("Synth.CompactTabbedPane");
    }
    else if (formField instanceof ISwingScoutGroupBox && form != null && IForm.VIEW_ID_E.equals(form.getDisplayViewId())) {
      ISwingScoutGroupBox groupBox = (ISwingScoutGroupBox) formField;
      //do not change name if body name is null (no insets)
      if (groupBox.getSwingBodyPart().getName() != null) {
        groupBox.getSwingBodyPart().setName("Synth.CompactGroupBoxBody");
      }
      //bottons always have insets (mainbox)
      groupBox.getSwingButtonBarPart().setName("Synth.CompactGroupBoxButtonBar");
    }
    //
    if (formField instanceof ISwingScoutTableField && ((ISwingScoutTableField) formField).getSwingScrollPane() != null && form != null && !IForm.VIEW_ID_PAGE_TABLE.equals(form.getDisplayViewId())) {
      // only if table is not on a TablePage
      ((ISwingScoutTableField) formField).getSwingScrollPane().setName("Synth.TableScrollPane");
    }
    if (formField instanceof ISwingScoutTableField && formField.getSwingField() != null && form != null && IForm.VIEW_ID_PAGE_TABLE.equals(form.getDisplayViewId())) {
      // TODO AWE: check if we should create a RayoSwingScoutTableField and set the synth name there. This would avoid
      // the unnecessary second call to updatePreferredHeight() since the insets of the TableHeader would be correct
      // at that point (as defined by Synth).
      formField.getSwingField().setName("Synth.WideTable");
      if (formField.getSwingField() instanceof JTable) {
        JTable table = (JTable) formField.getSwingField();
        if (table.getTableHeader() instanceof JTableHeaderEx) {
          ((JTableHeaderEx) table.getTableHeader()).updatePreferredHeight();
        }
      }
    }
    if (formField instanceof ISwingScoutTableField && formField.getSwingField() != null && form != null && form instanceof IContentAssistFieldProposalForm<?>) {
      formField.getSwingField().setName("Synth.SmartfieldTable");
      ((ISwingScoutTableField) formField).getSwingScrollPane().setName("Synth.SmartfieldScrollPane");
    }
    if (formField instanceof ISwingScoutListBox) {
      ((ISwingScoutListBox) formField).getSwingScrollPane().setName("Synth.ListBoxScrollPane");
      ((ISwingScoutListBox) formField).getSwingTable().setName("Synth.ListBoxTable");
    }
    if (formField instanceof ISwingScoutTreeBox) {
      ((ISwingScoutTreeBox) formField).getSwingScrollPane().setName("Synth.ListBoxScrollPane");
    }
    if (formField instanceof ISwingScoutTreeField && ((ISwingScoutTreeField) formField).getSwingScrollPane() != null) {
      ((ISwingScoutTreeField) formField).getSwingScrollPane().setName("Synth.ListBoxScrollPane");
    }
    if (formField instanceof ISwingScoutComposerField) {
      ((ISwingScoutComposerField) formField).getSwingScrollPane().setName("Synth.ListBoxScrollPane");
    }
    if (formField instanceof ISwingScoutTextArea) {
      ((ISwingScoutTextArea) formField).getSwingScrollPane().setName("Synth.TextAreaScrollPane");
    }
    return formField;
  }

  @Override
  public void interceptUIDefaults(UIDefaults defaults) {
    new RayoUIDefaultsInjector().inject(defaults);
  }

  @Override
  public ISwingScoutAction createAction(JComponent parent, IAction action) {
    ISwingScoutAction ui = new RayoActionInjector().inject(this, parent, action);
    decorate(action, ui);
    return ui;
  }
}
