/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.form.fields;

import java.awt.Color;
import java.awt.Graphics;

import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

import org.eclipse.scout.rt.ui.swing.form.fields.OnFieldLabelDecorator;

/**
 * Presents the label of a field on the label itself when it is not focused and has no content yet
 */
public class RayoOnFieldLabelDecorator extends OnFieldLabelDecorator {

  public RayoOnFieldLabelDecorator(JComponent c, boolean mandatory) {
    super(c, mandatory);
  }

  @Override
  public void paintOnFieldLabel(Graphics g, JComponent field) {
    if (field == null) {
      return;
    }
    if (field.hasFocus()) {
      return;
    }
    if (field instanceof JTextComponent) {
      if (((JTextComponent) field).getDocument().getLength() > 0) {
        return;
      }
    }
    if (getLabel() != null && getLabel().length() > 0) {
      int baseline = field.getBaseline(field.getWidth(), field.getHeight());
      g.setColor(Color.lightGray);
      g.drawString(getLabel(), field.getInsets().left, baseline);
    }
  }
}
