/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import sun.swing.SwingUtilities2;

public class BasicRootPaneTitlePane
extends JComponent {
    protected JRootPane rootPane;
    protected Icon maximizeIcon;
    protected Icon minimizeIcon;
    protected Icon iconifyIcon;
    protected Icon closeIcon;
    protected Icon maximizeIconRollOver;
    protected Icon minimizeIconRollOver;
    protected Icon iconifyIconRollOver;
    protected Icon closeIconRollOver;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action minimizeAction;
    protected Action iconifyAction;
    private String closeButtonToolTip;
    private String iconifyButtonToolTip;
    private String minimizeButtonToolTip;
    private String maximizeButtonToolTip;
    protected JButton iconifyButton;
    protected JButton toggleButton;
    protected JButton closeButton;
    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;
    protected JMenu windowMenu;
    protected JMenuBar menuBar;
    protected WindowStateListener windowStateListener;
    protected WindowListener windowListener;
    private Window window;
    private int windowState;

    public BasicRootPaneTitlePane(JRootPane rootPane) {
        this.rootPane = rootPane;
        this.installDefaults();
        this.createActions();
        this.createButtons();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.addSubComponents();
        this.createActionMap();
    }

    @Override
    public String getUIClassID() {
        return "RootPaneTitlePaneUI";
    }

    private Window getWindow() {
        return this.window;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.windowState = ((Frame)this.window).getExtendedState();
            }
            this.installListeners();
            this.updateActionStyles();
            this.updateButtonStates();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    protected Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    protected void doClose() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    protected void doIconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            int state = frame.getExtendedState();
            frame.setExtendedState(state | 1);
        }
    }

    protected void doMaximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            int state = frame.getExtendedState();
            frame.setExtendedState(state | 6);
        }
    }

    protected void doMinimize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            int state = frame.getExtendedState();
            state &= 0xFFFFFFFE;
            frame.setExtendedState(state &= 0xFFFFFFF9);
        }
    }

    protected boolean isFrameIconified() {
        Frame frame = this.getFrame();
        return frame != null && (this.windowState & 1) != 0;
    }

    protected boolean isFrameMaximized() {
        Frame frame = this.getFrame();
        return frame != null && (this.windowState & 6) != 0;
    }

    protected boolean isFrameClosable() {
        return true;
    }

    protected boolean isFrameIconifiable() {
        return this.getFrame() != null;
    }

    protected boolean isFrameMaximizable() {
        return this.getFrame() != null;
    }

    private void setActive(boolean isActive) {
        if (this.rootPane.getWindowDecorationStyle() != 0) {
            Boolean activeB;
            Boolean bl = activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
            if (this.iconifyButton != null) {
                this.iconifyButton.putClientProperty("paintActive", activeB);
            }
            if (this.closeButton != null) {
                this.closeButton.putClientProperty("paintActive", activeB);
            }
            if (this.toggleButton != null) {
                this.toggleButton.putClientProperty("paintActive", activeB);
            }
        }
        this.getRootPane().repaint();
    }

    protected void addSubComponents() {
        this.add(this.menuBar);
        this.add(this.iconifyButton);
        this.add(this.toggleButton);
        this.add(this.closeButton);
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.minimizeAction = new MinimizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("showSystemMenu", new ShowSystemMenuAction(true));
        map.put("hideSystemMenu", new ShowSystemMenuAction(false));
        return map;
    }

    protected void installListeners() {
        if (this.windowStateListener == null) {
            this.windowStateListener = this.createWindowStateListener();
        }
        if (this.windowListener == null) {
            this.windowListener = this.createWindowListener();
        }
        if (this.window != null) {
            this.window.addWindowStateListener(this.windowStateListener);
            this.window.addWindowListener(this.windowListener);
        }
    }

    protected void uninstallListeners() {
        if (this.window != null) {
            if (this.windowListener != null) {
                this.window.removeWindowListener(this.windowListener);
            }
            if (this.windowStateListener != null) {
                this.window.removeWindowStateListener(this.windowStateListener);
            }
        }
    }

    protected void installDefaults() {
        this.maximizeIcon = UIManager.getIcon("InternalFrameTitlePane.maximizeIcon");
        this.minimizeIcon = UIManager.getIcon("InternalFrameTitlePane.minimizeIcon");
        this.iconifyIcon = UIManager.getIcon("InternalFrameTitlePane.iconifyIcon");
        this.closeIcon = UIManager.getIcon("InternalFrameTitlePane.closeIcon");
        this.selectedTitleColor = UIManager.getColor("InternalFrameTitlePane.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrameTitlePane.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrameTitlePane.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrameTitlePane.inactiveTitleForeground");
        this.setFont(UIManager.getFont("InternalFrameTitlePane.titleFont"));
        this.closeButtonToolTip = UIManager.getString("InternalFrameTitlePane.closeButtonToolTip");
        this.iconifyButtonToolTip = UIManager.getString("InternalFrameTitlePane.iconButtonToolTip");
        this.minimizeButtonToolTip = UIManager.getString("InternalFrameTitlePane.restoreButtonToolTip");
        this.maximizeButtonToolTip = UIManager.getString("InternalFrameTitlePane.maxButtonToolTip");
    }

    protected void uninstallDefaults() {
    }

    protected void createButtons() {
        this.iconifyButton = new NoFocusButton("InternalFrameTitlePane.iconifyButtonAccessibleName", "InternalFrameTitlePane.iconifyButtonOpacity");
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        if (this.iconifyButtonToolTip != null && this.iconifyButtonToolTip.length() != 0) {
            this.iconifyButton.setToolTipText(this.iconifyButtonToolTip);
        }
        this.toggleButton = new NoFocusButton("InternalFrameTitlePane.maximizeButtonAccessibleName", "InternalFrameTitlePane.maximizeButtonOpacity");
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        this.closeButton = new NoFocusButton("InternalFrameTitlePane.closeButtonAccessibleName", "InternalFrameTitlePane.closeButtonOpacity");
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        if (this.closeButtonToolTip != null && this.closeButtonToolTip.length() != 0) {
            this.closeButton.setToolTipText(this.closeButtonToolTip);
        }
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.addSystemMenuItems(this.windowMenu);
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem mi = systemMenu.add(this.iconifyAction);
        mi.setMnemonic('n');
        mi = systemMenu.add(this.maximizeAction);
        mi.setMnemonic('x');
        systemMenu.add(new JSeparator());
        mi = systemMenu.add(this.closeAction);
        mi.setMnemonic('C');
    }

    protected JMenu createSystemMenu() {
        return new JMenu("    ");
    }

    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setBorderPainted(false);
        return this.menuBar;
    }

    protected void showSystemMenu() {
        this.windowMenu.doClick();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        this.paintTitleBackground(g);
        String title = this.getTitle();
        if (title != null) {
            Font f = g.getFont();
            g.setFont(this.getFont());
            g.setColor(this.rootPane.getForeground());
            FontMetrics fm = this.rootPane.getFontMetrics(g.getFont());
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            Rectangle r = new Rectangle(0, 0, 0, 0);
            if (this.isFrameIconifiable()) {
                r = this.iconifyButton.getBounds();
            } else if (this.isFrameMaximizable()) {
                r = this.toggleButton.getBounds();
            } else if (this.isFrameClosable()) {
                r = this.closeButton.getBounds();
            }
            if (r.x == 0) {
                r.x = this.rootPane.getWidth() - this.rootPane.getInsets().right;
            }
            int titleX = this.menuBar.getX() + this.menuBar.getWidth() + 2;
            int titleW = r.x - titleX - 3;
            title = this.getTitle(title, fm, titleW);
            SwingUtilities2.drawString((JComponent)this, g, title, titleX, baseline);
            g.setFont(f);
        }
    }

    protected void setState(int state) {
        if (state != this.windowState) {
            this.windowState = state;
            this.updateButtonStates();
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintTitleBackground(Graphics g) {
    }

    protected String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    protected String getTitle(String text, FontMetrics fm, int availTextWidth) {
        return SwingUtilities2.clipStringIfNecessary(this, fm, text, availTextWidth);
    }

    protected void updateActionStyles() {
        if (this.iconifyAction != null) {
            this.iconifyAction.putValue("SmallIcon", this.iconifyIcon);
            this.iconifyAction.putValue("ShortDescription", this.iconifyButtonToolTip);
            if (this.iconifyButton.getAction() == null || this.iconifyButton.getAction() == this.iconifyAction) {
                this.iconifyButton.setAction(null);
                this.iconifyButton.setAction(this.iconifyAction);
            }
        }
        if (this.minimizeAction != null) {
            this.minimizeAction.putValue("SmallIcon", this.minimizeIcon);
            this.minimizeAction.putValue("ShortDescription", this.minimizeButtonToolTip);
            if (this.toggleButton.getAction() == null || this.toggleButton.getAction() == this.minimizeAction) {
                this.toggleButton.setAction(null);
                this.toggleButton.setAction(this.minimizeAction);
            }
        }
        if (this.maximizeAction != null) {
            this.maximizeAction.putValue("SmallIcon", this.maximizeIcon);
            this.maximizeAction.putValue("ShortDescription", this.maximizeButtonToolTip);
            if (this.toggleButton.getAction() == null || this.toggleButton.getAction() == this.maximizeAction) {
                this.toggleButton.setAction(null);
                this.toggleButton.setAction(this.maximizeAction);
            }
        }
        if (this.closeAction != null) {
            this.closeAction.putValue("SmallIcon", this.closeIcon);
            this.closeAction.putValue("ShortDescription", this.closeButtonToolTip);
            if (this.closeButton.getAction() == null || this.closeButton.getAction() == this.closeAction) {
                this.closeButton.setAction(null);
                this.closeButton.setAction(this.closeAction);
            }
        }
    }

    protected void updateButtonStates() {
        if (!this.isFrameIconified()) {
            if (this.isFrameMaximized()) {
                this.toggleButton.setAction(this.minimizeAction);
                if (this.minimizeIconRollOver != null) {
                    this.toggleButton.setRolloverEnabled(true);
                    this.toggleButton.setIcon(this.minimizeIcon);
                    this.toggleButton.setRolloverIcon(this.minimizeIconRollOver);
                }
            } else {
                this.toggleButton.setAction(this.maximizeAction);
                if (this.maximizeIconRollOver != null) {
                    this.toggleButton.setRolloverEnabled(true);
                    this.toggleButton.setIcon(this.maximizeIcon);
                    this.toggleButton.setRolloverIcon(this.maximizeIconRollOver);
                }
            }
        }
        this.minimizeAction.setEnabled(this.isFrameMaximizable());
        this.maximizeAction.setEnabled(this.isFrameMaximizable());
        this.iconifyAction.setEnabled(this.isFrameIconifiable());
        this.closeAction.setEnabled(this.isFrameClosable());
        if (this.iconifyIconRollOver != null) {
            this.iconifyButton.setRolloverEnabled(true);
            this.iconifyButton.setIcon(this.iconifyIcon);
            this.iconifyButton.setRolloverIcon(this.iconifyIconRollOver);
        }
        if (this.closeIconRollOver != null) {
            this.closeButton.setRolloverEnabled(true);
            this.closeButton.setIcon(this.closeIcon);
            this.closeButton.setRolloverIcon(this.closeIconRollOver);
        }
    }

    protected WindowStateListener createWindowStateListener() {
        return new WindowStateHandler();
    }

    protected WindowListener createWindowListener() {
        return new WindowHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public class CloseAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BasicRootPaneTitlePane.this.doClose();
        }
    }

    public class IconifyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BasicRootPaneTitlePane.this.doIconify();
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            BasicRootPaneTitlePane.this.doMaximize();
        }
    }

    public class MinimizeAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            BasicRootPaneTitlePane.this.doMinimize();
        }
    }

    private class NoFocusButton
    extends JButton {
        private String uiKey;

        public NoFocusButton(String uiKey, String opacityKey) {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.uiKey = uiKey;
            Object opacity = UIManager.get(opacityKey);
            if (opacity instanceof Boolean) {
                this.setOpaque((Boolean)opacity);
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            AccessibleContext ac = super.getAccessibleContext();
            if (this.uiKey != null) {
                ac.setAccessibleName(UIManager.getString(this.uiKey));
                this.uiKey = null;
            }
            return ac;
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private boolean show;

        public ShowSystemMenuAction(boolean show) {
            this.show = show;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.show) {
                BasicRootPaneTitlePane.this.windowMenu.doClick();
            } else {
                BasicRootPaneTitlePane.this.windowMenu.setVisible(false);
            }
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void paint(Graphics g) {
            Icon icon = UIManager.getIcon("Window.icon");
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image img = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(img.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, g, 0, 0);
            }
        }

        @Override
        public boolean isOpaque() {
            return true;
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 22;
            if (BasicRootPaneTitlePane.this.isFrameClosable()) {
                width += 19;
            }
            if (BasicRootPaneTitlePane.this.isFrameMaximizable()) {
                width += 19;
            }
            if (BasicRootPaneTitlePane.this.isFrameIconifiable()) {
                width += 19;
            }
            FontMetrics fm = BasicRootPaneTitlePane.this.rootPane.getFontMetrics(BasicRootPaneTitlePane.this.rootPane.getFont());
            String frameTitle = BasicRootPaneTitlePane.this.getTitle();
            int title_w = frameTitle != null ? SwingUtilities2.stringWidth(BasicRootPaneTitlePane.this.rootPane, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = SwingUtilities2.stringWidth(BasicRootPaneTitlePane.this.rootPane, fm, String.valueOf(frameTitle.substring(0, 3)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            Icon icon = UIManager.getIcon("Window.icon");
            int fontHeight = fm.getHeight();
            fontHeight += 2;
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            int height = Math.max(fontHeight, iconHeight += 2);
            Dimension dim = new Dimension(width, height);
            if (BasicRootPaneTitlePane.this.getBorder() != null) {
                Insets insets = BasicRootPaneTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container c) {
            boolean leftToRight = true;
            int w = BasicRootPaneTitlePane.this.getWidth();
            int h = BasicRootPaneTitlePane.this.getHeight();
            int buttonHeight = BasicRootPaneTitlePane.this.closeButton.getIcon().getIconHeight();
            Icon icon = UIManager.getIcon("Window.icon");
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = icon.getIconHeight();
            }
            int x = leftToRight ? 2 : w - 16 - 2;
            BasicRootPaneTitlePane.this.menuBar.setBounds(x, (h - iconHeight) / 2, 16, 16);
            int n = x = leftToRight ? w - 16 - 2 : 2;
            if (BasicRootPaneTitlePane.this.isFrameClosable()) {
                BasicRootPaneTitlePane.this.closeButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (BasicRootPaneTitlePane.this.isFrameMaximizable()) {
                BasicRootPaneTitlePane.this.toggleButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (BasicRootPaneTitlePane.this.isFrameIconifiable()) {
                BasicRootPaneTitlePane.this.iconifyButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
            }
        }
    }

    public class WindowHandler
    extends WindowAdapter {
        @Override
        public void windowActivated(WindowEvent ev) {
            BasicRootPaneTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            BasicRootPaneTitlePane.this.setActive(false);
        }
    }

    public class WindowStateHandler
    implements WindowStateListener {
        @Override
        public void windowStateChanged(WindowEvent e) {
            BasicRootPaneTitlePane.this.setState(e.getNewState());
        }
    }
}

