/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.inject;

import java.awt.Font;

import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

import org.eclipse.scout.rt.ui.swing.inject.UIDefaultsInjector;

public class RayoUIDefaultsInjector extends UIDefaultsInjector {

  public RayoUIDefaultsInjector() {
  }

  @Override
  public void inject(UIDefaults defaults) {
    super.inject(defaults);

    defaults.put("HeaderPanel.background", new ColorUIResource(0xCFE2EF));
    defaults.put("HeaderPanel.height", 85);

    defaults.put("Synth.ViewTab.foreground", new ColorUIResource(0x486685));
    defaults.put("Synth.ViewTab.foregroundSelected", new ColorUIResource(254, 154, 35));
    defaults.put("Synth.ViewTab.font", new FontUIResource("Arial", Font.PLAIN, 12));
    defaults.put("Synth.ViewTab.fontSelected", new FontUIResource("Arial", Font.BOLD, 12));
    defaults.put("Synth.NavigationPanel.showHistory", true);
    defaults.put("Synth.ToolButtonView.minWidth", 330);
  }
}
