/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.form.fields.textfield;

import org.eclipse.scout.rt.ui.swing.form.fields.textfield.SwingScoutTextField;

/**
 * Rayo-Replacement for SwingScoutTextField. Uses a different link color (the same
 * that is used in the HTML wizard).
 * 
 * @author bsh
 */
public class RayoSwingScoutTextField extends SwingScoutTextField {

  private boolean m_myDecorationLink;

  @Override
  protected void setDecorationLinkFromScout(boolean b) {
    m_myDecorationLink = b;
    super.setDecorationLinkFromScout(b);
  }

  @Override
  protected void setForegroundFromScout(String scoutColor) {
    super.setForegroundFromScout(scoutColor);
    if (scoutColor == null && m_myDecorationLink) {
      super.setForegroundFromScout("67A8CE");
    }
  }
}
