/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.MouseInputHandler;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import com.bsiag.javax.swing.plaf.synth.SynthRootPaneTitlePane;
import com.bsiag.javax.swing.plaf.synth.SynthStyle;
import com.bsiag.sun.swing.plaf.synth.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

class SynthRootPaneUI
extends BasicRootPaneUI
implements SynthUI {
    private SynthStyle style;
    private LayoutManager layoutManager;
    private JComponent titlePane;
    private Window window;
    private JRootPane root;
    private MouseInputListener mouseInputListener;

    SynthRootPaneUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthRootPaneUI();
    }

    @Override
    protected void installDefaults(JRootPane c) {
        this.updateStyle(c);
        this.root = c;
        this.installClientDecorations(c);
    }

    private void installClientDecorations(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style != 0 && style != 1) {
            root.setName("Synth.Dialog");
        }
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        if (root.getParent() != null) {
            this.installWindowListeners(root, root.getParent());
        }
        this.installLayout(root);
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
            root.setLayout(this.layoutManager);
        }
    }

    private LayoutManager createLayoutManager() {
        return new SynthRootLayout();
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(root);
                this.window.addMouseListener(this.mouseInputListener);
                this.window.addMouseMotionListener(this.mouseInputListener);
            }
            this.window.addPropertyChangeListener("title", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (SynthRootPaneUI.this.titlePane != null) {
                        SynthRootPaneUI.this.titlePane.repaint();
                    }
                }
            });
        }
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler(this);
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    private JComponent createTitlePane(JRootPane root) {
        return new SynthRootPaneTitlePane(root);
    }

    @Override
    protected void uninstallDefaults(JRootPane root) {
        SynthContext context = this.getContext(root, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && oldStyle != null) {
            this.uninstallKeyboardActions((JRootPane)c);
            this.installKeyboardActions((JRootPane)c);
        }
        context.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintRootPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintRootPaneBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName;
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JRootPane)e.getSource());
        }
        if ((propertyName = e.getPropertyName()) == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            this.installClientDecorations(root);
        } else if (propertyName.equals("ancestor") && ((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
            this.installWindowListeners(this.root, this.root.getParent());
        }
        super.propertyChange(e);
    }

    protected JComponent getTitlePane() {
        return this.titlePane;
    }

    protected Window getWindow() {
        return this.window;
    }

    protected JRootPane getRootPane() {
        return this.root;
    }

    private static class SynthRootLayout
    implements LayoutManager2 {
        private static final int MINSIZE = 10;
        private static final int PREFSIZE = 20;
        private static final int MAXSIZE = 30;

        private SynthRootLayout() {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent, 10);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent, 20);
        }

        @Override
        public Dimension maximumLayoutSize(Container parent) {
            return this.layoutSize(parent, 30);
        }

        protected Dimension layoutSize(Container parent, int sizeflag) {
            JComponent titlePane;
            Dimension cpd = null;
            Dimension mbd = null;
            Dimension tpd = null;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            if (root.getContentPane() != null) {
                switch (sizeflag) {
                    case 10: {
                        cpd = root.getContentPane().getMinimumSize();
                        break;
                    }
                    case 20: {
                        cpd = root.getContentPane().getPreferredSize();
                        break;
                    }
                    case 30: {
                        cpd = root.getContentPane().getMaximumSize();
                    }
                }
                if (cpd != null) {
                    cpWidth = this.limit(cpd.width);
                    cpHeight = this.limit(cpd.height);
                }
            }
            if (root.getJMenuBar() != null) {
                switch (sizeflag) {
                    case 10: {
                        mbd = root.getJMenuBar().getMinimumSize();
                        break;
                    }
                    case 20: {
                        mbd = root.getJMenuBar().getPreferredSize();
                        break;
                    }
                    case 30: {
                        mbd = root.getJMenuBar().getPreferredSize();
                    }
                }
                if (mbd != null) {
                    mbWidth = this.limit(mbd.width);
                    mbHeight = this.limit(mbd.height);
                }
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SynthRootPaneUI && (titlePane = ((SynthRootPaneUI)root.getUI()).getTitlePane()) != null) {
                switch (sizeflag) {
                    case 10: {
                        tpd = titlePane.getMinimumSize();
                        break;
                    }
                    case 20: {
                        tpd = titlePane.getPreferredSize();
                        break;
                    }
                    case 30: {
                        tpd = titlePane.getPreferredSize();
                    }
                }
                if (tpd != null) {
                    tpWidth = this.limit(tpd.width);
                    tpHeight = this.limit(tpd.height);
                }
            }
            Dimension d = new Dimension(Math.max(Math.max(tpWidth, mbWidth), cpWidth) + i.left + i.right, tpHeight + mbHeight + cpHeight + i.top + i.bottom);
            return d;
        }

        private int limit(int i) {
            return Math.min(i, 10240);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SynthRootPaneUI && (titlePane = ((SynthRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

