/*
 * Copyright (c) 2011, BSI Business Systems Integration AG. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. BSI Business Systems Integration AG
 * designates this particular file as subject to the "Classpath" exception as provided
 * by BSI Business Systems Integration AG in the LICENSE_BSI file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact BSI Business Systems Integration AG, Taefernstrasse 16a,
 * CH-5405 Baden, Switzerland or visit www.bsiag.com if you need additional
 * information or have any questions.
 */
package com.bsiag.javax.swing.plaf.synth;

import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

import org.eclipse.scout.rt.ui.swing.ext.DropDownButtonLayout;
import org.eclipse.scout.rt.ui.swing.ext.JDropDownButton;

/**
 * @author awe
 */
public class SynthDropDownButtonUI extends ComponentUI {

  AbstractButton m_pushButton;
  AbstractButton m_menuButton;

  private final static int MENU_BUTTON_WIDTH = 21;

  @Override
  public void installUI(JComponent c) {
    JDropDownButton dropDownButton = (JDropDownButton) c;

    m_pushButton = dropDownButton.getPushButton();
    m_pushButton.setName("DropDownButton.left");

    m_menuButton = dropDownButton.getMenuButton();
    m_menuButton.setName("DropDownButton.right");

    dropDownButton.setLayout(new DropDownButtonLayout(m_pushButton, m_menuButton, MENU_BUTTON_WIDTH));
  }

  public static ComponentUI createUI(JComponent c) {
    return new SynthDropDownButtonUI();
  }

}
