/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.javax.swing.plaf.synth;

import com.bsiag.javax.swing.plaf.synth.SynthRootPaneUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class MouseInputHandler
extends MouseInputAdapter {
    private static final int CORNER_DRAG_WIDTH = 4;
    private static final int BORDER_DRAG_THICKNESS = 4;
    private static final int[] cursorMapping;
    private final SynthRootPaneUI ui;
    private boolean isPressed;
    private boolean isMovingWindow;
    private int dragCursor;
    private int dragOffsetX;
    private int dragOffsetY;
    private int dragWidth;
    private int dragHeight;

    static {
        int[] nArray = new int[25];
        nArray[0] = 6;
        nArray[1] = 6;
        nArray[2] = 8;
        nArray[3] = 7;
        nArray[4] = 7;
        nArray[5] = 6;
        nArray[9] = 7;
        nArray[10] = 10;
        nArray[14] = 11;
        nArray[15] = 4;
        nArray[19] = 5;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 9;
        nArray[23] = 5;
        nArray[24] = 5;
        cursorMapping = nArray;
    }

    MouseInputHandler(SynthRootPaneUI ui) {
        this.ui = ui;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Window window = this.ui.getWindow();
        JRootPane rootPane = this.ui.getRootPane();
        if (e.getSource() != window) {
            return;
        }
        this.isPressed = false;
        this.checkCursor(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        Point convertedDragWindowOffset;
        int frameState;
        Window window = this.ui.getWindow();
        JComponent titlePane = this.ui.getTitlePane();
        if (ev.getSource() != window) {
            return;
        }
        this.isPressed = true;
        Point dragWindowOffset = ev.getPoint();
        Window w = (Window)ev.getSource();
        Frame f = null;
        Dialog d = null;
        if (w instanceof Frame) {
            f = (Frame)w;
        } else if (w instanceof Dialog) {
            d = (Dialog)w;
        }
        int n = frameState = f != null ? f.getExtendedState() : 0;
        if (this.dragCursor != 0) {
            if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
            }
        } else if (titlePane != null && titlePane.contains(convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, titlePane)) && (f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= 4 && dragWindowOffset.x >= 4 && dragWindowOffset.x < w.getWidth() - 4) {
            this.isMovingWindow = true;
            this.dragOffsetX = dragWindowOffset.x;
            this.dragOffsetY = dragWindowOffset.y;
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        Window w = (Window)ev.getSource();
        JRootPane rootPane = this.ui.getRootPane();
        Point pt = ev.getPoint();
        if (this.isMovingWindow) {
            Point windowPt = w.getLocationOnScreen();
            windowPt.x += pt.x - this.dragOffsetX;
            windowPt.y += pt.y - this.dragOffsetY;
            w.setLocation(windowPt);
        } else if (this.dragCursor != 0) {
            Rectangle r = w.getBounds();
            Rectangle startBounds = new Rectangle(r);
            Dimension min = w.getMinimumSize();
            switch (this.dragCursor) {
                case 11: {
                    this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                    break;
                }
                case 9: {
                    this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                    break;
                }
                case 8: {
                    this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                    break;
                }
                case 10: {
                    this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                    break;
                }
                case 7: {
                    this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                    break;
                }
                case 5: {
                    this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                    break;
                }
                case 6: {
                    this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                    break;
                }
                case 4: {
                    this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                    break;
                }
            }
            if (!r.equals(startBounds)) {
                w.setBounds(r);
                w.validate();
                rootPane.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.isPressed = false;
        Window window = this.ui.getWindow();
        JRootPane rootPane = this.ui.getRootPane();
        if (this.dragCursor != 0 && window != null && !window.isValid()) {
            window.validate();
            rootPane.repaint();
        }
        this.isMovingWindow = false;
        this.checkCursor(ev);
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        Point convertedPoint;
        Window w = (Window)ev.getSource();
        JComponent titlePane = this.ui.getTitlePane();
        Frame f = null;
        if (!(w instanceof Frame)) {
            return;
        }
        f = (Frame)w;
        int state = f.getExtendedState();
        if (titlePane != null && titlePane.contains(convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), titlePane)) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
            if ((state & 6) != 0) {
                f.setExtendedState(state & 0xFFFFFFF9);
            } else {
                f.setExtendedState(state | 6);
            }
            return;
        }
    }

    private void checkCursor(MouseEvent e) {
        Window window = this.ui.getWindow();
        if (!this.isPressed) {
            Point dragWindowOffset = e.getPoint();
            this.dragCursor = this.getCursor(this.calculateCorner(window, dragWindowOffset.x, dragWindowOffset.y));
            if (window instanceof Frame && (((Frame)window).getExtendedState() & 6) == 6) {
                this.dragCursor = 0;
            }
        }
        if (this.dragCursor != 0) {
            window.setCursor(Cursor.getPredefinedCursor(this.dragCursor));
        } else {
            window.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        bounds.x += deltaX;
        bounds.y += deltaY;
        bounds.width += deltaWidth;
        bounds.height += deltaHeight;
        if (min != null) {
            int correction;
            if (bounds.width < min.width) {
                correction = min.width - bounds.width;
                if (deltaX != 0) {
                    bounds.x -= correction;
                }
                bounds.width = min.width;
            }
            if (bounds.height < min.height) {
                correction = min.height - bounds.height;
                if (deltaY != 0) {
                    bounds.y -= correction;
                }
                bounds.height = min.height;
            }
        }
    }

    private int calculateCorner(Component c, int x, int y) {
        int xPosition = this.calculatePosition(x, c.getWidth());
        int yPosition = this.calculatePosition(y, c.getHeight());
        if (xPosition == -1 || yPosition == -1) {
            return -1;
        }
        return yPosition * 5 + xPosition;
    }

    private int getCursor(int corner) {
        if (corner == -1) {
            return 0;
        }
        return cursorMapping[corner];
    }

    private int calculatePosition(int spot, int width) {
        if (spot < 4) {
            return 0;
        }
        if (spot < 4) {
            return 1;
        }
        if (spot >= width - 4) {
            return 4;
        }
        if (spot >= width - 4) {
            return 3;
        }
        return 2;
    }
}

