/*
 * Copyright (c) 2002, 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.bsiag.javax.swing.plaf.synth;

import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.basic.BasicComboPopup;

/**
 * Synth's ComboPopup.
 * 
 * @author Scott Violet
 */
class SynthComboPopup extends BasicComboPopup {
  public SynthComboPopup(JComboBox combo) {
    super(combo);
  }

  /**
   * Configures the list which is used to hold the combo box items in the
   * popup. This method is called when the UI class
   * is created.
   * 
   * @see #createList
   */
  protected void configureList() {
    list.setFont(comboBox.getFont());
    list.setCellRenderer(comboBox.getRenderer());
    list.setFocusable(false);
    list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    int selectedIndex = comboBox.getSelectedIndex();
    if (selectedIndex == -1) {
      list.clearSelection();
    }
    else {
      list.setSelectedIndex(selectedIndex);
      list.ensureIndexIsVisible(selectedIndex);
    }
    installListListeners();
  }

  /**
   * (awe, ticket #90090) Override the configurePopup() method of BasicComboPopup, since the method accidentally
   * destroys the border set by Synth by calling setBorder(LIST_BORDER), which produces a black 1px border.
   */
  protected void configurePopup() {
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    setBorderPainted(true);
    setOpaque(false);
    add(scroller);
    setDoubleBuffered(true);
    setFocusable(false);
  }
}
