/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoCollapseButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.SynthLookAndFeel;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractFormToolButton;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJToolTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.SwingScoutHeaderPanel;

public class RayoToolTabsBar
extends AbstractJToolTabsBar {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RayoToolTabsBar.class);
    public static final String PROP_COLLAPSED = "collapsed";
    public static final String PROP_MINIMUM_SIZE = "minimumSize";
    private final ISwingEnvironment m_env;
    private Icon m_activeTabIcon;
    private boolean m_collapsed = true;
    private RayoCollapseButton m_collapseButton;
    private SwingScoutHeaderPanel m_swingScoutHeaderPanel;

    public RayoToolTabsBar(ISwingEnvironment env) {
        this.m_env = env;
        this.m_activeTabIcon = Activator.getIcon((String)"tool_tab");
        this.setLayout((LayoutManager)((Object)new Layout()));
        this.setName("Synth.ToolTabsBar");
        if (!(UIManager.getLookAndFeel() instanceof SynthLookAndFeel)) {
            this.setOpaque(true);
            this.setBackground(new Color(6793422));
        }
    }

    public void rebuild(IDesktop desktop) {
        this.removeAll();
        this.addCollapseButton();
        this.add(SwingUtility.createGlue((int)0, (int)0, (boolean)true, (boolean)false));
        ArrayList<String> textList = new ArrayList<String>();
        IToolButton[] iToolButtonArray = desktop.getToolButtons();
        int n = iToolButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolButton a = iToolButtonArray[n2];
            if (!(a instanceof AbstractFormToolButton)) {
                LOG.warn("Tool button of the type '" + a.getClass().getName() + "' is not supported by Rayo L&F");
            } else {
                ISwingScoutAction button = this.m_env.createAction((JComponent)((Object)this), (IAction)a);
                if (button != null) {
                    this.addToolTab((AbstractButton)button.getSwingField());
                    textList.add(a.getText());
                }
            }
            ++n2;
        }
        this.m_collapseButton.setPotentialTexts(textList);
    }

    protected void tabActivated(AbstractButton tab) {
        if (this.m_collapsed) {
            this.expandBar();
        }
        this.m_collapseButton.setText(tab.getText());
        this.firePropertyChange(PROP_MINIMUM_SIZE, -1, this.getMinimumSize());
        this.revalidateAndRepaint();
    }

    private void expandBar() {
        this.m_collapseButton.setVisible(true);
        this.revalidateAndRepaint();
        this.setCollapsed(false);
    }

    private void collapseBar() {
        if (this.isCollapsed()) {
            return;
        }
        if (this.getActiveTab() != null) {
            this.getActiveTab().setSelected(false);
        }
        this.m_collapseButton.setVisible(false);
        this.revalidateAndRepaint();
        this.setCollapsed(true);
    }

    public boolean isCollapsed() {
        return this.m_collapsed;
    }

    private void setCollapsed(boolean collapsed) {
        boolean oldCollapsed = this.m_collapsed;
        this.m_collapsed = collapsed;
        this.firePropertyChange(PROP_COLLAPSED, oldCollapsed, this.m_collapsed);
        this.m_swingScoutHeaderPanel.adjustToolButtonPanelWidth((int)this.getMinimumSize().getWidth(), false);
    }

    private void revalidateAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    private void addCollapseButton() {
        this.m_collapseButton = new RayoCollapseButton(this.m_env){
            private static final long serialVersionUID = 1L;

            public void hide() {
                super.hide();
                RayoToolTabsBar.this.collapseBar();
            }
        };
        if (this.isCollapsed()) {
            this.m_collapseButton.setVisible(false);
        }
        this.add((Component)((Object)this.m_collapseButton));
    }

    private void addToolTab(AbstractButton tab) {
        tab.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.add(tab);
        this.addActiveTabListener(tab);
        this.addToolBarChangedListener(tab);
    }

    private void addToolBarChangedListener(AbstractButton tab) {
        tab.addPropertyChangeListener("changedToolTabState", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean allTabsAreInactive = true;
                Component[] componentArray = RayoToolTabsBar.this.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof AbstractButton && ((AbstractButton)c).isSelected()) {
                        allTabsAreInactive = false;
                        break;
                    }
                    ++n2;
                }
                if (allTabsAreInactive) {
                    RayoToolTabsBar.this.collapseBar();
                }
            }
        });
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintActiveTabOnBackground(g);
    }

    private void paintActiveTabOnBackground(Graphics g) {
        AbstractButton tab = this.getActiveTab();
        Icon icon = this.m_activeTabIcon;
        if (tab != null && icon != null) {
            int x = tab.getX();
            int y = this.getHeight() - icon.getIconHeight();
            int w = tab.getWidth();
            int h = icon.getIconHeight();
            Shape oldClip = g.getClip();
            g.setClip(x, y, 6, h);
            icon.paintIcon((Component)((Object)this), g, x, y);
            g.setClip(x + 6, y, w - 12, h);
            int k = 0;
            while (k < w) {
                icon.paintIcon((Component)((Object)this), g, x + k, y);
                k += icon.getIconWidth();
            }
            g.setClip(x + w - 6, y, 6, h);
            icon.paintIcon((Component)((Object)this), g, x, y);
            g.setClip(oldClip);
        }
    }

    public void setSwingScoutHeaderPanel(SwingScoutHeaderPanel swingScoutHeaderPanel) {
        this.m_swingScoutHeaderPanel = swingScoutHeaderPanel;
    }

    private class Layout
    extends FlowLayoutEx {
        Layout() {
            super(2, 0, 0, 0);
            this.setFillVertical(true);
            this.setFillHorizontal(true);
        }

        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            Dimension d;
            if (RayoToolTabsBar.this.isCollapsed()) {
                d = super.getLayoutSize(parent, 1);
            } else {
                d = super.getLayoutSize(parent, 1);
                switch (sizeflag) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        d.width = 10240;
                    }
                }
            }
            if (!RayoToolTabsBar.this.isCollapsed()) {
                d.width = Math.max(d.width, UIManager.getInt("Synth.ToolButtonView.minWidth"));
            }
            d.height = 30;
            return d;
        }
    }
}

