/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.laf.rayo.painters;

import com.bsiag.javax.swing.plaf.synth.ColorType;
import com.bsiag.javax.swing.plaf.synth.SynthContext;
import com.bsiag.javax.swing.plaf.synth.SynthPainter;
import com.bsiag.javax.swing.plaf.synth.SynthTabbedPaneUI;
import com.bsiag.scout.rt.ui.swing.laf.rayo.painters.TextFieldColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.ColorUIResource;

public class RayoPainter
extends SynthPainter {
    private static final int ARROW_HEIGHT = 6;

    @Override
    public void paintTextFieldBackground(SynthContext context, Graphics g, int x, int y, int width, int height) {
        TextFieldColors bgColors = TextFieldColors.createFromContainer(context.getComponent().getParent());
        g.setColor(bgColors.background);
        g.fillRect(x, y, width, height);
        TextFieldColors colors = TextFieldColors.createFromComponent(context.getComponent());
        g.setColor(colors.background);
        g.fillRoundRect(x, y, width - 1, height - 1, 5, 5);
        this.paintBorder(colors, g, x, y, width, height);
    }

    @Override
    public void paintTextAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        TextFieldColors bgColors = TextFieldColors.createFromContainer(context.getComponent().getParent());
        g.setColor(bgColors.background);
        g.fillRect(x, y, w, h);
        TextFieldColors colors = TextFieldColors.createFromComponent(context.getComponent());
        g.setColor(colors.background);
        g.fillRect(x, y, w, h);
    }

    @Override
    public void paintPasswordFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintTextFieldBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        TextFieldColors colors = TextFieldColors.createFromComponent(this.guessInnerComponent(context.getComponent()));
        if ("Synth.TableScrollPane".equals(context.getComponent().getName())) {
            colors.border3D = colors.border;
        }
        this.paintBorder(colors, g, x, y, w, h);
    }

    @Override
    public void paintPanelBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        TextFieldColors colors = TextFieldColors.createFromComponent(this.guessInnerComponent(context.getComponent()));
        this.paintBorder(colors, g, x, y, w, h);
    }

    @Override
    public void paintScrollPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        TextFieldColors bgColors = TextFieldColors.createFromContainer(context.getComponent().getParent());
        g.setColor(bgColors.background);
        g.fillRect(x, y, w, h);
        TextFieldColors colors = TextFieldColors.createFromComponent(this.guessInnerComponent(context.getComponent()));
        g.setColor(colors.background);
        g.fillRoundRect(x, y, w - 1, h - 1, 5, 5);
    }

    private Component guessInnerComponent(Component presumablyAScrollPane) {
        JScrollPane sp;
        Component innerComponent = null;
        if (presumablyAScrollPane instanceof JScrollPane && (sp = (JScrollPane)presumablyAScrollPane).getViewport() != null) {
            innerComponent = sp.getViewport().getView();
        }
        if (innerComponent == null) {
            innerComponent = presumablyAScrollPane;
        }
        return innerComponent;
    }

    @Override
    public void paintTabbedPaneTabBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex) {
        JTabbedPane tabbedPane = (JTabbedPane)context.getComponent();
        if (tabIndex == tabbedPane.getSelectedIndex()) {
            Rectangle tabAreaBounds = ((SynthTabbedPaneUI)tabbedPane.getUI()).getTabAreaBounds();
            Color arrowColor = this.getLAFOrTabbedPaneColor(context, ColorType.FOREGROUND);
            g.setColor(arrowColor);
            this.paintSelectedTabArrow(g, x, y, w, tabAreaBounds.height);
        }
        super.paintTabbedPaneTabBorder(context, g, x, y, w, h, tabIndex);
    }

    private Color getLAFOrTabbedPaneColor(SynthContext context, ColorType colorType) {
        Color color = context.getComponent().getBackground();
        if (color == null || color instanceof ColorUIResource || !context.getComponent().isBackgroundSet()) {
            color = context.getStyle().getColor(context, colorType);
        }
        return color;
    }

    @Override
    public void paintTabbedPaneContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Color bgColor = this.getLAFOrTabbedPaneColor(context, ColorType.BACKGROUND);
        Color myColor = new Color(bgColor.getRGB());
        context.getComponent().setBackground(myColor);
        g.setColor(bgColor);
        g.fillRect(x, y, w, h);
    }

    private void paintSelectedTabArrow(Graphics g, int x, int y, int w, int h) {
        int i = 0;
        while (i < 6) {
            int iconY = h - 6 + i;
            int iconWidth = i * 2;
            int iconX = x + w / 2 - i;
            g.drawLine(iconX, iconY, iconX + iconWidth, iconY);
            ++i;
        }
    }

    private void paintBorder(TextFieldColors colors, Graphics g, int x, int y, int width, int height) {
        g.setColor(colors.border);
        g.drawRoundRect(x, y, width - 1, height - 1, 5, 5);
        if (colors.requiresBorder3D()) {
            this.paintBorder3D(g, y, width, colors.border3D);
        }
        this.paintAntiAliasing(g, width, height, colors.borderTranslucent);
    }

    private void paintBorder3D(Graphics g, int y, int width, Color border3D) {
        g.setColor(border3D);
        g.drawLine(3, y, width - 1 - 3, y);
    }

    private void paintAntiAliasing(Graphics g, int width, int height, Color borderTranslucent) {
        g.setColor(borderTranslucent);
        this.pixel(g, 1, 0);
        this.pixel(g, 0, 1);
        this.pixel(g, 2, 1);
        this.pixel(g, 1, 2);
        this.pixel(g, width - 2, 0);
        this.pixel(g, width - 1, 1);
        this.pixel(g, width - 3, 1);
        this.pixel(g, width - 2, 2);
        this.pixel(g, width - 2, height - 3);
        this.pixel(g, width - 1, height - 2);
        this.pixel(g, width - 3, height - 2);
        this.pixel(g, width - 2, height - 1);
        this.pixel(g, 1, height - 3);
        this.pixel(g, 0, height - 2);
        this.pixel(g, 2, height - 2);
        this.pixel(g, 1, height - 1);
    }

    private void pixel(Graphics g, int x, int y) {
        g.drawLine(x, y, x, y);
    }
}

