/*
 * Copyright (c) 2011, BSI Business Systems Integration AG. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. BSI Business Systems Integration AG
 * designates this particular file as subject to the "Classpath" exception as provided
 * by BSI Business Systems Integration AG in the LICENSE_BSI file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact BSI Business Systems Integration AG, Taefernstrasse 16a,
 * CH-5405 Baden, Switzerland or visit www.bsiag.com if you need additional
 * information or have any questions.
 */
package com.bsiag.scout.rt.ui.swing.laf.rayo.tests;

import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ScrollPaneConstants;

import com.bsiag.scout.rt.ui.swing.laf.rayo.Rayo;

public class TestWideTable {
  public static void main(String[] args) {
    new Rayo().installLookAndFeel();

    JFrame frame = new JFrame("TestWideTable");

    String[] columnNames = {"First Name",
        "Last Name",
        "Sport",
        "# of Years",
        "Vegetarian"};

    Object[][] data = {
        {"Mary", "Campione",
            "Snowboarding", new Integer(5), new Boolean(false)},
        {"Alison", "Huml",
            "Rowing", new Integer(3), new Boolean(true)},
        {"Kathy", "Walrath",
            "Knitting", new Integer(2), new Boolean(false)},
        {"Sharon", "Zakhour",
            "Speed reading", new Integer(20), new Boolean(true)},
        {"Philip", "Milne",
            "Pool", new Integer(10), new Boolean(false)}
    };

    JTable table = new JTable(data, columnNames);
    table.setName("Synth.WideTable");
    JScrollPane scrollPane = new JScrollPane(table);
    scrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

    frame.getContentPane().add(scrollPane);
    frame.getContentPane().setLayout(new BorderLayout(0, 0));
    frame.getContentPane().add(scrollPane, BorderLayout.CENTER);

    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.pack();
    frame.setSize(600, 600);
    frame.setVisible(true);
  }
}
