/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.SynthLookAndFeel;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.menubar.SwingScoutMainMenuPopup;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJViewTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.HandCursorAdapater;

public class RayoViewTabsBar
extends AbstractJViewTabsBar {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RayoViewTabsBar.class);
    private static final long serialVersionUID = 1L;
    public static final int TABS_BAR_HEIGHT = 30;
    private Icon m_activeTabLeftIcon;
    private Icon m_activeTabRightIcon;
    private IconGroup m_menuIcon;
    private IDesktop m_desktop;
    private JLabel m_menuLabel;
    private SwingScoutMainMenuPopup m_popupMenu;
    private ISwingEnvironment m_env;

    public RayoViewTabsBar(ISwingEnvironment env) {
        this.m_env = env;
        this.m_activeTabLeftIcon = Activator.getIcon((String)"view_tab_left");
        this.m_activeTabRightIcon = Activator.getIcon((String)"view_tab_right");
        this.m_menuIcon = new IconGroup("icon_menu");
        this.setName("Synth.ViewTabsBar");
        this.setLayout((LayoutManager)((Object)new Layout()));
        this.setOpaque(true);
        if (!(UIManager.getLookAndFeel() instanceof SynthLookAndFeel)) {
            this.setBackground(new Color(14543860));
        }
    }

    public void rebuild(IDesktop desktop) {
        this.removeAll();
        if (this.isShowMenuBar()) {
            this.addMenuIcon();
            this.add(SwingUtility.createGlue((int)5, (int)5, (boolean)false, (boolean)false));
        }
        IViewButton[] iViewButtonArray = desktop.getViewButtons();
        int n = iViewButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewButton a = iViewButtonArray[n2];
            ISwingScoutAction button = this.m_env.createAction((JComponent)((Object)this), (IAction)a);
            if (button != null) {
                this.addViewTab((AbstractButton)button.getSwingField());
            }
            ++n2;
        }
        this.add(SwingUtility.createGlue((int)0, (int)0, (boolean)true, (boolean)false));
        if (this.isShowMenuBar()) {
            this.m_popupMenu = new SwingScoutMainMenuPopup();
            this.m_popupMenu.createField((IPropertyObserver)desktop, this.m_env);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintActiveTabOnBackground(g);
    }

    private boolean isShowMenuBar() {
        return "toolbar".equals(UIManager.get("MenuBar.policy"));
    }

    private AbstractButton addViewTab(AbstractButton tab) {
        this.addActiveTabListener(tab);
        tab.setBorder(new EmptyBorder(3, 12, 0, 14));
        this.add(tab);
        return tab;
    }

    private void addMenuIcon() {
        this.m_menuLabel = new JLabel();
        this.m_menuLabel.setIcon(this.m_menuIcon.getIcon(IconGroup.IconState.NORMAL));
        this.m_menuLabel.setBorder(new EmptyBorder(3, 3, 2, 0));
        new HandCursorAdapater((JComponent)this.m_menuLabel);
        this.m_menuLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (RayoViewTabsBar.this.m_popupMenu.getScoutObject() != null) {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((IDesktop)RayoViewTabsBar.this.m_popupMenu.getScoutObject()).prepareAllMenus();
                        }
                    };
                    JobEx job = RayoViewTabsBar.this.m_env.invokeScoutLater(t, 5000L);
                    try {
                        job.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.warn("Exception occured while preparing all menus.", (Throwable)ex);
                    }
                }
                RayoViewTabsBar.this.m_popupMenu.getSwingPopupMenu().show(RayoViewTabsBar.this.m_menuLabel, 0, RayoViewTabsBar.this.m_menuLabel.getHeight());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RayoViewTabsBar.this.m_menuLabel.setIcon(RayoViewTabsBar.this.m_menuIcon.getIcon(IconGroup.IconState.ROLLOVER));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RayoViewTabsBar.this.m_menuLabel.setIcon(RayoViewTabsBar.this.m_menuIcon.getIcon(IconGroup.IconState.NORMAL));
            }
        });
        this.add(this.m_menuLabel);
    }

    private void paintActiveTabOnBackground(Graphics g) {
        AbstractButton tab = this.getActiveTab();
        if (tab == null) {
            return;
        }
        Insets i = tab.getInsets();
        int y = i.top;
        int x = tab.getX() + i.left - this.m_activeTabLeftIcon.getIconWidth();
        this.m_activeTabLeftIcon.paintIcon((Component)((Object)this), g, x, y);
        x = tab.getX() + tab.getWidth() - i.right;
        this.m_activeTabRightIcon.paintIcon((Component)((Object)this), g, x, y);
        x = tab.getX() + i.left;
        g.setColor(Color.WHITE);
        g.fillRect(x, y, tab.getWidth() - i.right - i.left, this.getHeight() - y);
    }

    private class Layout
    extends FlowLayoutEx {
        Layout() {
            super(2, 0, 0, 0);
            this.setFillVertical(true);
            this.setFillHorizontal(true);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = super.minimumLayoutSize(parent);
            d.height = 30;
            return d;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = super.preferredLayoutSize(parent);
            d.height = 30;
            return d;
        }

        public Dimension maximumLayoutSize(Container parent) {
            Dimension d = super.maximumLayoutSize(parent);
            d.width = 10240;
            d.height = 30;
            return d;
        }
    }
}

