/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.form.fields.tabbox;

import javax.swing.Icon;

import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.form.fields.tabbox.SwingScoutTabItem;

import com.bsiag.scout.rt.ui.swing.rayo.RayoIcons;

/**
 * Replacement for SwingScoutTabItem. Paints an orange dot instead of an orange underline.
 * 
 * @author awe
 */
public class RayoSwingScoutTabItem extends SwingScoutTabItem {
  private Icon m_changedIcon;

  @Override
  protected SwingTabIcon createSwingTabIcon() {
    SwingTabIcon tabIcon = super.createSwingTabIcon();
    tabIcon.setMarkerIcon(Activator.getIcon(RayoIcons.TabDirtyMarker));
    return tabIcon;
  }
}
