/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package com.bsiag.scout.rt.ui.swing.rayo.action;

import java.awt.Insets;

import javax.swing.AbstractButton;

import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutViewTab;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoViewTab;

public class RayoSwingScoutViewTab extends SwingScoutViewTab {

  @Override
  protected AbstractButton createButton(ISwingEnvironment env) {
    RayoViewTab swingButton = new RayoViewTab();
    swingButton.setMargin(new Insets(8, 4, 8, 4));
    return swingButton;
  }

  @Override
  protected void setIconIdFromScout(String iconId) {
    // no icons for view tabs
  }
}
