package com.bsiag.scout.rt.ui.swing.rayo;

import java.awt.Image;

import javax.swing.Icon;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends Plugin implements RayoIcons {

  // The plug-in ID
  public static final String PLUGIN_ID = "com.bsiag.scout.rt.ui.swing.rayo";

  private static Activator plugin;

  public Activator() {
  }

  @Override
  public void start(BundleContext context) throws Exception {
    super.start(context);
    plugin = this;
  }

  @Override
  public void stop(BundleContext context) throws Exception {
    plugin = null;
    super.stop(context);
  }

  public static Activator getDefault() {
    return plugin;
  }

  public static Image getImage(String name) {
    return getDefault().getImageImpl(name);
  }

  private Image getImageImpl(String name) {
    /*
     * Rayo specific images are contributed by the fragment
     * org.eclipse.scout.rt.ui.swing.laf.orson.fragment to the
     * Swing Plug-In org.eclipse.scout.rt.ui.swing.
     */
    return org.eclipse.scout.rt.ui.swing.Activator.getImage(name);
  }

  public static Icon getIcon(String name) {
    /*
     * Rayo specific images are contributed by the fragment
     * org.eclipse.scout.rt.ui.swing.laf.orson.fragment to the
     * Swing Plug-In org.eclipse.scout.rt.ui.swing.
     */
    return org.eclipse.scout.rt.ui.swing.Activator.getIcon(name);
  }
}
